/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.io;

import java.util.Stack;
import org.jopendocument.io.SaxContentUnmarshaller;
import org.jopendocument.io.StyleTableProperties;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.model.office.OfficeAutomaticStyles;
import org.jopendocument.model.office.OfficeMasterStyles;
import org.jopendocument.model.office.OfficeStyles;
import org.jopendocument.model.script.StyleGraphicProperties;
import org.jopendocument.model.style.StyleDefaultStyle;
import org.jopendocument.model.style.StyleListLevelLabelAlignment;
import org.jopendocument.model.style.StyleListLevelProperties;
import org.jopendocument.model.style.StyleMasterPage;
import org.jopendocument.model.style.StylePageLayout;
import org.jopendocument.model.style.StylePageLayoutProperties;
import org.jopendocument.model.style.StyleParagraphProperties;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.style.StyleTabStop;
import org.jopendocument.model.style.StyleTabStops;
import org.jopendocument.model.style.StyleTableColumnProperties;
import org.jopendocument.model.style.StyleTextProperties;
import org.jopendocument.model.text.TextListLevelStyleBullet;
import org.jopendocument.model.text.TextListLevelStyleNumber;
import org.jopendocument.model.text.TextListStyle;
import org.jopendocument.model.text.TextOutlineLevelStyle;
import org.jopendocument.model.text.TextOutlineStyle;
import org.jopendocument.util.ValueHelper;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SaxStylesUnmarshaller
extends DefaultHandler {
    private OfficeStyles styles = new OfficeStyles();
    private OfficeAutomaticStyles autoStyles;
    private OfficeMasterStyles masterStyles;
    private Stack<Object> stack = new Stack();
    private Object current;
    private final OpenDocument doc;

    public SaxStylesUnmarshaller(OpenDocument openDocument) {
        this.doc = openDocument;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equals("office:styles")) {
            this.styles = new OfficeStyles();
            this.push(this.styles);
        } else if (string3.equals("style:default-style")) {
            StyleDefaultStyle styleDefaultStyle = new StyleDefaultStyle();
            styleDefaultStyle.setStyleFamily(attributes.getValue("style:family"));
            if (this.current instanceof OfficeStyles) {
                ((OfficeStyles)this.current).addDefaultStyle(styleDefaultStyle);
            } else {
                SaxContentUnmarshaller.log("Not OfficeStyles:" + this.current, false);
            }
            this.push(styleDefaultStyle);
        } else if (string3.equals("style:text-properties")) {
            StyleTextProperties styleTextProperties = new StyleTextProperties();
            styleTextProperties.setFontName(attributes.getValue("style:font-name"));
            if (this.current instanceof StyleDefaultStyle) {
                ((StyleDefaultStyle)this.current).setStyleTextProperties(styleTextProperties);
            } else if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setTextProperties(styleTextProperties);
            } else if (this.current instanceof TextListLevelStyleBullet) {
                ((TextListLevelStyleBullet)this.current).setTextProperties(styleTextProperties);
            } else {
                SaxContentUnmarshaller.log("Not StyleDefaultStyle:" + this.current, false);
            }
            this.push(styleTextProperties);
        } else if (string3.equals("office:automatic-styles")) {
            this.autoStyles = new OfficeAutomaticStyles();
            this.push(this.autoStyles);
        } else if (string3.equals("style:page-layout")) {
            StylePageLayout stylePageLayout = new StylePageLayout();
            stylePageLayout.setStyleName(attributes.getValue("style:name"));
            if (this.current instanceof OfficeAutomaticStyles) {
                this.autoStyles.addPageLayout(stylePageLayout);
            } else {
                SaxContentUnmarshaller.log("Not OfficeAutomaticStyles:" + this.current, false);
            }
            this.push(stylePageLayout);
        } else if (string3.equals("style:page-layout-properties")) {
            StylePageLayoutProperties stylePageLayoutProperties = new StylePageLayoutProperties();
            stylePageLayoutProperties.setPageWidth(attributes.getValue("fo:page-width"));
            stylePageLayoutProperties.setPageHeight(attributes.getValue("fo:page-height"));
            stylePageLayoutProperties.setMarginTop(attributes.getValue("fo:margin-top"));
            stylePageLayoutProperties.setMarginBottom(attributes.getValue("fo:margin-bottom"));
            stylePageLayoutProperties.setMarginLeft(attributes.getValue("fo:margin-left"));
            stylePageLayoutProperties.setMarginRight(attributes.getValue("fo:margin-right"));
            stylePageLayoutProperties.setShadow(attributes.getValue("style:shadow"));
            stylePageLayoutProperties.setBackgroundColor(attributes.getValue("fo:background-color"));
            stylePageLayoutProperties.setScaleTo(attributes.getValue("style:scale-to"));
            stylePageLayoutProperties.setTableCentering(attributes.getValue("style:table-centering"));
            stylePageLayoutProperties.setWritingMode(attributes.getValue("style:writing-mode"));
            if (this.current instanceof StylePageLayout) {
                ((StylePageLayout)this.current).setPageLayoutProperties(stylePageLayoutProperties);
            } else {
                SaxContentUnmarshaller.log("Not StylePageLayout:" + this.current, false);
            }
            this.push(stylePageLayoutProperties);
        } else if (string3.equals("office:master-styles")) {
            this.masterStyles = new OfficeMasterStyles();
            this.push(this.masterStyles);
        } else if (string3.equals("style:master-page")) {
            StyleMasterPage styleMasterPage = new StyleMasterPage();
            styleMasterPage.setStyleName(attributes.getValue("style:name"));
            styleMasterPage.setStylePageLayoutName(attributes.getValue("style:page-layout-name"));
            if (this.current instanceof OfficeMasterStyles) {
                this.masterStyles.addMasterPage(styleMasterPage);
            } else {
                SaxContentUnmarshaller.log("Not OfficeMasterStyles:" + this.current, false);
            }
            this.push(styleMasterPage);
        } else if (string3.equals("style:style")) {
            StyleStyle styleStyle = new StyleStyle();
            styleStyle.setStyleName(attributes.getValue("style:name"));
            styleStyle.setStyleFamily(attributes.getValue("style:family"));
            styleStyle.setStyleParentStyleName(attributes.getValue("style:parent-style-name"));
            styleStyle.setMasterPageName(attributes.getValue("style:master-page-name"));
            if (this.current instanceof OfficeStyles) {
                this.doc.getStyleResolver().add(styleStyle);
                this.styles.addStyle(styleStyle);
            } else if (this.current instanceof OfficeAutomaticStyles) {
                this.doc.getStyleResolver().add(styleStyle);
                this.styles.addStyle(styleStyle);
            } else {
                SaxContentUnmarshaller.log("Not OfficeStyles: " + this.current + " style: " + styleStyle.getStyleName());
            }
            this.push(styleStyle);
        } else if (string3.equals("style:paragraph-properties")) {
            StyleParagraphProperties styleParagraphProperties = new StyleParagraphProperties();
            styleParagraphProperties.setTextAlign(attributes.getValue("fo:text-align"));
            styleParagraphProperties.setMarginLeft(attributes.getValue("fo:margin-left"));
            if (this.current instanceof StyleDefaultStyle) {
                ((StyleDefaultStyle)this.current).setParagraphProperties(styleParagraphProperties);
            } else if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setParagraphProperties(styleParagraphProperties);
            } else {
                SaxContentUnmarshaller.log("Not StyleDefaultStyle:" + this.current);
            }
            this.push(styleParagraphProperties);
        } else if (string3.equals("style:table-properties")) {
            StyleTableProperties styleTableProperties = new StyleTableProperties();
            styleTableProperties.setBorderModel(attributes.getValue("table:border-model"));
            if (this.current instanceof StyleDefaultStyle) {
                ((StyleDefaultStyle)this.current).setTableProperties(styleTableProperties);
            } else if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setTableProperties(styleTableProperties);
            } else {
                SaxContentUnmarshaller.log("Not StyleDefaultStyle:" + this.current);
            }
            this.push(styleTableProperties);
        } else if (string3.equals("style:table-column-properties")) {
            StyleTableColumnProperties styleTableColumnProperties = new StyleTableColumnProperties();
            if (attributes.getValue("style:column-width") != null) {
                styleTableColumnProperties.setStyleColumnWidth(attributes.getValue("style:column-width"));
            }
            if (attributes.getValue("style:rel-column-width") != null) {
                styleTableColumnProperties.setStyleRelColumnWidth(attributes.getValue("style:rel-column-width"));
            }
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setTableColumnProperties(styleTableColumnProperties);
            } else {
                SaxContentUnmarshaller.log("Not StyleStyle:" + this.current);
            }
            this.push(styleTableColumnProperties);
        } else if (string3.equals("style:tab-stops")) {
            StyleTabStops styleTabStops = new StyleTabStops();
            if (this.current instanceof StyleParagraphProperties) {
                ((StyleParagraphProperties)this.current).addTabStops(styleTabStops);
            } else {
                SaxContentUnmarshaller.log("StyleParagraphProperties:" + this.current);
            }
            this.push(styleTabStops);
        } else if (string3.equals("style:tab-stop")) {
            StyleTabStop styleTabStop = new StyleTabStop();
            styleTabStop.setStylePosition(attributes.getValue("style:position"));
            if (this.current instanceof StyleTabStops) {
                ((StyleTabStops)this.current).add(styleTabStop);
            } else {
                SaxContentUnmarshaller.log("StyleTabStops:" + this.current);
            }
            this.push(styleTabStop);
        } else if (string3.equals("style:graphic-properties")) {
            StyleGraphicProperties styleGraphicProperties = new StyleGraphicProperties();
            styleGraphicProperties.setMarginLeft(attributes.getValue("fo:margin-left"));
            styleGraphicProperties.setMarginRight(attributes.getValue("fo:margin-right"));
            styleGraphicProperties.setMarginTop(attributes.getValue("fo:margin-top"));
            styleGraphicProperties.setMarginBottom(attributes.getValue("fo:margin-bottom"));
            styleGraphicProperties.setProtection(attributes.getValue("style:protect"));
            styleGraphicProperties.setWrap(attributes.getValue("style:wrap"));
            styleGraphicProperties.setNumberWrappedParagraphs(attributes.getValue("style:number-wrapped-paragraphs"));
            styleGraphicProperties.setVerticalPosition(attributes.getValue("style:vertical-pos"));
            styleGraphicProperties.setVerticalRelative(attributes.getValue("style:vertical-rel"));
            styleGraphicProperties.setHorizontalPosition(attributes.getValue("style:horizontal-pos"));
            styleGraphicProperties.setHorizontalRelative(attributes.getValue("style:horizontal-rel"));
            styleGraphicProperties.setPadding(attributes.getValue("fo:padding"));
            styleGraphicProperties.setBorder(attributes.getValue("fo:border"));
            styleGraphicProperties.setShadow(attributes.getValue("style:shadow"));
            if (this.current instanceof StyleDefaultStyle) {
                ((StyleDefaultStyle)this.current).setGraphicProperties(styleGraphicProperties);
            } else if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setGraphicProperties(styleGraphicProperties);
            } else {
                SaxContentUnmarshaller.log("Not StyleDefaultStyle:" + this.current);
            }
            this.push(styleGraphicProperties);
        } else if (string3.equals("text:list-level-style-number")) {
            TextListLevelStyleNumber textListLevelStyleNumber = new TextListLevelStyleNumber();
            textListLevelStyleNumber.setTextLevel(attributes.getValue("text:level"));
            textListLevelStyleNumber.setTextStyleName(attributes.getValue("text:style-name"));
            textListLevelStyleNumber.setStyleNumSuffix(attributes.getValue("style:num-suffix"));
            textListLevelStyleNumber.setStyleNumPrefix(attributes.getValue("style:num-prefix"));
            textListLevelStyleNumber.setStyleNumFormat(attributes.getValue("style:num-format"));
            textListLevelStyleNumber.setTextStartValue(attributes.getValue("text:start-value"));
            if (this.current instanceof TextListStyle) {
                ((TextListStyle)this.current).addListLevelStyleNumber(textListLevelStyleNumber);
            } else {
                SaxContentUnmarshaller.log("Not TextListStyle: " + this.current);
            }
            this.push(textListLevelStyleNumber);
        } else if (string3.equals("style:list-level-properties")) {
            StyleListLevelProperties styleListLevelProperties = new StyleListLevelProperties();
            styleListLevelProperties.setSpaceBefore(attributes.getValue("text:space-before"));
            styleListLevelProperties.setMinLabelWidth(attributes.getValue("text:min-label-width"));
            if (this.current instanceof TextListLevelStyleBullet) {
                ((TextListLevelStyleBullet)this.current).setStyleListLevelProperties(styleListLevelProperties);
            } else if (this.current instanceof TextListLevelStyleNumber) {
                ((TextListLevelStyleNumber)this.current).setStyleListLevelProperties(styleListLevelProperties);
            } else if (this.current instanceof TextOutlineLevelStyle) {
                ((TextOutlineLevelStyle)this.current).setStyleListLevelProperties(styleListLevelProperties);
            } else {
                SaxContentUnmarshaller.log("Not TextListLevelStyleBullet: " + this.current);
            }
            this.push(styleListLevelProperties);
        } else if (string3.equals("style:list-level-label-alignment")) {
            StyleListLevelLabelAlignment styleListLevelLabelAlignment = new StyleListLevelLabelAlignment();
            styleListLevelLabelAlignment.setLabelFollowedBy(attributes.getValue("text:label-followed-by"));
            styleListLevelLabelAlignment.setListTabStopPosition(ValueHelper.getLength(attributes.getValue("text:list-tab-stop-position")));
            styleListLevelLabelAlignment.setTextIndent(ValueHelper.getLength(attributes.getValue("fo:text-indent")));
            styleListLevelLabelAlignment.setMarginLeft(ValueHelper.getLength(attributes.getValue("fo:margin-left")));
            if (this.current instanceof StyleListLevelProperties) {
                ((StyleListLevelProperties)this.current).setListLevelLabelAlignment(styleListLevelLabelAlignment);
            } else {
                SaxContentUnmarshaller.log("Not StyleListLevelProperties: " + this.current);
            }
            this.push(styleListLevelLabelAlignment);
        } else if (string3.equals("text:outline-style")) {
            TextOutlineStyle textOutlineStyle = new TextOutlineStyle();
            textOutlineStyle.setStyleName(attributes.getValue("style:name"));
            if (this.current instanceof OfficeStyles) {
                ((OfficeStyles)this.current).addStyle(textOutlineStyle);
            } else {
                SaxContentUnmarshaller.log("Not TextOutlineStyle: " + this.current);
            }
            this.push(textOutlineStyle);
        } else if (string3.equals("text:outline-level-style")) {
            TextOutlineLevelStyle textOutlineLevelStyle = new TextOutlineLevelStyle();
            textOutlineLevelStyle.setTextLevel(attributes.getValue("text:level"));
            textOutlineLevelStyle.setStyleNumFormat(attributes.getValue("style:num-format"));
            if (this.current instanceof TextOutlineStyle) {
                ((TextOutlineStyle)this.current).addTextOutlineLevelStyle(textOutlineLevelStyle);
            } else {
                SaxContentUnmarshaller.log("Not TextOutlineStyle: " + this.current);
            }
            this.push(textOutlineLevelStyle);
        } else if (string3.equals("text:list-style")) {
            TextListStyle textListStyle = new TextListStyle();
            textListStyle.setStyleName(attributes.getValue("style:name"));
            if (this.current instanceof OfficeStyles) {
                ((OfficeStyles)this.current).addStyle(textListStyle);
            } else {
                SaxContentUnmarshaller.log("Not OfficeStyles: " + this.current);
            }
            this.push(textListStyle);
        } else if (string3.equals("text:list-level-style-bullet")) {
            TextListLevelStyleBullet textListLevelStyleBullet = new TextListLevelStyleBullet();
            textListLevelStyleBullet.setTextLevel(attributes.getValue("text:level"));
            textListLevelStyleBullet.setTextStyleName(attributes.getValue("text:style-name"));
            textListLevelStyleBullet.setStyleNumSuffix(attributes.getValue("style:num-suffix"));
            textListLevelStyleBullet.setStyleNumPrefix(attributes.getValue("style:num-prefix"));
            textListLevelStyleBullet.setTextBulletChar(attributes.getValue("text:bullet-char"));
            if (this.current instanceof TextListStyle) {
                ((TextListStyle)this.current).addListLevelStyleBullet(textListLevelStyleBullet);
            } else {
                SaxContentUnmarshaller.log("Not TextListStyle: " + this.current);
            }
            this.push(textListLevelStyleBullet);
        } else if (string3.equals("office:font-face-decls") || string3.equals("style:font-face")) {
            this.push(string);
        } else {
            SaxContentUnmarshaller.log("style.xml : ignoring :" + string3 + " current:" + this.current, false);
            this.push(string);
        }
    }

    private void push(Object object) {
        this.current = object;
        this.stack.push(object);
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.pop();
    }

    private void pop() {
        if (!this.stack.isEmpty()) {
            this.stack.pop();
        }
        if (!this.stack.isEmpty()) {
            this.current = this.stack.peek();
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
    }

    public OfficeStyles getStyles() {
        return this.styles;
    }

    public OfficeMasterStyles getMasterStyles() {
        return this.masterStyles;
    }

    public OfficeAutomaticStyles getAutomaticStyles() {
        return this.autoStyles;
    }
}

