/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.io;

import java.util.List;
import java.util.Stack;
import org.jopendocument.io.FontFaceDecls;
import org.jopendocument.io.StyleTableProperties;
import org.jopendocument.io.UnusedElement;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.model.draw.DrawFrame;
import org.jopendocument.model.draw.DrawImage;
import org.jopendocument.model.draw.DrawTextBox;
import org.jopendocument.model.number.NumberDateStyle;
import org.jopendocument.model.number.NumberDay;
import org.jopendocument.model.number.NumberMonth;
import org.jopendocument.model.number.NumberNumberStyle;
import org.jopendocument.model.number.NumberText;
import org.jopendocument.model.number.NumberYear;
import org.jopendocument.model.office.OfficeAutomaticStyles;
import org.jopendocument.model.office.OfficeBody;
import org.jopendocument.model.office.OfficeScripts;
import org.jopendocument.model.office.OfficeSpreadsheet;
import org.jopendocument.model.office.OfficeText;
import org.jopendocument.model.script.StyleGraphicProperties;
import org.jopendocument.model.style.StyleColumns;
import org.jopendocument.model.style.StyleFontFace;
import org.jopendocument.model.style.StyleListLevelProperties;
import org.jopendocument.model.style.StyleParagraphProperties;
import org.jopendocument.model.style.StyleSectionProperties;
import org.jopendocument.model.style.StyleStyle;
import org.jopendocument.model.style.StyleTabStop;
import org.jopendocument.model.style.StyleTabStops;
import org.jopendocument.model.style.StyleTableCellProperties;
import org.jopendocument.model.style.StyleTableColumnProperties;
import org.jopendocument.model.style.StyleTableRowProperties;
import org.jopendocument.model.style.StyleTextProperties;
import org.jopendocument.model.table.TableShapes;
import org.jopendocument.model.table.TableTable;
import org.jopendocument.model.table.TableTableCell;
import org.jopendocument.model.table.TableTableColumn;
import org.jopendocument.model.table.TableTableHeaderColumns;
import org.jopendocument.model.table.TableTableRow;
import org.jopendocument.model.text.TextA;
import org.jopendocument.model.text.TextBookmark;
import org.jopendocument.model.text.TextBookmarkEnd;
import org.jopendocument.model.text.TextDate;
import org.jopendocument.model.text.TextH;
import org.jopendocument.model.text.TextIndexBody;
import org.jopendocument.model.text.TextLineBreak;
import org.jopendocument.model.text.TextList;
import org.jopendocument.model.text.TextListItem;
import org.jopendocument.model.text.TextListLevelStyleBullet;
import org.jopendocument.model.text.TextListLevelStyleNumber;
import org.jopendocument.model.text.TextListStyle;
import org.jopendocument.model.text.TextP;
import org.jopendocument.model.text.TextSoftPageBreak;
import org.jopendocument.model.text.TextSpan;
import org.jopendocument.model.text.TextTab;
import org.jopendocument.model.text.TextTableOfContent;
import org.jopendocument.util.ExceptionUtils;
import org.jopendocument.util.Log;
import org.jopendocument.util.ValueHelper;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SaxContentUnmarshaller
extends DefaultHandler {
    private OfficeAutomaticStyles autostyles;
    private OfficeBody body;
    private Object current;
    private final OpenDocument document;
    private FontFaceDecls fontDeclarations;
    private OfficeScripts scripts;
    private final Stack<Object> stack;

    static void log(String string) {
        SaxContentUnmarshaller.log(string, true);
    }

    static void log(String string, boolean bl) {
        Log.get().fine(string);
        if (bl) {
            Log.get().fine(ExceptionUtils.getStackTrace(new Exception("dump stack")));
        }
    }

    public SaxContentUnmarshaller(OpenDocument openDocument) {
        this.document = openDocument;
        this.stack = new Stack();
    }

    private void assertParsed(Attributes attributes, int n) {
        if (attributes.getLength() > n) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                SaxContentUnmarshaller.log(attributes.getQName(i) + "  -> " + attributes.getValue(i), false);
            }
            throw new IllegalStateException("Somme attributes are not parsed");
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray, n, n2);
        if (this.current instanceof TextP) {
            ((TextP)this.current).addToLastTextSpan(stringBuffer.toString());
        } else if (this.current instanceof TextSpan) {
            ((TextSpan)this.current).concatValue(stringBuffer.toString());
        } else if (this.current instanceof NumberText) {
            ((NumberText)this.current).concatValue(stringBuffer.toString());
        } else if (this.current instanceof TextA) {
            ((TextA)this.current).concatValue(stringBuffer.toString());
        } else if (this.current instanceof TextH) {
            ((TextH)this.current).concatValue(stringBuffer.toString());
        } else if (this.current instanceof TextDate) {
            ((TextDate)this.current).concatValue(stringBuffer.toString());
        } else if (stringBuffer.length() > 0) {
            SaxContentUnmarshaller.log(this.current + ":" + this.current.getClass() + " ?'" + stringBuffer.toString() + "'");
            System.exit(0);
        }
    }

    private static void dumpAttributes(Attributes attributes) {
        SaxContentUnmarshaller.log("Dump attributes:", false);
        for (int i = 0; i < attributes.getLength(); ++i) {
            SaxContentUnmarshaller.log("'" + attributes.getQName(i) + "'  -> '" + attributes.getValue(i) + "'", false);
        }
    }

    public void dumpAutoStyles() {
        List<StyleStyle> list = this.autostyles.getStyles();
        for (StyleStyle styleStyle : list) {
            System.out.println(styleStyle);
        }
    }

    public void dumpSpreadSheets() {
        List<OfficeSpreadsheet> list = this.body.getOfficeSpreadsheets();
        for (OfficeSpreadsheet officeSpreadsheet : list) {
            System.out.println(officeSpreadsheet);
            List<TableTable> list2 = officeSpreadsheet.getTables();
            for (TableTable tableTable : list2) {
                this.dumpRows(tableTable);
                List<TableTableColumn> list3 = tableTable.getColumnsInRange(tableTable.getPrintStartCol(), tableTable.getPrintStopCol());
                for (TableTableColumn tableTableColumn : list3) {
                    System.out.println(tableTableColumn.getWidth());
                }
            }
        }
    }

    private void dumpRows(TableTable tableTable) {
        for (TableTableRow tableTableRow : tableTable.getRows()) {
            TableTableCell[] tableTableCellArray;
            for (TableTableCell tableTableCell : tableTableCellArray = tableTableRow.getCellsInRange(tableTable.getPrintStartCol(), tableTable.getPrintStopCol())) {
                if (tableTableCell.getTextP() == null) continue;
                TextP textP = tableTableCell.getTextP();
                List<TextSpan> list = textP.getTextSpans();
                System.out.println("TextP:" + list);
            }
        }
    }

    public void dumpSpreadSheetsRows() {
        List<OfficeSpreadsheet> list = this.body.getOfficeSpreadsheets();
        for (OfficeSpreadsheet officeSpreadsheet : list) {
            System.out.println(officeSpreadsheet);
            List<TableTable> list2 = officeSpreadsheet.getTables();
            for (TableTable tableTable : list2) {
                System.out.println("Table ===================");
                for (TableTableRow tableTableRow : tableTable.getRows()) {
                    System.out.println(tableTableRow.getText() + " repeated:" + tableTableRow.getTableNumberRowsRepeated());
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (this.current instanceof TableTable) {
            ((TableTable)this.current).completed();
        }
        this.pop();
    }

    public OfficeAutomaticStyles getAutomaticstyles() {
        return this.autostyles;
    }

    public OfficeBody getBody() {
        return this.body;
    }

    private void pop() {
        if (!this.stack.isEmpty()) {
            Object object = this.stack.pop();
        }
        if (!this.stack.isEmpty()) {
            this.current = this.stack.peek();
        }
    }

    private void push(Object object) {
        this.stack.push(object);
        this.current = object;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equals("office:automatic-styles")) {
            this.autostyles = new OfficeAutomaticStyles();
            this.document.setAutomaticStyles(this.autostyles);
            this.push(this.autostyles);
        } else if (string3.equals("style:style")) {
            StyleStyle styleStyle = new StyleStyle();
            styleStyle.setStyleName(attributes.getValue("style:name"));
            styleStyle.setStyleFamily(attributes.getValue("style:family"));
            styleStyle.setStyleParentStyleName(attributes.getValue("style:parent-style-name"));
            styleStyle.setMasterPageName(attributes.getValue("style:master-page-name"));
            if (this.current instanceof OfficeAutomaticStyles) {
                this.autostyles.addStyle(styleStyle);
                this.document.getStyleResolver().add(styleStyle);
            } else {
                SaxContentUnmarshaller.log("Not OfficeAutomaticStyles: " + this.current + " style:" + styleStyle.getStyleName());
                this.dumpStack();
            }
            this.push(styleStyle);
        } else if (string3.equals("number:number-style")) {
            NumberNumberStyle numberNumberStyle = new NumberNumberStyle();
            numberNumberStyle.setStyleName(attributes.getValue("style:name"));
            numberNumberStyle.setStyleFamily(attributes.getValue("style:family"));
            if (this.current instanceof OfficeAutomaticStyles) {
                this.autostyles.addStyle(numberNumberStyle);
            } else {
                SaxContentUnmarshaller.log("Not OfficeAutomaticStyles:" + this.current);
            }
            this.push(numberNumberStyle);
        } else if (string3.equals("style:table-row-properties")) {
            StyleTableRowProperties styleTableRowProperties = new StyleTableRowProperties();
            styleTableRowProperties.setFoBreakBefore(attributes.getValue("fo:break-before"));
            styleTableRowProperties.setRowHeight(attributes.getValue("style:row-height"));
            styleTableRowProperties.setUseOptimalRowHeight(attributes.getValue("style:use-optimal-row-height"));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setTableRowProperties(styleTableRowProperties);
            } else {
                SaxContentUnmarshaller.log("Not StyleStyle:" + this.current);
            }
            this.push(styleTableRowProperties);
        } else if (string3.equals("style:table-properties")) {
            StyleTableProperties styleTableProperties = new StyleTableProperties();
            if (attributes.getValue("table:display") != null) {
                styleTableProperties.setDisplay(ValueHelper.getBoolean(attributes.getValue("table:display")));
            }
            styleTableProperties.setWritingMode(attributes.getValue("style:writing-mode"));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setTableProperties(styleTableProperties);
            } else {
                SaxContentUnmarshaller.log("Not StyleStyle:" + this.current);
            }
            this.push(styleTableProperties);
        } else if (string3.equals("style:table-cell-properties")) {
            StyleTableCellProperties styleTableCellProperties = new StyleTableCellProperties();
            styleTableCellProperties.setVerticalAlign(attributes.getValue("style:vertical-align"));
            styleTableCellProperties.setBackgroundColor(attributes.getValue("fo:background-color"));
            styleTableCellProperties.setPadding(attributes.getValue("fo:padding"));
            styleTableCellProperties.setTextAlignSource(attributes.getValue("style:text-align-source"));
            styleTableCellProperties.setRepeatContent(attributes.getValue("style:repeat-content"));
            styleTableCellProperties.setBorderLeft(attributes.getValue("fo:border-left"));
            styleTableCellProperties.setBorderRight(attributes.getValue("fo:border-right"));
            styleTableCellProperties.setBorderTop(attributes.getValue("fo:border-top"));
            styleTableCellProperties.setBorderBottom(attributes.getValue("fo:border-bottom"));
            styleTableCellProperties.setBorder(attributes.getValue("fo:border"));
            styleTableCellProperties.setWrapOption(attributes.getValue("fo:wrap-option"));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setTableCellProperties(styleTableCellProperties);
            } else {
                SaxContentUnmarshaller.log("Not StyleStyle:" + this.current);
            }
            this.push(styleTableCellProperties);
        } else if (string3.equals("style:text-properties")) {
            StyleTextProperties styleTextProperties = new StyleTextProperties();
            styleTextProperties.setFontName(attributes.getValue("style:font-name"));
            styleTextProperties.setFontSize(attributes.getValue("fo:font-size"));
            styleTextProperties.setFontWeight(attributes.getValue("fo:font-weight"));
            styleTextProperties.setColor(attributes.getValue("fo:color"));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setTextProperties(styleTextProperties);
            } else {
                SaxContentUnmarshaller.log("Not StyleStyle:" + this.current);
            }
            this.push(styleTextProperties);
        } else if (string3.equals("style:background-image")) {
            if (this.current instanceof StyleTableCellProperties) {
                ((StyleTableCellProperties)this.current).setBackgroundImage(true);
            } else if (this.current instanceof StyleSectionProperties) {
                ((StyleSectionProperties)this.current).setBackgroundImage(true);
            } else {
                SaxContentUnmarshaller.log("Not StyleTableCellProperties:" + this.current);
            }
            this.push(new UnusedElement("style:background-image"));
        } else if (string3.equals("style:table-column-properties")) {
            StyleTableColumnProperties styleTableColumnProperties = new StyleTableColumnProperties();
            styleTableColumnProperties.setFoBreakBefore(attributes.getValue("fo:break-before"));
            styleTableColumnProperties.setStyleColumnWidth(attributes.getValue("style:column-width"));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setTableColumnProperties(styleTableColumnProperties);
            } else {
                SaxContentUnmarshaller.log("Not StyleStyle:" + this.current);
            }
            this.push(styleTableColumnProperties);
        } else if (string3.equals("style:paragraph-properties")) {
            StyleParagraphProperties styleParagraphProperties = new StyleParagraphProperties();
            styleParagraphProperties.setTextAlign(attributes.getValue("fo:text-align"));
            styleParagraphProperties.setMarginLeft(attributes.getValue("fo:margin-left"));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setParagraphProperties(styleParagraphProperties);
            } else {
                SaxContentUnmarshaller.log("Not StyleStyle:" + this.current);
            }
            this.push(styleParagraphProperties);
        } else if (string3.equals("office:body")) {
            this.body = new OfficeBody();
            this.push(this.body);
        } else if (string3.equals("office:spreadsheet")) {
            OfficeSpreadsheet officeSpreadsheet = new OfficeSpreadsheet();
            if (this.current instanceof OfficeBody) {
                ((OfficeBody)this.current).addOfficeSpreadsheet(officeSpreadsheet);
            } else {
                SaxContentUnmarshaller.log("Not StyleStyle:" + this.current);
            }
            this.push(officeSpreadsheet);
        } else if (string3.equals("table:table")) {
            TableTable tableTable = new TableTable();
            SaxContentUnmarshaller.dumpAttributes(attributes);
            tableTable.setTableName(attributes.getValue("table:name"));
            tableTable.setTableStyleName(attributes.getValue("table:style-name"));
            String string4 = attributes.getValue("table:print-ranges");
            if (string4 != null) {
                tableTable.setTablePrintRanges(string4);
            }
            this.assertParsed(attributes, 3);
            if (this.current instanceof OfficeSpreadsheet) {
                ((OfficeSpreadsheet)this.current).addTable(tableTable);
            } else if (this.current instanceof OfficeText) {
                ((OfficeText)this.current).addTextElement(tableTable);
            } else {
                SaxContentUnmarshaller.log("Not OfficeSpreadsheet:" + this.current);
            }
            this.push(tableTable);
        } else if (string3.equals("table:table-column")) {
            TableTableColumn tableTableColumn = new TableTableColumn();
            tableTableColumn.setTableStyleName(attributes.getValue("table:style-name"));
            tableTableColumn.setTableDefaultCellStyleName(attributes.getValue("table:default-cell-style-name"));
            tableTableColumn.setTableNumberColumnsRepeated(attributes.getValue("table:number-columns-repeated"));
            this.assertParsed(attributes, 3);
            if (this.current instanceof TableTable) {
                ((TableTable)this.current).addColumn(tableTableColumn);
            } else if (this.current instanceof TableTableHeaderColumns) {
                ((TableTable)this.stack.get(this.stack.size() - 2)).addColumn(tableTableColumn);
            } else {
                SaxContentUnmarshaller.log("Not TableTable:" + this.current + " class:" + this.current.getClass().getName());
                this.dumpStack();
            }
            this.push(tableTableColumn);
        } else if (string3.equals("table:table-row")) {
            TableTableRow tableTableRow = new TableTableRow();
            tableTableRow.setTableStyleName(attributes.getValue("table:style-name"));
            tableTableRow.setTableNumberRowsRepeated(attributes.getValue("table:number-rows-repeated"));
            if (this.current instanceof TableTable) {
                ((TableTable)this.current).addRow(tableTableRow);
            } else {
                SaxContentUnmarshaller.log("Not TableTable:" + this.current);
                this.dumpStack();
            }
            this.push(tableTableRow);
        } else if (string3.equals("table:table-cell") || string3.equals("table:covered-table-cell")) {
            TableTableCell tableTableCell = new TableTableCell();
            tableTableCell.setTableStyleName(attributes.getValue("table:style-name"));
            tableTableCell.setTableNumberColumnsRepeated(attributes.getValue("table:number-columns-repeated"));
            tableTableCell.setTableNumberColumnsSpanned(attributes.getValue("table:number-columns-spanned"));
            tableTableCell.setTableNumberRowsSpanned(attributes.getValue("table:number-rows-spanned"));
            tableTableCell.setTableValueType(attributes.getValue("office:value-type"));
            if (string3.equals("table:covered-table-cell")) {
                tableTableCell.setCovered(true);
            }
            if (this.current instanceof TableTableRow) {
                ((TableTableRow)this.current).addCell(tableTableCell);
            } else {
                SaxContentUnmarshaller.log("Not TableTableRow:" + this.current);
            }
            this.push(tableTableCell);
        } else if (string3.equals("text:p")) {
            TextP textP = new TextP();
            if (this.current instanceof TableTableCell) {
                ((TableTableCell)this.current).setTextP(textP);
            } else if (this.current instanceof DrawImage) {
                ((DrawImage)this.current).setTextP(textP);
            } else if (this.current instanceof OfficeText) {
                ((OfficeText)this.current).addTextElement(textP);
            } else if (this.current instanceof DrawTextBox) {
                ((DrawTextBox)this.current).addTextElement(textP);
            } else if (this.current instanceof TextIndexBody) {
                ((TextIndexBody)this.current).addTextElement(textP);
            } else if (this.current instanceof TextListItem) {
                ((TextListItem)this.current).addTextElement(textP);
            } else {
                SaxContentUnmarshaller.log("Not TableTableCell:" + this.current + " classe:" + this.current.getClass());
            }
            this.push(textP);
        } else if (string3.equals("text:span")) {
            TextSpan textSpan = new TextSpan();
            textSpan.setTextStyle(this.document.getStyle(attributes.getValue("text:style-name"), "text"));
            if (this.current instanceof TextP) {
                ((TextP)this.current).addTextSpan(textSpan);
            } else if (this.current instanceof TextSpan) {
                ((TextSpan)this.current).addTextSpan(textSpan);
            } else if (this.current instanceof TextA) {
                ((TextA)this.current).addTextSpan(textSpan);
            } else {
                SaxContentUnmarshaller.log("Not TextP:" + this.current + " " + textSpan.getTextStyle());
            }
            this.push(textSpan);
        } else if (string3.equals("draw:frame")) {
            DrawFrame drawFrame = new DrawFrame();
            drawFrame.setSvgWidth(attributes.getValue("svg:width"));
            drawFrame.setSvgHeight(attributes.getValue("svg:height"));
            drawFrame.setSvgX(attributes.getValue("svg:x"));
            drawFrame.setSvgY(attributes.getValue("svg:y"));
            if (this.current instanceof TableTableCell) {
                ((TableTableCell)this.current).addDrawFrame(drawFrame);
            } else if (this.current instanceof TableShapes) {
                ((TableShapes)this.current).addDrawFrame(drawFrame);
            } else if (this.current instanceof OfficeText) {
                ((OfficeText)this.current).addTextElement(drawFrame);
            } else if (this.current instanceof TextP) {
                ((TextP)this.current).addElement(drawFrame);
            } else {
                SaxContentUnmarshaller.log("Not TableTableCell:" + this.current + " " + this.current.getClass());
            }
            this.push(drawFrame);
        } else if (string3.equals("draw:image")) {
            DrawImage drawImage = new DrawImage();
            String string5 = attributes.getValue("xlink:href");
            drawImage.setXlinkHref(string5);
            this.document.preloadImage(string5);
            if (this.current instanceof DrawFrame) {
                ((DrawFrame)this.current).setDrawImage(drawImage);
            } else {
                SaxContentUnmarshaller.log("Not DrawFrame:" + this.current);
            }
            this.push(drawImage);
        } else if (string3.equals("table:shapes")) {
            TableShapes tableShapes = new TableShapes();
            if (this.current instanceof TableTable) {
                ((TableTable)this.current).setTableShapes(tableShapes);
            } else {
                SaxContentUnmarshaller.log("Not TableTable:" + this.current);
            }
            this.push(tableShapes);
        } else if (string3.equals("office:scripts")) {
            this.scripts = new OfficeScripts();
            this.push(this.scripts);
        } else if (string3.equals("table:table-header-columns")) {
            TableTableHeaderColumns tableTableHeaderColumns = new TableTableHeaderColumns();
            this.push(tableTableHeaderColumns);
        } else if (string3.equals("office:font-face-decls")) {
            this.fontDeclarations = new FontFaceDecls();
            this.push(this.fontDeclarations);
        } else if (string3.equals("style:font-face")) {
            StyleFontFace styleFontFace = new StyleFontFace();
            styleFontFace.setStyleName(attributes.getValue("style:name"));
            styleFontFace.setFontFamily(attributes.getValue("svg:font-family"));
            styleFontFace.setFontFamilyGeneric(attributes.getValue("style:font-family-generic"));
            styleFontFace.setFontPitch(attributes.getValue("style:font-pitch"));
            if (this.current instanceof FontFaceDecls) {
                ((FontFaceDecls)this.current).addFontFace(styleFontFace);
            } else {
                SaxContentUnmarshaller.log("Not FontFaceDecls:" + this.current);
            }
            this.push(styleFontFace);
        } else if (string3.equals("style:tab-stops")) {
            StyleTabStops styleTabStops = new StyleTabStops();
            if (this.current instanceof StyleParagraphProperties) {
                ((StyleParagraphProperties)this.current).addTabStops(styleTabStops);
            } else {
                SaxContentUnmarshaller.log("StyleParagraphProperties:" + this.current);
            }
            this.push(styleTabStops);
        } else if (string3.equals("style:tab-stop")) {
            StyleTabStop styleTabStop = new StyleTabStop();
            styleTabStop.setStylePosition(attributes.getValue("style:position"));
            if (this.current instanceof StyleTabStops) {
                ((StyleTabStops)this.current).add(styleTabStop);
            } else {
                SaxContentUnmarshaller.log("StyleTabStops:" + this.current);
            }
            this.push(styleTabStop);
        } else if (string3.equals("style:graphic-properties")) {
            StyleGraphicProperties styleGraphicProperties = new StyleGraphicProperties();
            styleGraphicProperties.setMarginLeft(attributes.getValue("fo:margin-left"));
            styleGraphicProperties.setMarginRight(attributes.getValue("fo:margin-right"));
            styleGraphicProperties.setMarginTop(attributes.getValue("fo:margin-top"));
            styleGraphicProperties.setMarginBottom(attributes.getValue("fo:margin-bottom"));
            styleGraphicProperties.setProtection(attributes.getValue("style:protect"));
            styleGraphicProperties.setWrap(attributes.getValue("style:wrap"));
            styleGraphicProperties.setNumberWrappedParagraphs(attributes.getValue("style:number-wrapped-paragraphs"));
            styleGraphicProperties.setVerticalPosition(attributes.getValue("style:vertical-pos"));
            styleGraphicProperties.setVerticalRelative(attributes.getValue("style:vertical-rel"));
            styleGraphicProperties.setHorizontalPosition(attributes.getValue("style:horizontal-pos"));
            styleGraphicProperties.setHorizontalRelative(attributes.getValue("style:horizontal-rel"));
            styleGraphicProperties.setPadding(attributes.getValue("fo:padding"));
            styleGraphicProperties.setBorder(attributes.getValue("fo:border"));
            styleGraphicProperties.setShadow(attributes.getValue("style:shadow"));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setGraphicProperties(styleGraphicProperties);
            } else {
                SaxContentUnmarshaller.log("Not StyleStyle:" + this.current);
            }
            this.push(styleGraphicProperties);
        } else if (string3.equals("style:section-properties")) {
            StyleSectionProperties styleSectionProperties = new StyleSectionProperties();
            styleSectionProperties.setBackGroundColor(ValueHelper.getColor(attributes.getValue("fo:background-color")));
            styleSectionProperties.setEditable(ValueHelper.getBoolean(attributes.getValue("style:editable")));
            if (this.current instanceof StyleStyle) {
                ((StyleStyle)this.current).setSectionProperties(styleSectionProperties);
            } else {
                SaxContentUnmarshaller.log("Not StyleStyle:" + this.current);
            }
            this.push(styleSectionProperties);
        } else if (string3.equals("style:columns")) {
            StyleColumns styleColumns = new StyleColumns();
            styleColumns.setFoColumnGap("fo:column-gap");
            styleColumns.setFoColumnCount("fo:column-count");
            if (this.current instanceof StyleGraphicProperties) {
                ((StyleGraphicProperties)this.current).setColums(styleColumns);
            } else if (this.current instanceof StyleSectionProperties) {
                ((StyleSectionProperties)this.current).setColums(styleColumns);
            } else {
                SaxContentUnmarshaller.log("Not StyleSectionProperties: " + this.current);
            }
            this.push(styleColumns);
        } else if (string3.equals("text:list-style")) {
            TextListStyle textListStyle = new TextListStyle();
            textListStyle.setStyleName(attributes.getValue("style:name"));
            if (this.current instanceof OfficeAutomaticStyles) {
                ((OfficeAutomaticStyles)this.current).addStyle(textListStyle);
            } else {
                SaxContentUnmarshaller.log("Not OfficeAutomaticStyles: " + this.current);
            }
            this.push(textListStyle);
        } else if (string3.equals("text:list-level-style-bullet")) {
            TextListLevelStyleBullet textListLevelStyleBullet = new TextListLevelStyleBullet();
            textListLevelStyleBullet.setTextLevel(attributes.getValue("text:level"));
            textListLevelStyleBullet.setTextStyleName(attributes.getValue("text:style-name"));
            textListLevelStyleBullet.setStyleNumSuffix(attributes.getValue("style:num-suffix"));
            textListLevelStyleBullet.setStyleNumPrefix(attributes.getValue("style:num-prefix"));
            textListLevelStyleBullet.setTextBulletChar(attributes.getValue("text:bullet-char"));
            if (this.current instanceof TextListStyle) {
                ((TextListStyle)this.current).addListLevelStyleBullet(textListLevelStyleBullet);
            } else {
                SaxContentUnmarshaller.log("Not TextListStyle: " + this.current);
            }
            this.push(textListLevelStyleBullet);
        } else if (string3.equals("text:list-level-style-number")) {
            TextListLevelStyleNumber textListLevelStyleNumber = new TextListLevelStyleNumber();
            textListLevelStyleNumber.setTextLevel(attributes.getValue("text:level"));
            textListLevelStyleNumber.setTextStyleName(attributes.getValue("text:style-name"));
            textListLevelStyleNumber.setStyleNumSuffix(attributes.getValue("style:num-suffix"));
            textListLevelStyleNumber.setStyleNumPrefix(attributes.getValue("style:num-prefix"));
            textListLevelStyleNumber.setStyleNumFormat(attributes.getValue("style:num-format"));
            textListLevelStyleNumber.setTextStartValue(attributes.getValue("text:start-value"));
            if (this.current instanceof TextListStyle) {
                ((TextListStyle)this.current).addListLevelStyleNumber(textListLevelStyleNumber);
            } else {
                SaxContentUnmarshaller.log("Not TextListStyle: " + this.current);
            }
            this.push(textListLevelStyleNumber);
        } else if (string3.equals("style:list-level-properties")) {
            StyleListLevelProperties styleListLevelProperties = new StyleListLevelProperties();
            styleListLevelProperties.setSpaceBefore(attributes.getValue("text:space-before"));
            styleListLevelProperties.setMinLabelWidth(attributes.getValue("text:min-label-width"));
            if (this.current instanceof TextListLevelStyleBullet) {
                ((TextListLevelStyleBullet)this.current).setStyleListLevelProperties(styleListLevelProperties);
            } else if (this.current instanceof TextListLevelStyleNumber) {
                ((TextListLevelStyleNumber)this.current).setStyleListLevelProperties(styleListLevelProperties);
            } else {
                SaxContentUnmarshaller.log("Not TextListLevelStyleBullet: " + this.current);
            }
            this.push(styleListLevelProperties);
        } else if (string3.equals("office:text")) {
            OfficeText officeText = new OfficeText();
            officeText.setUseSoftPageBreaks(ValueHelper.getBoolean(attributes.getValue("text:use-soft-page-breaks")));
            if (this.current instanceof OfficeBody) {
                ((OfficeBody)this.current).setOfficeText(officeText);
            } else {
                SaxContentUnmarshaller.log("Not OfficeBody: " + this.current);
            }
            this.push(officeText);
        } else if (string3.equals("draw:text-box")) {
            DrawTextBox drawTextBox = new DrawTextBox();
            if (this.current instanceof DrawFrame) {
                ((DrawFrame)this.current).addTextBox(drawTextBox);
            } else {
                SaxContentUnmarshaller.log("Not DrawFrame: " + this.current);
            }
            this.push(drawTextBox);
        } else if (string3.equals("text:table-of-content")) {
            TextTableOfContent textTableOfContent = new TextTableOfContent();
            textTableOfContent.setTextStyleName(attributes.getValue("text:style-name"));
            textTableOfContent.setTextProtected(attributes.getValue("text:protected"));
            textTableOfContent.setTextName(attributes.getValue("text:name"));
            if (this.current instanceof OfficeText) {
                ((OfficeText)this.current).addTextElement(textTableOfContent);
            } else {
                SaxContentUnmarshaller.log("Not OfficeText: " + this.current);
            }
            this.push(textTableOfContent);
        } else if (string3.equals("text:index-body")) {
            TextIndexBody textIndexBody = new TextIndexBody();
            if (this.current instanceof TextTableOfContent) {
                ((TextTableOfContent)this.current).setTextIndexBody(textIndexBody);
            } else {
                SaxContentUnmarshaller.log("Not TextTableOfContent: " + this.current);
            }
            this.push(textIndexBody);
        } else if (string3.equals("text:tab")) {
            TextTab textTab = new TextTab();
            if (this.current instanceof TextP) {
                ((TextP)this.current).addElement(textTab);
            } else {
                SaxContentUnmarshaller.log("Not TextP: " + this.current);
            }
            this.push(textTab);
        } else if (string3.equals("text:a")) {
            TextA textA = new TextA();
            textA.setXlinkType(attributes.getValue("xlink:type"));
            textA.setXlinkHref(attributes.getValue("xlink:href"));
            textA.setTextStyleName(attributes.getValue("text:style-name"));
            textA.setTextVisitedStyleName(attributes.getValue("text:visited-style-name"));
            if (this.current instanceof TextP) {
                ((TextP)this.current).addElement(textA);
            } else {
                SaxContentUnmarshaller.log("Not TextP: " + this.current);
            }
            this.push(textA);
        } else if (string3.equals("text:h")) {
            TextH textH = new TextH();
            textH.setTextStyleName(attributes.getValue("text:style-name"));
            textH.setTextLevel(attributes.getValue("text:outline-level"));
            if (this.current instanceof TextP) {
                ((TextP)this.current).addElement(textH);
            } else if (this.current instanceof OfficeText) {
                ((OfficeText)this.current).addTextElement(textH);
            } else {
                SaxContentUnmarshaller.log("Not TextP: " + this.current);
            }
            this.push(textH);
        } else if (string3.equals("text:date")) {
            TextDate textDate = new TextDate();
            textDate.setStyleDataStyleName(attributes.getValue("style:data-style-name"));
            textDate.setTextDateValue(attributes.getValue("text:date-value"));
            textDate.setTextFixed(attributes.getValue("text:fixed"));
            if (this.current instanceof TextP) {
                ((TextP)this.current).addElement(textDate);
            } else {
                SaxContentUnmarshaller.log("Not TextP: " + this.current);
            }
            this.push(textDate);
        } else if (string3.equals("text:list")) {
            TextList textList = new TextList();
            textList.setId(attributes.getValue("xml:id"));
            textList.setTextStyleName(attributes.getValue("text:style-name"));
            if (this.current instanceof OfficeText) {
                ((OfficeText)this.current).addTextElement(textList);
            } else {
                SaxContentUnmarshaller.log("Not OfficeText: " + this.current);
            }
            this.push(textList);
        } else if (string3.equals("text:list-item")) {
            TextListItem textListItem = new TextListItem();
            if (this.current instanceof TextList) {
                ((TextList)this.current).addListItem(textListItem);
            } else {
                SaxContentUnmarshaller.log("Not TextList: " + this.current);
            }
            this.push(textListItem);
        } else if (string3.equals("text:line-break")) {
            TextLineBreak textLineBreak = new TextLineBreak();
            if (this.current instanceof TextSpan) {
                ((TextSpan)this.current).addTextElement(textLineBreak);
            } else if (this.current instanceof TextP) {
                ((TextP)this.current).addElement(textLineBreak);
            } else {
                SaxContentUnmarshaller.log("Not TextSpan: " + this.current);
            }
            this.push(textLineBreak);
        } else if (string3.equals("text:soft-page-break")) {
            TextSoftPageBreak textSoftPageBreak = new TextSoftPageBreak();
            if (this.current instanceof TextSpan) {
                ((TextSpan)this.current).addTextElement(textSoftPageBreak);
            } else if (this.current instanceof TextP) {
                ((TextP)this.current).addElement(textSoftPageBreak);
            } else if (this.current instanceof TextH) {
                ((TextH)this.current).addElement(textSoftPageBreak);
            } else {
                SaxContentUnmarshaller.log("Not TextSpan: " + this.current);
            }
            this.push(textSoftPageBreak);
        } else if (string3.equals("text:bookmark")) {
            TextBookmark textBookmark = new TextBookmark();
            textBookmark.setTextName(attributes.getValue("text:name"));
            if (this.current instanceof TextH) {
                ((TextH)this.current).addElement(textBookmark);
            } else {
                SaxContentUnmarshaller.log("Not TextH: " + this.current);
            }
            this.push(textBookmark);
        } else if (string3.equals("text:bookmark-end")) {
            TextBookmarkEnd textBookmarkEnd = new TextBookmarkEnd();
            textBookmarkEnd.setTextName(attributes.getValue("text:name"));
            if (this.current instanceof TextH) {
                ((TextH)this.current).addElement(textBookmarkEnd);
            } else {
                SaxContentUnmarshaller.log("Not TextH: " + this.current);
            }
            this.push(textBookmarkEnd);
        } else if (string3.equals("number:date-style")) {
            NumberDateStyle numberDateStyle = new NumberDateStyle();
            numberDateStyle.setStyleName(attributes.getValue("style:name"));
            numberDateStyle.setNumberAutomaticOrder(attributes.getValue("number:automatic-order"));
            if (this.current instanceof OfficeAutomaticStyles) {
                ((OfficeAutomaticStyles)this.current).addStyle(numberDateStyle);
            } else {
                SaxContentUnmarshaller.log("Not OfficeAutomaticStyles: " + this.current);
            }
            this.push(numberDateStyle);
        } else if (string3.equals("number:day")) {
            NumberDay numberDay = new NumberDay();
            if (this.current instanceof NumberDateStyle) {
                ((NumberDateStyle)this.current).addElement(numberDay);
            } else {
                SaxContentUnmarshaller.log("Not NumberDateStyle: " + this.current);
            }
            this.push(numberDay);
        } else if (string3.equals("number:text")) {
            NumberText numberText = new NumberText();
            if (this.current instanceof NumberDateStyle) {
                ((NumberDateStyle)this.current).addElement(numberText);
            } else {
                SaxContentUnmarshaller.log("Not NumberDateStyle: " + this.current);
            }
            this.push(numberText);
        } else if (string3.equals("number:month")) {
            NumberMonth numberMonth = new NumberMonth();
            numberMonth.setNumberTextual(attributes.getValue("number:textual"));
            if (this.current instanceof NumberDateStyle) {
                ((NumberDateStyle)this.current).addElement(numberMonth);
            } else {
                SaxContentUnmarshaller.log("Not NumberDateStyle: " + this.current);
            }
            this.push(numberMonth);
        } else if (string3.equals("number:year")) {
            NumberYear numberYear = new NumberYear();
            if (this.current instanceof NumberDateStyle) {
                ((NumberDateStyle)this.current).addElement(numberYear);
            } else {
                SaxContentUnmarshaller.log("Not NumberDateStyle: " + this.current);
            }
            this.push(numberYear);
        } else {
            SaxContentUnmarshaller.log("content.xml : ignoring :" + string3 + " current:" + this.current, false);
            this.push(string3 + "/" + string);
        }
    }

    private void dumpStack() {
        SaxContentUnmarshaller.log("Stack:", false);
        for (int i = 0; i < this.stack.size(); ++i) {
            SaxContentUnmarshaller.log("Item " + i + " : " + this.stack.get(i).getClass().getCanonicalName() + " : " + this.stack.get(i), false);
        }
        System.err.flush();
        System.exit(0);
    }
}

