/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.text;

import org.jdom.Element;
import org.jopendocument.dom.StyleProperties;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.text.Paragraph;

public class Heading
extends Paragraph {
    static Element createEmpty(XMLVersion xMLVersion) {
        return new Element("h", xMLVersion.getTEXT()).setAttribute("outline-level", "1", xMLVersion.getTEXT());
    }

    public Heading(String string) {
        this();
        this.addContent(string);
    }

    public Heading() {
        super(Heading.createEmpty(XMLVersion.getDefault()));
    }

    public final int getLevel() {
        String string = this.getElement().getAttributeValue("outline-level", this.getElement().getNamespace());
        return StyleProperties.parseInt(string, 1);
    }

    public final void setLevel(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(n + " < 1");
        }
        this.getElement().setAttribute("outline-level", n + "", this.getElement().getNamespace());
    }
}

