/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.style.data;

import java.math.BigDecimal;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.StyleProperties;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.style.data.DataStyle;
import org.jopendocument.dom.style.data.DateStyle;
import org.jopendocument.util.TimeUtils;
import org.jopendocument.util.convertor.NumberConvertor;

public class TimeStyle
extends DataStyle {
    public static final DataStyle.DataStyleDesc<TimeStyle> DESC = new DataStyle.DataStyleDesc<TimeStyle>(TimeStyle.class, XMLVersion.OD, "time-style", "N"){

        @Override
        public TimeStyle create(ODPackage oDPackage, Element element) {
            return new TimeStyle(oDPackage, element);
        }
    };
    private static final int DAY_LENGTH_IN_HOURS = 24;
    private static final int AM_LENGTH = 12;

    private static final String formatInt(int n, Element element) {
        String string = String.valueOf(n);
        return !DateStyle.isShort(element) && string.length() < 2 ? '0' + string : string;
    }

    public TimeStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element, ODValueType.TIME);
    }

    @Override
    protected Duration convertNonNull(Object object) {
        if (object instanceof Number) {
            return TimeUtils.timePartToDuration(this.getEpoch().getDate(NumberConvertor.toBigDecimal((Number)object)));
        }
        return null;
    }

    @Override
    public String format(Object object, CellStyle cellStyle, boolean bl) {
        Duration duration = object instanceof Calendar ? TimeUtils.timePartToDuration((Calendar)object) : (Duration)object;
        Namespace namespace = this.getElement().getNamespace();
        StringBuilder stringBuilder = new StringBuilder();
        Locale locale = DateStyle.getLocale(this.getElement());
        boolean bl2 = StyleProperties.parseBoolean(this.getElement().getAttributeValue("truncate-on-overflow", namespace), true);
        List list = this.getElement().getChildren();
        for (Element element : list) {
            if (!element.getNamespace().equals(namespace)) continue;
            if (element.getName().equals("text")) {
                stringBuilder.append(element.getText());
                continue;
            }
            if (element.getName().equals("hours")) {
                int n = duration.getHours();
                if (bl2) {
                    n %= 24;
                }
                if (element.getChild("am-pm", namespace) != null) {
                    int n2 = n = duration.getHours() == 0 ? 12 : (duration.getHours() - 1) % 12 + 1;
                    assert (n >= 1 && n <= 12);
                }
                stringBuilder.append(TimeStyle.formatInt(n, element));
                continue;
            }
            if (element.getName().equals("am-pm")) {
                boolean bl3 = duration.getHours() % 24 < 12;
                stringBuilder.append(new DateFormatSymbols(locale).getAmPmStrings()[bl3 ? 0 : 1]);
                continue;
            }
            if (element.getName().equals("minutes")) {
                int n = bl2 && this.getElement().getChild("hours", namespace) == null ? duration.getMinutes() % 60 : duration.getMinutes();
                stringBuilder.append(TimeStyle.formatInt(n, element));
                continue;
            }
            if (!element.getName().equals("seconds")) continue;
            BigDecimal bigDecimal = (BigDecimal)duration.getField(DatatypeConstants.SECONDS);
            int n = bl2 && this.getElement().getChild("hours", namespace) == null && this.getElement().getChild("minutes", namespace) == null ? bigDecimal.intValue() % 60 : bigDecimal.intValue();
            stringBuilder.append(TimeStyle.formatInt(n, element));
            int n3 = StyleProperties.parseInt(element.getAttributeValue("decimal-places", namespace), 0);
            stringBuilder.append(DateStyle.formatSecondFraction(locale, bigDecimal, n3));
        }
        return stringBuilder.toString();
    }
}

