/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.style.data;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.Duration;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.ODEpoch;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.style.data.DataStyle;

public class NumberStyle
extends DataStyle {
    public static final DataStyle.DataStyleDesc<NumberStyle> DESC = new DataStyle.DataStyleDesc<NumberStyle>(NumberStyle.class, XMLVersion.OD, "number-style", "N"){

        @Override
        public NumberStyle create(ODPackage oDPackage, Element element) {
            return new NumberStyle(oDPackage, element);
        }
    };

    public static final Number toNumber(Object object, ODEpoch oDEpoch) {
        Number number;
        if (object instanceof Number) {
            number = (Number)object;
        } else if (object instanceof Boolean) {
            number = (Boolean)object != false ? 1 : 0;
        } else if (object instanceof Duration || object instanceof Date || object instanceof Calendar) {
            if (object instanceof Duration) {
                number = oDEpoch.getDays((Duration)object);
            } else {
                Calendar calendar;
                if (object instanceof Calendar) {
                    calendar = (Calendar)object;
                } else {
                    calendar = Calendar.getInstance();
                    calendar.setTime((Date)object);
                }
                number = oDEpoch.getDays(calendar);
            }
        } else {
            number = null;
        }
        return number;
    }

    public NumberStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element, ODValueType.FLOAT);
    }

    @Override
    protected Number convertNonNull(Object object) {
        return NumberStyle.toNumber(object, this.getEpoch());
    }

    @Override
    public String format(Object object, CellStyle cellStyle, boolean bl) {
        Number number = (Number)object;
        Namespace namespace = this.getElement().getNamespace();
        StringBuilder stringBuilder = new StringBuilder();
        List list = this.getElement().getChildren();
        for (Element element : list) {
            if (!element.getNamespace().equals(namespace)) continue;
            if (element.getName().equals("text")) {
                stringBuilder.append(element.getText());
                continue;
            }
            if (element.getName().equals("number") || element.getName().equals("scientific-number")) {
                stringBuilder.append(this.formatNumberOrScientificNumber(element, number, cellStyle));
                continue;
            }
            if (!element.getName().equals("fraction")) continue;
            this.reportError("Fractions not supported", bl);
            stringBuilder.append(MutableCell.formatNumber(number, cellStyle));
        }
        return stringBuilder.toString();
    }
}

