/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.style.data;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.StyleProperties;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.style.data.DataStyle;
import org.jopendocument.util.convertor.NumberConvertor;

public class DateStyle
extends DataStyle {
    private static final Calendar BUDDHIST_CAL = Calendar.getInstance(new Locale("th", "TH"));
    private static final Calendar JAPANESE_CAL = Calendar.getInstance(new Locale("ja", "JP", "JP"));
    private static final Calendar GREGORIAN_CAL = new GregorianCalendar();
    public static final DataStyle.DataStyleDesc<DateStyle> DESC = new DataStyle.DataStyleDesc<DateStyle>(DateStyle.class, XMLVersion.OD, "date-style", "N"){

        @Override
        public DateStyle create(ODPackage oDPackage, Element element) {
            return new DateStyle(oDPackage, element);
        }
    };

    static final boolean isShort(Element element) {
        return !"long".equals(element.getAttributeValue("style", element.getNamespace("number")));
    }

    public static final Locale getLocale(Element element) {
        String string = element.getAttributeValue("country", element.getNamespace());
        String string2 = element.getAttributeValue("language", element.getNamespace());
        Locale locale = string2 != null ? new Locale(string2, string == null ? "" : string) : Locale.getDefault();
        return locale;
    }

    private static final Calendar getCalendar(Element element, Calendar calendar) {
        Calendar calendar2;
        String string = element.getAttributeValue("calendar", element.getNamespace());
        if (string == null) {
            calendar2 = calendar;
        } else if ("buddhist".equals(string)) {
            calendar2 = BUDDHIST_CAL;
        } else if ("gengou".equals(string)) {
            calendar2 = JAPANESE_CAL;
        } else if ("gregorian".equals(string)) {
            calendar2 = GREGORIAN_CAL;
        } else {
            throw new IllegalArgumentException("Unsupported calendar : " + string);
        }
        return calendar2;
    }

    static String formatSecondFraction(Locale locale, BigDecimal bigDecimal, int n) {
        if (n > 0) {
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(locale));
            decimalFormat.setMinimumIntegerDigits(0);
            decimalFormat.setMaximumIntegerDigits(0);
            decimalFormat.setMinimumFractionDigits(n);
            decimalFormat.setMaximumFractionDigits(n);
            return decimalFormat.format(bigDecimal);
        }
        return "";
    }

    public DateStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element, ODValueType.DATE);
    }

    @Override
    protected Object convertNonNull(Object object) {
        if (object instanceof Number) {
            return this.getEpoch().getDate(NumberConvertor.toBigDecimal((Number)object));
        }
        return null;
    }

    private final void format(StringBuilder stringBuilder, StringBuilder stringBuilder2, Locale locale, Calendar calendar, Date date) {
        if (stringBuilder2.length() > 0) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringBuilder2.toString(), locale);
            stringBuilder2.setLength(0);
            simpleDateFormat.setCalendar((Calendar)calendar.clone());
            stringBuilder.append(simpleDateFormat.format(date));
        }
    }

    @Override
    public String format(Object object, CellStyle cellStyle, boolean bl) {
        Date date = object instanceof Calendar ? ((Calendar)object).getTime() : (Date)object;
        Namespace namespace = this.getElement().getNamespace();
        Locale locale = DateStyle.getLocale(this.getElement());
        Calendar calendar = Calendar.getInstance(locale);
        StringBuilder stringBuilder = new StringBuilder();
        Calendar calendar2 = calendar;
        StringBuilder stringBuilder2 = new StringBuilder();
        List list = this.getElement().getChildren();
        for (Element element : list) {
            if (!element.getNamespace().equals(namespace)) continue;
            Calendar calendar3 = DateStyle.getCalendar(element, calendar);
            if (!calendar3.equals(calendar2)) {
                this.format(stringBuilder, stringBuilder2, locale, calendar2, date);
                calendar2 = calendar3;
            }
            if (element.getName().equals("text")) {
                DataStyle.addStringLiteral(stringBuilder2, element.getText());
                continue;
            }
            if (element.getName().equals("era")) {
                stringBuilder2.append(DateStyle.isShort(element) ? "G" : "GGGG");
                continue;
            }
            if (element.getName().equals("year")) {
                stringBuilder2.append(DateStyle.isShort(element) ? "yy" : "yyyy");
                continue;
            }
            if (element.getName().equals("quarter")) {
                Calendar calendar4 = (Calendar)calendar2.clone();
                calendar4.setTime(date);
                double d = (double)calendar4.getActualMaximum(2) / 4.0;
                int n = (int)((double)calendar4.get(2) / d + 1.0);
                assert (n >= 1 && n <= 4);
                this.reportError("Quarters are not localized", bl);
                DataStyle.addStringLiteral(stringBuilder2, DateStyle.isShort(element) ? "Q" + n : "Q" + n);
                continue;
            }
            if (element.getName().equals("month")) {
                Attribute attribute = element.getAttribute("possessive-form", namespace);
                if (attribute != null) {
                    this.reportError("Ignoring " + attribute, bl);
                }
                if (!StyleProperties.parseBoolean(element.getAttributeValue("textual", namespace), false)) {
                    stringBuilder2.append(DateStyle.isShort(element) ? "M" : "MM");
                    continue;
                }
                stringBuilder2.append(DateStyle.isShort(element) ? "MMM" : "MMMM");
                continue;
            }
            if (element.getName().equals("week-of-year")) {
                stringBuilder2.append("w");
                continue;
            }
            if (element.getName().equals("day")) {
                stringBuilder2.append(DateStyle.isShort(element) ? "d" : "dd");
                continue;
            }
            if (element.getName().equals("day-of-week")) {
                stringBuilder2.append(DateStyle.isShort(element) ? "E" : "EEEE");
                continue;
            }
            if (element.getName().equals("am-pm")) {
                stringBuilder2.append("a");
                continue;
            }
            if (element.getName().equals("hours")) {
                if (this.getElement().getChild("am-pm", namespace) == null) {
                    stringBuilder2.append(DateStyle.isShort(element) ? "H" : "HH");
                    continue;
                }
                stringBuilder2.append(DateStyle.isShort(element) ? "h" : "hh");
                continue;
            }
            if (element.getName().equals("minutes")) {
                stringBuilder2.append(DateStyle.isShort(element) ? "m" : "mm");
                continue;
            }
            if (!element.getName().equals("seconds")) continue;
            stringBuilder2.append(DateStyle.isShort(element) ? "s" : "ss");
            int n = StyleProperties.parseInt(element.getAttributeValue("decimal-places", namespace), 0);
            if (n <= 0) continue;
            Calendar calendar5 = Calendar.getInstance(locale);
            calendar5.setTime(date);
            BigDecimal bigDecimal = new BigDecimal(calendar5.get(14)).movePointLeft(3);
            assert (bigDecimal.compareTo(BigDecimal.ONE) < 0);
            String string = DateStyle.formatSecondFraction(locale, bigDecimal, n);
            DataStyle.addStringLiteral(stringBuilder2, string);
        }
        this.format(stringBuilder, stringBuilder2, locale, calendar2, date);
        return stringBuilder.toString();
    }
}

