/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.style.data;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.Duration;
import junit.framework.TestCase;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.ODEpoch;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import org.jopendocument.dom.style.data.DataStyle;
import org.jopendocument.dom.style.data.NumberStyle;
import org.jopendocument.util.TimeUtils;

public class DataStyleTest
extends TestCase {
    public void testDays() throws Exception {
        ODEpoch oDEpoch = ODEpoch.getDefaultEpoch();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(2011, 2, 27, 12, 0);
        DataStyleTest.assertEquals((Object)new BigDecimal("40629.5"), (Object)oDEpoch.getDays(calendar));
        DataStyleTest.assertEquals((Object)calendar, (Object)oDEpoch.getDate(oDEpoch.getDays(calendar)));
        calendar.clear();
        calendar.set(1909, 8, 4, 0, 0);
        BigDecimal bigDecimal = BigDecimal.valueOf(3535L);
        DataStyleTest.assertEquals((Object)calendar, (Object)oDEpoch.getDate(bigDecimal));
        DataStyleTest.assertEquals((Object)bigDecimal, (Object)oDEpoch.getDays(calendar));
        Calendar calendar2 = oDEpoch.getDate(bigDecimal, Calendar.getInstance(TimeZone.getTimeZone("GMT-12:00")));
        Calendar calendar3 = oDEpoch.getDate(bigDecimal, Calendar.getInstance(TimeZone.getTimeZone("GMT+13:00")));
        DataStyleTest.assertFalse((calendar2.getTimeInMillis() == calendar3.getTimeInMillis() ? 1 : 0) != 0);
        DataStyleTest.assertTrue((TimeUtils.normalizeLocalTime(calendar2) == TimeUtils.normalizeLocalTime(calendar3) ? 1 : 0) != 0);
        DataStyleTest.assertTrue((TimeUtils.normalizeLocalTime(calendar) == TimeUtils.normalizeLocalTime(calendar3) ? 1 : 0) != 0);
        for (int i = -10; i < 500; ++i) {
            BigDecimal bigDecimal2 = BigDecimal.valueOf(i);
            DataStyleTest.assertEquals((Object)bigDecimal2, (Object)oDEpoch.getDays(oDEpoch.getDate(bigDecimal2)));
        }
        Calendar calendar4 = Calendar.getInstance(Locale.FRANCE);
        calendar4.set(11, 2);
        calendar4.set(12, 30);
        for (int i = 0; i < 500; ++i) {
            BigDecimal bigDecimal3 = oDEpoch.getDays(calendar4);
            DataStyleTest.assertEquals((Object)calendar4, (Object)oDEpoch.getDate(bigDecimal3));
            calendar4.add(6, -1);
        }
    }

    public void testFormat() throws Exception {
        MutableCell mutableCell;
        Object object;
        Object object2;
        MutableCell mutableCell2;
        Sheet sheet = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("cellFormat.ods")).getSpreadSheet().getSheet(0);
        int n = sheet.getCurrentRegion((int)0, (int)0).getEndPoint().y;
        for (int i = 0; i <= n; ++i) {
            mutableCell2 = sheet.getCellAt(0, i);
            object2 = mutableCell2.getTextValue();
            object = mutableCell2.getValueType();
            mutableCell = mutableCell2.getValue();
            mutableCell2.setValue("string");
            mutableCell2.setValue(12.3);
            mutableCell2.setValue(new Date());
            mutableCell2.setValue(true);
            mutableCell2.clearValue();
            if (object != null) {
                mutableCell2.setValue(mutableCell, (ODValueType)((Object)object), false, false);
            }
            DataStyleTest.assertEquals((String)object2, (String)mutableCell2.getTextValue());
            DataStyleTest.assertEquals((Object)object, (Object)((Object)mutableCell2.getValueType()));
        }
        MutableCell mutableCell3 = sheet.getCellAt("A17");
        DataStyleTest.assertEquals((Object)12.34, (Object)((Number)mutableCell3.getValue()).doubleValue());
        DataStyleTest.assertEquals((String)"12,34", (String)mutableCell3.getTextValue());
        mutableCell3.setValue(-12.34);
        DataStyleTest.assertEquals((Object)-12.34, (Object)((Number)mutableCell3.getValue()).doubleValue());
        DataStyleTest.assertEquals((String)"-12", (String)mutableCell3.getTextValue());
        mutableCell3.setValue(Boolean.FALSE, false);
        DataStyleTest.assertEquals((Object)((Object)ODValueType.BOOLEAN), (Object)((Object)mutableCell3.getValueType()));
        DataStyleTest.assertEquals((Object)Boolean.FALSE, (Object)mutableCell3.getValue());
        DataStyleTest.assertEquals((String)"false", (String)mutableCell3.getTextValue());
        mutableCell3.setValue(Boolean.FALSE, true);
        DataStyleTest.assertEquals((Object)((Object)ODValueType.FLOAT), (Object)((Object)mutableCell3.getValueType()));
        DataStyleTest.assertEquals((int)0, (int)((Number)mutableCell3.getValue()).intValue());
        DataStyleTest.assertEquals((String)"0,00", (String)mutableCell3.getTextValue());
        mutableCell3.setValue(Boolean.TRUE, true);
        DataStyleTest.assertEquals((Object)((Object)ODValueType.FLOAT), (Object)((Object)mutableCell3.getValueType()));
        DataStyleTest.assertEquals((int)1, (int)((Number)mutableCell3.getValue()).intValue());
        DataStyleTest.assertEquals((String)"1,00", (String)mutableCell3.getTextValue());
        mutableCell2 = sheet.getCellAt("A18");
        mutableCell2.setValue(17, false);
        DataStyleTest.assertEquals((Object)((Object)ODValueType.FLOAT), (Object)((Object)mutableCell2.getValueType()));
        DataStyleTest.assertEquals((Object)BigDecimal.valueOf(17L), (Object)mutableCell2.getValue());
        DataStyleTest.assertEquals((String)"17", (String)mutableCell2.getTextValue());
        mutableCell2.setValue(17, true);
        DataStyleTest.assertEquals((Object)((Object)ODValueType.BOOLEAN), (Object)((Object)mutableCell2.getValueType()));
        DataStyleTest.assertTrue((boolean)((Boolean)mutableCell2.getValue()));
        DataStyleTest.assertEquals((String)"VERDADEIRO", (String)mutableCell2.getTextValue());
        mutableCell3.setValue(TimeUtils.getTypeFactory().newDuration(true, 0, 0, 1, 36, 0, 0), false);
        DataStyleTest.assertEquals((Object)((Object)ODValueType.TIME), (Object)((Object)mutableCell3.getValueType()));
        DataStyleTest.assertEquals((int)36, (int)((Duration)mutableCell3.getValue()).getHours());
        DataStyleTest.assertEquals((String)"60:00:00", (String)mutableCell3.getTextValue());
        mutableCell3.setValue(TimeUtils.getTypeFactory().newDuration(true, 0, 0, 0, 36, 0, 0), true);
        DataStyleTest.assertEquals((Object)((Object)ODValueType.FLOAT), (Object)((Object)mutableCell3.getValueType()));
        DataStyleTest.assertEquals((Object)1.5, (Object)((Number)mutableCell3.getValue()).doubleValue());
        DataStyleTest.assertEquals((String)"1,50", (String)mutableCell3.getTextValue());
        mutableCell3.setValue(TimeUtils.getTypeFactory().newDuration(true, 0, 0, 180, 2, 24, 0), true);
        DataStyleTest.assertEquals((Object)((Object)ODValueType.FLOAT), (Object)((Object)mutableCell3.getValueType()));
        DataStyleTest.assertEquals((Object)180.1, (Object)((Number)mutableCell3.getValue()).doubleValue());
        DataStyleTest.assertEquals((String)"180,10", (String)mutableCell3.getTextValue());
        mutableCell2 = Calendar.getInstance();
        ((Calendar)((Object)mutableCell2)).clear();
        ((Calendar)((Object)mutableCell2)).set(2011, 8, 25, 12, 0);
        mutableCell3.setValue(mutableCell2, true);
        DataStyleTest.assertEquals((Object)((Object)ODValueType.FLOAT), (Object)((Object)mutableCell3.getValueType()));
        DataStyleTest.assertEquals((Object)new BigDecimal("40811.5"), (Object)mutableCell3.getValue());
        DataStyleTest.assertEquals((String)"40811,50", (String)mutableCell3.getTextValue());
        mutableCell2 = sheet.getCellAt("A1");
        DataStyleTest.assertEquals((Object)((Object)ODValueType.FLOAT), (Object)((Object)mutableCell2.getValueType()));
        DataStyleTest.assertTrue((boolean)(mutableCell2.getDataStyle() instanceof NumberStyle));
        mutableCell2.setValue("toto");
        DataStyleTest.assertEquals((Object)"toto", (Object)mutableCell2.getValue());
        DataStyleTest.assertEquals((String)"toto", (String)mutableCell2.getTextValue());
        DataStyleTest.assertEquals((Object)((Object)ODValueType.STRING), (Object)((Object)mutableCell2.getValueType()));
        DataStyleTest.assertTrue((boolean)(mutableCell2.getDataStyle() instanceof NumberStyle));
        mutableCell2.setValue(1.6);
        DataStyleTest.assertEquals((String)"02", (String)mutableCell2.getTextValue());
        object2 = sheet.getCellAt("A8");
        DataStyleTest.assertEquals((Object)((Object)ODValueType.PERCENTAGE), (Object)((Object)((Cell)object2).getValueType()));
        ((MutableCell)object2).setValue(0.35);
        DataStyleTest.assertEquals((Object)new BigDecimal("0.35"), (Object)((Cell)object2).getValue());
        DataStyleTest.assertEquals((Object)((Object)ODValueType.PERCENTAGE), (Object)((Object)((Cell)object2).getValueType()));
        ((MutableCell)object2).setValue(new Date(), false);
        DataStyleTest.assertEquals((Object)((Object)ODValueType.DATE), (Object)((Object)((Cell)object2).getValueType()));
        object = sheet.getCellAt("A12");
        DataStyleTest.assertEquals((Object)((Object)ODValueType.DATE), (Object)((Object)((Cell)object).getValueType()));
        ((MutableCell)object).setValue(40000, true);
        DataStyleTest.assertEquals((Object)((Object)ODValueType.DATE), (Object)((Object)((Cell)object).getValueType()));
        DataStyleTest.assertEquals((Object)((SpreadSheet)sheet.getODDocument()).getEpoch().getDate(BigDecimal.valueOf(40000L)).getTime(), (Object)((Cell)object).getValue());
        ((MutableCell)object).setValue(new Date());
        DataStyleTest.assertEquals((Object)((Object)ODValueType.DATE), (Object)((Object)((Cell)object).getValueType()));
        mutableCell = sheet.getCellAt("B1");
        mutableCell.setValue(Boolean.TRUE, ODValueType.BOOLEAN, false, true);
        DataStyleTest.assertEquals((Object)Boolean.TRUE, (Object)mutableCell.getValue());
        DataStyleTest.assertEquals((Object)((Object)ODValueType.BOOLEAN), (Object)((Object)mutableCell.getValueType()));
        try {
            mutableCell.setValue(Boolean.TRUE, ODValueType.BOOLEAN, false, false);
            DataStyleTest.fail((String)"Should have thrown an exception since the fwk cannot yet format boolean");
        }
        catch (Exception exception) {
            // empty catch block
        }
        mutableCell.setValue(0.0912645, ODValueType.PERCENTAGE, false, false);
        DataStyleTest.assertEquals((Object)new BigDecimal("0.0912645"), (Object)mutableCell.getValue());
        DataStyleTest.assertEquals((Object)0.0912645, (Object)((Number)mutableCell.getValue()).doubleValue());
        DataStyleTest.assertEquals((Object)((Object)ODValueType.PERCENTAGE), (Object)((Object)mutableCell.getValueType()));
        Date date = new Date();
        mutableCell.setValue(date);
        DataStyleTest.assertEquals((Object)date, (Object)mutableCell.getValue());
        DataStyleTest.assertEquals((Object)((Object)ODValueType.DATE), (Object)((Object)mutableCell.getValueType()));
        Object object3 = NumberStyle.DESC.getElementNS();
        Object object4 = new Element(NumberStyle.DESC.getElementName(), (Namespace)object3);
        ((Element)object4).setAttribute("name", NumberStyle.DESC.getBaseName() + "0", NumberStyle.DESC.getVersion().getSTYLE());
        Object object5 = new Element("number", (Namespace)object3);
        ((Element)object5).setAttribute("min-integer-digits", "3", (Namespace)object3);
        ((Element)object5).addContent(new Element("embedded-text", (Namespace)object3).setAttribute("position", "2", (Namespace)object3).setText("inTxt"));
        ((Element)object5).addContent(new Element("embedded-text", (Namespace)object3).setAttribute("position", "9", (Namespace)object3).setText("other"));
        ((Element)object4).addContent((Content)object5);
        ((SpreadSheet)sheet.getODDocument()).getPackage().getStyles().getChild("styles", true).addContent((Content)object4);
        DataStyleTest.assertEquals((String)"other0inTxt53,10", (String)new NumberStyle(((SpreadSheet)sheet.getODDocument()).getPackage(), (Element)object4).format(53.1, null, false));
        ((Element)object5).removeContent();
        DataStyleTest.assertEquals((String)"053,10", (String)new NumberStyle(((SpreadSheet)sheet.getODDocument()).getPackage(), (Element)object4).format(53.1, null, false));
        object3 = sheet.getCellAt("A11");
        object4 = sheet.getCellAt("C11");
        DataStyleTest.assertEquals((String)((MutableCell)object3).getStyleName(), (String)((MutableCell)object4).getStyleName());
        object5 = ((MutableCell)object3).getDataStyle();
        DataStyle dataStyle = ((MutableCell)object4).getDataStyle();
        DataStyleTest.assertFalse((boolean)((Style)object5).getName().equals(dataStyle.getName()));
        DataStyleTest.assertEquals((Object)Color.RED, (Object)((DataStyle)object5).getTextProperties().getColor());
        DataStyleTest.assertEquals(null, (Object)dataStyle.getTextProperties().getColor());
    }
}

