/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.style.data;

import java.text.DecimalFormatSymbols;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.style.data.DataStyle;
import org.jopendocument.dom.style.data.DateStyle;
import org.jopendocument.dom.style.data.NumberStyle;

public class CurrencyStyle
extends DataStyle {
    public static final DataStyle.DataStyleDesc<CurrencyStyle> DESC = new DataStyle.DataStyleDesc<CurrencyStyle>(CurrencyStyle.class, XMLVersion.OD, "currency-style", "N"){

        @Override
        public CurrencyStyle create(ODPackage oDPackage, Element element) {
            return new CurrencyStyle(oDPackage, element);
        }
    };

    public CurrencyStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element, ODValueType.CURRENCY);
    }

    @Override
    protected Object convertNonNull(Object object) {
        return NumberStyle.toNumber(object, this.getEpoch());
    }

    @Override
    public String format(Object object, CellStyle cellStyle, boolean bl) {
        Number number = (Number)object;
        Namespace namespace = this.getElement().getNamespace();
        StringBuilder stringBuilder = new StringBuilder();
        List list = this.getElement().getChildren();
        for (Element element : list) {
            if (!element.getNamespace().equals(namespace)) continue;
            if (element.getName().equals("text")) {
                stringBuilder.append(element.getText());
                continue;
            }
            if (element.getName().equals("number")) {
                int n = number.doubleValue() > 0.0 ? 1 : -1;
                stringBuilder.append(this.formatNumberOrScientificNumber(element, number, n, cellStyle));
                continue;
            }
            if (!element.getName().equals("currency-symbol")) continue;
            if (element.getTextTrim().length() > 0) {
                stringBuilder.append(element.getText());
                continue;
            }
            stringBuilder.append(new DecimalFormatSymbols(DateStyle.getLocale(element)).getCurrencySymbol());
        }
        return stringBuilder.toString();
    }
}

