/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.style.data;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.style.data.DataStyle;
import org.jopendocument.dom.style.data.DateStyle;
import org.jopendocument.util.NumberUtils;
import org.jopendocument.util.i18n.I18nUtils;

public class BooleanStyle
extends DataStyle {
    public static final DataStyle.DataStyleDesc<BooleanStyle> DESC = new DataStyle.DataStyleDesc<BooleanStyle>(BooleanStyle.class, XMLVersion.OD, "boolean-style", "N"){

        @Override
        public BooleanStyle create(ODPackage oDPackage, Element element) {
            return new BooleanStyle(oDPackage, element);
        }
    };

    public static final Boolean toBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return !NumberUtils.areNumericallyEqual(0, (Number)object);
        }
        return null;
    }

    public BooleanStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element, ODValueType.BOOLEAN);
    }

    @Override
    protected Boolean convertNonNull(Object object) {
        return BooleanStyle.toBoolean(object);
    }

    @Override
    public String format(Object object, CellStyle cellStyle, boolean bl) {
        Boolean bl2 = (Boolean)object;
        Namespace namespace = this.getElement().getNamespace();
        Locale locale = DateStyle.getLocale(this.getElement());
        StringBuilder stringBuilder = new StringBuilder();
        List list = this.getElement().getChildren();
        for (Element element : list) {
            if (!element.getNamespace().equals(namespace)) continue;
            if (element.getName().equals("text")) {
                stringBuilder.append(element.getText());
                continue;
            }
            if (!element.getName().equals("boolean")) continue;
            ResourceBundle resourceBundle = ResourceBundle.getBundle(I18nUtils.RSRC_BASENAME, locale);
            if (!resourceBundle.getLocale().getLanguage().equals(locale.getLanguage())) {
                this.reportError("Boolean not localized", bl);
            }
            stringBuilder.append(resourceBundle.getString(I18nUtils.getBooleanKey(bl2)).toUpperCase(locale));
        }
        return stringBuilder.toString();
    }
}

