/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.style;

import java.util.HashMap;
import java.util.Map;
import org.jopendocument.util.CompareUtils;

public enum RelationalOperator {
    LT("<"){

        @Override
        protected boolean evaluate(int n) {
            return n < 0;
        }
    }
    ,
    GT(">"){

        @Override
        protected boolean evaluate(int n) {
            return n > 0;
        }
    }
    ,
    LE("<="){

        @Override
        protected boolean evaluate(int n) {
            return n <= 0;
        }
    }
    ,
    GE(">="){

        @Override
        protected boolean evaluate(int n) {
            return n >= 0;
        }
    }
    ,
    EQ("="){

        @Override
        protected boolean evaluate(int n) {
            return n == 0;
        }
    }
    ,
    NE("!="){

        @Override
        protected boolean evaluate(int n) {
            return !EQ.evaluate(n);
        }
    };

    private final String s;
    public static final String OR_PATTERN;
    private static final Map<String, RelationalOperator> instances;

    private RelationalOperator(String string2) {
        this.s = string2;
    }

    public final String asString() {
        return this.s;
    }

    public final boolean compare(Object object, Object object2) {
        return this.evaluate(CompareUtils.compare(object, object2));
    }

    protected abstract boolean evaluate(int var1);

    public static RelationalOperator getInstance(String string) {
        return instances.get(string);
    }

    static {
        instances = new HashMap<String, RelationalOperator>();
        StringBuilder stringBuilder = new StringBuilder(32);
        for (RelationalOperator relationalOperator : RelationalOperator.values()) {
            instances.put(relationalOperator.s, relationalOperator);
            stringBuilder.append(relationalOperator.asString());
            stringBuilder.append('|');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        OR_PATTERN = stringBuilder.toString();
    }
}

