/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.style;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.Arrays;
import org.jdom.Element;
import org.jopendocument.dom.LengthUnit;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.style.SideStyleProperties;

public class PageLayoutStyle
extends Style {
    public static final StyleDesc<PageLayoutStyle> DESC = new StyleDesc<PageLayoutStyle>(PageLayoutStyle.class, XMLVersion.OD, "page-layout", "pm"){
        {
            this.getRefElementsMap().putAll((Object)"style:page-layout-name", Arrays.asList("presentation:notes", "style:handout-master", "style:master-page"));
        }

        @Override
        public PageLayoutStyle create(ODPackage oDPackage, Element element) {
            return new PageLayoutStyle(oDPackage, element);
        }
    };
    public static final StyleDesc<PageLayoutStyle> DESC_OO = new StyleDesc<PageLayoutStyle>(PageLayoutStyle.class, XMLVersion.OOo, "page-master", "pm"){
        {
            this.getRefElementsMap().putAll((Object)"style:page-master-name", Arrays.asList("presentation:notes", "style:handout-master", "style:master-page"));
        }

        @Override
        public PageLayoutStyle create(ODPackage oDPackage, Element element) {
            return new PageLayoutStyle(oDPackage, element);
        }
    };
    private PageLayoutProperties props = null;

    public PageLayoutStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element);
    }

    public final PageLayoutProperties getPageLayoutProperties() {
        if (this.props == null) {
            this.props = new PageLayoutProperties(this);
        }
        return this.props;
    }

    public final Color getBackgroundColor() {
        return this.getPageLayoutProperties().getBackgroundColor();
    }

    public static class PageLayoutProperties
    extends SideStyleProperties {
        public PageLayoutProperties(Style style) {
            super(style, DESC.getElementName());
        }

        public final String getRawMargin(SideStyleProperties.Side side) {
            return this.getSideAttribute(side, "margin", this.getNS("fo"));
        }

        public final BigDecimal getMargin(SideStyleProperties.Side side, LengthUnit lengthUnit) {
            return LengthUnit.parseLength(this.getRawMargin(side), lengthUnit);
        }

        public final BigDecimal getPageWidth(LengthUnit lengthUnit) {
            return this.getLengthAttr("page-width", "fo", lengthUnit);
        }

        public final BigDecimal getPageHeight(LengthUnit lengthUnit) {
            return this.getLengthAttr("page-height", "fo", lengthUnit);
        }

        private final BigDecimal getLengthAttr(String string, String string2, LengthUnit lengthUnit) {
            return LengthUnit.parseLength(this.getAttributeValue(string, this.getNS(string2)), lengthUnit);
        }
    }
}

