/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Color;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import junit.framework.TestCase;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.OOXML;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.StyledNode;
import org.jopendocument.dom.XMLFormatVersion;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.Column;
import org.jopendocument.dom.spreadsheet.ColumnStyle;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.spreadsheet.Range;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SheetTableModel;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import org.jopendocument.dom.spreadsheet.Table;
import org.jopendocument.dom.spreadsheet.TableCalcNode;
import org.jopendocument.dom.spreadsheet.TableGroup;
import org.jopendocument.dom.style.SideStyleProperties;
import org.jopendocument.dom.text.Paragraph;
import org.jopendocument.dom.text.ParagraphStyle;
import org.jopendocument.dom.text.TextDocument;
import org.jopendocument.util.SimpleXMLPath;
import org.jopendocument.util.Tuple2;
import org.jopendocument.util.Validator;

public class SheetTest
extends TestCase {
    static final DefaultTableModel tm = new DefaultTableModel();
    private Sheet sheet;
    private Sheet realSheet;

    protected void setUp() throws Exception {
        this.sheet = SpreadSheet.createEmpty(tm, XMLFormatVersion.getOOo()).getSheet(0);
        this.realSheet = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.ods")).getSpreadSheet().getSheet(0);
    }

    protected void tearDown() throws Exception {
        this.sheet = null;
        this.realSheet = null;
    }

    public void testCreate() throws IOException {
        Object object;
        Object object2;
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        for (OOXML object32 : OOXML.values()) {
            if (!object32.canValidate()) continue;
            object2 = SpreadSheet.createEmpty(defaultTableModel, object32.getFormatVersion());
            object = ((ODDocument)object2).getPackage().getContent().getValidator();
            this.assertValid((SpreadSheet)object2);
            this.assertValid((Validator)object);
            SheetTest.assertEquals((int)0, (int)((Validator)object).validateCompletely().size());
            ((SpreadSheet)object2).getSheet(0).getElement().removeContent();
            SheetTest.assertValid(((ODDocument)object2).getPackage(), false);
            this.assertValid((Validator)object, false);
            SheetTest.assertTrue((((Validator)object).validateCompletely().size() > 0 ? 1 : 0) != 0);
        }
        DefaultTableModel defaultTableModel2 = new DefaultTableModel(new Object[][]{{"Data", "DataCol2"}}, new Object[]{"Col1", "Col2"});
        SpreadSheet spreadSheet = SpreadSheet.createEmpty(defaultTableModel2);
        this.assertValid(spreadSheet);
        object2 = File.createTempFile("testCreate", "." + spreadSheet.getPackage().getContentType().getExtension());
        object = spreadSheet.saveAs((File)object2);
        ((File)object).deleteOnExit();
        if (!((File)object2).equals(object)) {
            ((File)object2).delete();
            SheetTest.fail((String)("Wrong extension : " + object2));
        }
        Sheet sheet = SpreadSheet.createFromFile((File)object).getSheet(0);
        SheetTest.assertEquals((int)2, (int)sheet.getRowCount());
        SheetTest.assertEquals((Object)"Col1", (Object)sheet.getValueAt("A1"));
        SheetTableModel sheetTableModel = sheet.getTableModel(0, 1);
        SheetTest.assertEquals((int)2, (int)sheetTableModel.getColumnCount());
        SheetTest.assertEquals((int)1, (int)sheetTableModel.getRowCount());
        SheetTest.assertEquals((Object)"DataCol2", (Object)sheetTableModel.getValueAt(0, 1));
        ODPackage oDPackage = this.realSheet.getSpreadSheet().getPackage();
        try {
            oDPackage.rmFile(ODPackage.RootElement.CONTENT.getZipEntry());
            SheetTest.fail((String)"Cannot rm a file used by the ODDocument");
        }
        catch (Exception exception) {
            // empty catch block
        }
        oDPackage.putFile(ODPackage.RootElement.SETTINGS.getZipEntry(), ODPackage.RootElement.SETTINGS.createDocument(oDPackage.getFormatVersion()));
        new ODPackage(oDPackage).rmFile(ODPackage.RootElement.CONTENT.getZipEntry());
    }

    public void testName() throws Exception {
        int n;
        int n2;
        SpreadSheet spreadSheet = this.realSheet.getSpreadSheet();
        SheetTest.assertEquals((String)"users", (String)spreadSheet.getSheet("users").getName());
        SheetTest.assertFalse((boolean)"newName".equals(this.realSheet.getName()));
        this.realSheet.setName("newName");
        SheetTest.assertTrue((boolean)"newName".equals(this.realSheet.getName()));
        SheetTest.assertSame((Object)this.realSheet, (Object)spreadSheet.getSheet("newName"));
        SheetTest.assertEquals((int)4, (int)spreadSheet.getSheetCount());
        Sheet sheet = spreadSheet.getSheet(0);
        Sheet sheet2 = spreadSheet.getSheet(1);
        Sheet sheet3 = spreadSheet.addSheet(2, "newSheet");
        SheetTest.assertEquals((int)5, (int)spreadSheet.getSheetCount());
        SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet("newSheet"));
        SheetTest.assertSame((Object)sheet, (Object)spreadSheet.getSheet(0));
        SheetTest.assertSame((Object)sheet2, (Object)spreadSheet.getSheet(1));
        SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet(2));
        sheet3.ensureRowCount(8);
        sheet3.ensureColumnCount(10);
        for (n2 = 0; n2 < 10; ++n2) {
            for (n = 0; n < 8; ++n) {
                sheet3.setValueAt(n2 + "," + n, n2, n);
            }
        }
        this.assertValid(this.realSheet.getSpreadSheet());
        for (n2 = 0; n2 < 3; ++n2) {
            sheet3.move(n2);
            SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet(n2));
        }
        sheet3.move(0);
        SheetTest.assertEquals((int)5, (int)spreadSheet.getSheetCount());
        SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet("newSheet"));
        SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet(0));
        SheetTest.assertSame((Object)sheet, (Object)spreadSheet.getSheet(1));
        SheetTest.assertSame((Object)sheet2, (Object)spreadSheet.getSheet(2));
        this.assertValid(this.realSheet.getSpreadSheet());
        Sheet sheet4 = sheet3.copy(2, "copiedSheet");
        SheetTest.assertEquals((int)6, (int)spreadSheet.getSheetCount());
        SheetTest.assertSame((Object)sheet4, (Object)spreadSheet.getSheet("copiedSheet"));
        SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet(0));
        SheetTest.assertSame((Object)sheet, (Object)spreadSheet.getSheet(1));
        SheetTest.assertSame((Object)sheet4, (Object)spreadSheet.getSheet(2));
        SheetTest.assertSame((Object)sheet2, (Object)spreadSheet.getSheet(3));
        this.assertValid(this.realSheet.getSpreadSheet());
        n = spreadSheet.getSheetCount();
        SheetTest.assertSame((Object)sheet, (Object)this.realSheet);
        this.realSheet.detach();
        SheetTest.assertNull((Object)spreadSheet.getSheet(this.realSheet.getName()));
        SheetTest.assertEquals((int)(n - 1), (int)spreadSheet.getSheetCount());
        SheetTest.assertSame((Object)sheet3, (Object)spreadSheet.getSheet(0));
        SheetTest.assertSame((Object)sheet4, (Object)spreadSheet.getSheet(1));
        SheetTest.assertSame((Object)sheet2, (Object)spreadSheet.getSheet(2));
        this.assertValid(this.realSheet.getSpreadSheet());
        SheetTest.assertTrue((boolean)"aposAndTab".equals(SpreadSheet.formatSheetName("aposAndTab")));
        SheetTest.assertFalse((boolean)"apos ' & tab \t".equals(SpreadSheet.formatSheetName("apos ' & tab \t")));
        SheetTest.assertEquals((String)"'apos '' & tab \t'", (String)SpreadSheet.formatSheetName("apos ' & tab \t"));
        SheetTest.assertEquals((String)"apos ' & tab \t", (String)SpreadSheet.parseSheetName(SpreadSheet.formatSheetName("apos ' & tab \t")));
        try {
            SpreadSheet.parseSheetName("'foo");
            SheetTest.fail((String)"should have failed since quote is not closed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetValueAt() throws Exception {
        SheetTest.assertEquals((Object)"col1", (Object)this.sheet.getValueAt(0, 0));
        this.sheet.setValueAt("test", 0, 0);
        SheetTest.assertEquals((Object)"test", (Object)this.sheet.getValueAt(0, 0));
        this.sheet.setValueAt(6.00013991523E7, 0, 0);
        SheetTest.assertEquals((Object)new BigDecimal("60001399.1523"), (Object)this.sheet.getValueAt(0, 0));
        Calendar calendar = Calendar.getInstance();
        this.sheet.setValueAt(calendar.getTime(), 0, 0);
        Object object = this.sheet.getValueAt(0, 0);
        SheetTest.assertEquals((Object)calendar.getTime(), (Object)object);
        this.assertValid(this.sheet.getSpreadSheet());
        try {
            this.realSheet.getCellAt("C3");
            SheetTest.fail((String)"should have failed since C3 is covered");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.realSheet.getCellAt("B3").unmerge();
        this.realSheet.getCellAt("C3").setValue(new Date());
        ODPackage oDPackage = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("../test.odt"));
        Table<TextDocument> table = new Table<TextDocument>(oDPackage.getTextDocument(), oDPackage.getContent().getDescendantByName("table:table", "JODTestTable"));
        MutableCell<TextDocument> mutableCell = table.getCellAt(2, 1);
        SheetTest.assertEquals((String)"end", (String)this.getFirstPStyle(mutableCell).getAlignment());
        mutableCell.setValue("somethingElse");
        SheetTest.assertEquals((String)"end", (String)this.getFirstPStyle(mutableCell).getAlignment());
        this.sheet.setValueAt("spaces   and tab\t.", 0, 0);
        SheetTest.assertEquals((Object)"spaces   and tab\t.", (Object)this.sheet.getValueAt(0, 0));
        this.assertValid(this.realSheet.getSpreadSheet());
    }

    private final ParagraphStyle getFirstPStyle(Cell<TextDocument> cell) {
        Paragraph paragraph = new Paragraph(cell.getElement().getChild("p", cell.getNS().getTEXT()));
        paragraph.setDocument((TextDocument)cell.getODDocument());
        return (ParagraphStyle)paragraph.getStyle();
    }

    public void testGetValueAt() {
        SheetTest.assertEquals((Object)new BigDecimal(123), (Object)this.sheet.getValueAt(2, 1));
        SheetTest.assertEquals((Object)new BigDecimal(123), (Object)this.sheet.getValueAt("C2"));
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(2008, 11, 25);
        Cell cell = this.realSheet.getImmutableCellAt("F3");
        SheetTest.assertEquals((Object)calendar.getTime(), (Object)cell.getValue());
        SheetTest.assertEquals((String)"25 d\u00e9c. 2008", (String)cell.getTextValue());
        Cell cell2 = this.realSheet.getImmutableCellAt("B3");
        SheetTest.assertEquals((Object)"Gestion\tdes droits\nnouvelle  arborescence ", (Object)cell2.getValue());
        SheetTest.assertEquals((String)"Gestion\tdes droits\nnouvelle  arborescence ", (String)cell2.getTextValue(true));
        cell2.getElement().removeContent();
        Element element = new Element("p", cell2.getElement().getNamespace("text"));
        element.addContent("\n\t\tGestion \t des droits");
        cell2.getElement().addContent("\n\t").addContent(element).addContent("\n");
        SheetTest.assertEquals((String)"Gestion des droits", (String)cell2.getTextValue(false));
        SheetTest.assertSame(this.realSheet.getCellAt("F3"), this.realSheet.getSpreadSheet().getCellAt(this.realSheet.getName() + ".$F$3"));
        SheetTableModel sheetTableModel = this.realSheet.getSpreadSheet().getSheet(1).getTableModel(1, 1);
        SheetTest.assertNotNull((Object)sheetTableModel.getImmutableCellAt(0, 0).getError());
        SheetTest.assertNotNull((Object)sheetTableModel.getImmutableCellAt(1, 0).getError());
        SheetTest.assertNull((Object)sheetTableModel.getImmutableCellAt(1, 1).getError());
        SheetTest.assertNotNull((Object)sheetTableModel.getImmutableCellAt(2, 0).getError());
        SheetTest.assertTrue((boolean)sheetTableModel.getImmutableCellAt(2, 1).isEmpty());
        SheetTest.assertNull((Object)sheetTableModel.getImmutableCellAt(2, 1).getError());
    }

    public void testGetCount() {
        SheetTest.assertEquals((int)2, (int)this.sheet.getRowCount());
        SheetTest.assertEquals((int)3, (int)this.sheet.getColumnCount());
    }

    public void testEnsureColumnCount() {
        int n = this.sheet.getColumnCount();
        int n2 = n - 2;
        this.sheet.ensureColumnCount(n2);
        SheetTest.assertEquals((int)n, (int)this.sheet.getColumnCount());
    }

    public void testSetColumnCount() throws Exception {
        int n = this.sheet.getColumnCount() + 5;
        try {
            this.sheet.setValueAt("test", n - 1, 0);
            SheetTest.fail((String)"should have thrown IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.sheet.setColumnCount(n);
        this.sheet.setValueAt("test", n - 1, 0);
        int n2 = this.realSheet.getColumnCount();
        try {
            this.realSheet.setValueAt("over", n2 + 10 - 1, 1);
            SheetTest.fail((String)"should throw exn since we try to write past the limit");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.realSheet.setColumnCount(n2 + 10);
        this.realSheet.setValueAt("over", n2 + 10 - 1, 1);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(15360);
        this.realSheet.getSpreadSheet().getPackage().save(byteArrayOutputStream);
        SpreadSheet spreadSheet = new ODPackage(new ByteArrayInputStream(byteArrayOutputStream.toByteArray())).getSpreadSheet();
        SheetTest.assertEquals((Object)"over", (Object)spreadSheet.getSheet(0).getValueAt(n2 + 10 - 1, 1));
        this.assertValid(this.realSheet.getSpreadSheet());
    }

    public void testRemoveCol() throws Exception {
        this.realSheet.setColumnCount(9, -1, true);
        SheetTest.assertEquals((int)9, (int)this.realSheet.getColumnCount());
        SheetTest.assertFalse((boolean)this.realSheet.getImmutableCellAt("C3").isValid());
        this.realSheet.removeColumn(1, true);
        SheetTest.assertEquals((int)8, (int)this.realSheet.getColumnCount());
        SheetTest.assertTrue((boolean)this.realSheet.getImmutableCellAt("C3").isValid());
        ODPackage oDPackage = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("../test.odt"));
        Table<ODDocument> table = new Table<ODDocument>(oDPackage.getODDocument(), oDPackage.getContent().getDescendantByName("table:table", "JODTestTable"));
        float f = table.getColumn(1).getWidth().floatValue();
        float f2 = table.getWidth().floatValue();
        table.removeColumn(1, false);
        SheetTest.assertTrue((Math.abs(f2 - f - table.getWidth().floatValue()) <= Math.ulp(table.getWidth().floatValue()) ? 1 : 0) != 0);
        f2 = table.getWidth().floatValue();
        table.removeColumn(1, true);
        SheetTest.assertEquals((Object)Float.valueOf(f2), (Object)table.getWidth());
    }

    public void testSetRowCount() throws IOException {
        this.realSheet.setRowCount(3);
        SheetTest.assertEquals((int)3, (int)this.realSheet.getRowCount());
        SpreadSheet spreadSheet = new ODPackage(this.realSheet.getSpreadSheet().getPackage()).getSpreadSheet();
        SheetTest.assertEquals((int)3, (int)spreadSheet.getSheet(0).getRowCount());
        this.assertValid(this.realSheet.getSpreadSheet());
    }

    public void testGetTableModel() {
        SheetTableModel sheetTableModel = this.sheet.getTableModel(1, 0);
        SheetTest.assertEquals((int)(tm.getColumnCount() - 1), (int)sheetTableModel.getColumnCount());
        SheetTest.assertEquals((int)(tm.getRowCount() + 1), (int)sheetTableModel.getRowCount());
        SheetTest.assertEquals((Object)new BigDecimal("-5.320"), (Object)sheetTableModel.getValueAt(1, 0));
        SheetTest.assertNull(sheetTableModel.getImmutableCellAt(0, 0).getStyle());
        try {
            sheetTableModel.getValueAt(1, sheetTableModel.getColumnCount());
            SheetTest.fail((String)"should have thrown exn");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGetMutableTableModel() {
        this.sheet.getMutableTableModel(1, 0).setValueAt("test", 0, 1);
        SheetTest.assertEquals((Object)"test", (Object)this.sheet.getCellAt("C1").getValue());
        SheetTableModel.MutableTableModel<SpreadSheet> mutableTableModel = this.realSheet.getSpreadSheet().getTableModel("rights");
        SheetTest.assertEquals((Object)"K1", (Object)mutableTableModel.getValueAt(13, 6));
        SheetTest.assertEquals((Object)Color.CYAN, (Object)((CellStyle)mutableTableModel.getCellAt(0, 0).getStyle()).getBackgroundColor());
        SheetTest.assertEquals((String)"#ffcc99", (String)((CellStyle)mutableTableModel.getCellAt(1, 2).getStyle()).getTableCellProperties().getRawBackgroundColor());
        try {
            mutableTableModel.setValueAt("foo", 0, mutableTableModel.getColumnCount());
            SheetTest.fail((String)"should have thrown exn");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testMerge() throws IOException {
        TableCalcNode tableCalcNode = this.realSheet.getSpreadSheet().getSheet(2);
        SheetTest.assertNull((Object)((Table)tableCalcNode).getCoverOrigin(0, 0));
        Point point = new Point(1, 11);
        for (int i = 0; i <= 5; ++i) {
            for (int j = 10; j <= 15; ++j) {
                if (i < 1 || i > 4 || j < 11 || j > 14) {
                    SheetTest.assertNull((Object)((Table)tableCalcNode).getCoverOrigin(i, j));
                    continue;
                }
                SheetTest.assertEquals((Object)point, (Object)((Table)tableCalcNode).getCoverOrigin(i, j));
            }
        }
        SheetTest.assertEquals((Object)new Point(0, 16), (Object)((Table)tableCalcNode).getCoverOrigin(1, 16));
        tableCalcNode = this.realSheet.getCellAt("B3");
        SheetTest.assertEquals((int)2, (int)((Cell)tableCalcNode).getColumnsSpanned());
        SheetTest.assertEquals((int)1, (int)((Cell)tableCalcNode).getRowsSpanned());
        ((MutableCell)tableCalcNode).unmerge();
        SheetTest.assertEquals((int)1, (int)((Cell)tableCalcNode).getColumnsSpanned());
        SheetTest.assertEquals((int)1, (int)((Cell)tableCalcNode).getRowsSpanned());
        SheetTest.assertFalse((boolean)this.realSheet.getImmutableCellAt("C3").isCovered());
        SheetTest.assertFalse((boolean)this.realSheet.getImmutableCellAt("B4").isCovered());
        SheetTest.assertNull((Object)this.realSheet.getCoverOrigin(((MutableCell)tableCalcNode).getX(), ((MutableCell)tableCalcNode).getY()));
        ((MutableCell)tableCalcNode).merge(3, 2);
        SheetTest.assertEquals((int)3, (int)((Cell)tableCalcNode).getColumnsSpanned());
        SheetTest.assertEquals((int)2, (int)((Cell)tableCalcNode).getRowsSpanned());
        SheetTest.assertFalse((boolean)((Cell)tableCalcNode).isCovered());
        SheetTest.assertTrue((boolean)this.realSheet.getImmutableCellAt("C3").isCovered());
        SheetTest.assertTrue((boolean)this.realSheet.getImmutableCellAt("B4").isCovered());
        try {
            this.realSheet.getCellAt("C3");
            SheetTest.fail((String)"should have thrown an exn");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SheetTest.assertEquals((Object)((MutableCell)tableCalcNode).getPoint(), (Object)this.realSheet.getCoverOrigin(((MutableCell)tableCalcNode).getX(), ((MutableCell)tableCalcNode).getY()));
        SheetTest.assertEquals((Object)((MutableCell)tableCalcNode).getPoint(), (Object)this.realSheet.getCoverOrigin(((MutableCell)tableCalcNode).getX() + 3 - 1, ((MutableCell)tableCalcNode).getY() + 2 - 1));
        ((MutableCell)tableCalcNode).merge(3, 3);
        SheetTest.assertEquals((int)3, (int)((Cell)tableCalcNode).getColumnsSpanned());
        SheetTest.assertEquals((int)3, (int)((Cell)tableCalcNode).getRowsSpanned());
        ((MutableCell)tableCalcNode).merge(1, 3);
        SheetTest.assertEquals((int)1, (int)((Cell)tableCalcNode).getColumnsSpanned());
        SheetTest.assertEquals((int)3, (int)((Cell)tableCalcNode).getRowsSpanned());
        SheetTest.assertFalse((boolean)((Cell)tableCalcNode).isCovered());
        SheetTest.assertFalse((boolean)this.realSheet.getImmutableCellAt("C3").isCovered());
        SheetTest.assertTrue((boolean)this.realSheet.getImmutableCellAt("B4").isCovered());
        try {
            this.realSheet.getCellAt(0, 0).merge(2, 4);
            SheetTest.fail((String)"Allowed overlapping merge");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SheetTest.assertFalse((boolean)this.realSheet.getImmutableCellAt(0, 0).coversOtherCells());
        SheetTest.assertFalse((boolean)this.realSheet.getImmutableCellAt(0, 1).isCovered());
        this.assertValid(this.realSheet.getSpreadSheet());
    }

    public void testResolve() {
        this.testResolve(new Point(0, 22), "A23");
        this.testResolve(new Point(26, 33), "AA34");
        this.testResolve(new Point(106, 11), "DC12");
        this.testResolve(new Point(25, 37), "Z38");
        this.testResolve(new Point(701, 0), "ZZ1");
        this.testResolve(new Point(702, 0), "AAA1");
        this.testResolve(new Point(730, 0), "ABC1");
        SheetTest.assertNull((Object)Sheet.resolve("A23A"));
        SheetTest.assertNull((Object)Sheet.resolve("test"));
        SheetTest.assertNull((Object)Sheet.resolve("23"));
        SheetTest.assertEquals((int)77, (int)Sheet.toInt("BZ"));
        Range range = Range.parse("Sheet1.A23:.AA34");
        SheetTest.assertFalse((boolean)range.spanSheets());
        SheetTest.assertEquals((String)"Sheet1", (String)range.getStartSheet());
        SheetTest.assertEquals((String)"Sheet1", (String)range.getEndSheet());
        SheetTest.assertEquals((Object)Sheet.resolve("A23"), (Object)range.getStartPoint());
        SheetTest.assertEquals((Object)Sheet.resolve("AA34"), (Object)range.getEndPoint());
        SheetTest.assertEquals((Object)range, (Object)Range.parse(range.toString()));
    }

    private void testResolve(Point point, String string) {
        SheetTest.assertEquals((Object)point, (Object)Sheet.resolve(string));
        SheetTest.assertEquals((String)string, (String)Sheet.getAddress(point));
    }

    public void testDuplicateRows() throws Exception {
        this.realSheet.duplicateRows(8, 3, 2);
        SheetTest.assertEquals((Object)this.realSheet.getValueAt("B11"), (Object)this.realSheet.getValueAt("B14"));
        SheetTest.assertEquals((Object)"Comptabilit\u00e9", (Object)this.realSheet.getValueAt("H9"));
        SheetTest.assertEquals((Object)this.realSheet.getValueAt("H9"), (Object)this.realSheet.getValueAt("H12"));
        SheetTest.assertEquals((Object)this.realSheet.getValueAt("H9"), (Object)this.realSheet.getValueAt("H15"));
        this.assertValid(this.realSheet.getSpreadSheet());
        SheetTest.assertEquals((int)2, (int)this.sheet.getRowCount());
        this.sheet.duplicateRows(1, 1, 3);
        SheetTest.assertEquals((int)5, (int)this.sheet.getRowCount());
        SheetTest.assertEquals((Object)this.sheet.getValueAt("C2"), (Object)this.sheet.getValueAt("C4"));
        Sheet sheet = this.realSheet.getSpreadSheet().getSheet("end'Cell & Address");
        try {
            sheet.duplicateRows(2, 2, 1, false);
            SheetTest.fail((String)"should have failed since a merged cell ends in the middle");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            sheet.duplicateRows(10, 2, 1, false);
            SheetTest.fail((String)"should have failed since a merged cell starts in the middle");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.testShapeSpan(sheet, "rect", "A1", "A3");
        this.testShapeSpan(sheet, "custom-shape", "A4", "B8");
        this.testShapeSpan(sheet, "frame", "E3", "E3");
        this.testShapeSpan(sheet, "line", "B1", "B6");
        this.testShapeSpan(sheet, "g", "B2", "D5");
        SheetTest.assertEquals((int)3, (int)sheet.getCellAt("F1").getRowsSpanned());
        sheet.duplicateRows(1, 2, 2, true);
        this.testShapeSpan(sheet, "rect", "A1", "A3");
        this.testShapeSpan(sheet, "custom-shape", "A8", "B12");
        this.testShapeSpan(sheet, "frame", "E3", "E3");
        this.testShapeSpan(sheet, "frame", "E5", "E5");
        this.testShapeSpan(sheet, "frame", "E7", "E7");
        this.testShapeSpan(sheet, "line", "B1", "B5");
        this.testShapeSpan(sheet, "g", "B2", "D5");
        this.testShapeSpan(sheet, "g", "B4", "D7");
        this.testShapeSpan(sheet, "g", "B6", "D9");
        SheetTest.assertEquals((int)7, (int)sheet.getCellAt("F1").getRowsSpanned());
        SheetTest.assertEquals((int)4, (int)sheet.getCellAt("B16").getRowsSpanned());
        sheet.duplicateRows(14, 6, 1, false);
        SheetTest.assertEquals((int)4, (int)sheet.getCellAt("B16").getRowsSpanned());
        SheetTest.assertEquals((int)4, (int)sheet.getCellAt("B22").getRowsSpanned());
    }

    private void testShapeSpan(Sheet sheet, String string, String string2, String string3) {
        Element element = SimpleXMLPath.allElements(string, "draw").selectSingleNode(sheet.getImmutableCellAt(string2).getElement());
        Tuple2<Sheet, Point> tuple2 = sheet.getSpreadSheet().resolve(element.getAttributeValue("end-cell-address", sheet.getTABLE()));
        SheetTest.assertSame((Object)sheet, (Object)tuple2.get0());
        SheetTest.assertEquals((Object)Table.resolve(string3), (Object)tuple2.get1());
    }

    public void testXY() throws Exception {
        MutableCell mutableCell = this.realSheet.getCellAt(2, 35);
        SheetTest.assertEquals((Object)"LECTURE SEULE", (Object)mutableCell.getValue());
        SheetTest.assertEquals((int)2, (int)mutableCell.getX());
        SheetTest.assertEquals((int)35, (int)mutableCell.getY());
        this.realSheet.duplicateRows(8, 3, 2);
        mutableCell = this.realSheet.getCellAt(2, 41);
        SheetTest.assertEquals((Object)"LECTURE SEULE", (Object)mutableCell.getValue());
        SheetTest.assertEquals((int)2, (int)mutableCell.getX());
        SheetTest.assertEquals((int)41, (int)mutableCell.getY());
    }

    public void testUsedRange() throws Exception {
        Sheet sheet = this.sheet.getSpreadSheet().addSheet("empty");
        SheetTest.assertNull((Object)sheet.getUsedRange());
        SheetTest.assertEquals((Object)new Range(this.realSheet.getName(), Table.resolve("B3"), Table.resolve("J38")), (Object)this.realSheet.getUsedRange());
        SheetTest.assertEquals((Object)new Range(this.realSheet.getName(), Table.resolve("B3"), Table.resolve("Z38")), (Object)this.realSheet.getUsedRange(true));
        SheetTest.assertEquals((Object)new Range("empty", Table.resolve("A1")), (Object)sheet.getCurrentRegion("A1"));
        SheetTest.assertEquals((Object)new Range(this.realSheet.getName(), Table.resolve("A1")), (Object)this.realSheet.getCurrentRegion("A1"));
        SheetTest.assertEquals((Object)new Range(this.realSheet.getName(), Table.resolve("D3"), Table.resolve("F4")), (Object)this.realSheet.getCurrentRegion("D4"));
        SheetTest.assertEquals((Object)new Range(this.realSheet.getName(), Table.resolve("B9"), Table.resolve("I27")), (Object)this.realSheet.getCurrentRegion("C11"));
        SheetTest.assertEquals((Object)new Range(this.realSheet.getName(), Table.resolve("E18")), (Object)this.realSheet.getCurrentRegion("E18"));
        SheetTest.assertEquals((Object)new Range(this.realSheet.getName(), Table.resolve("B9"), Table.resolve("Z32")), (Object)this.realSheet.getCurrentRegion("C11", true));
        SheetTest.assertEquals((Object)this.realSheet.getCurrentRegion("C11", true), (Object)this.realSheet.getCurrentRegion("E18", true));
    }

    public void testGroups() throws Exception {
        Sheet sheet = this.realSheet.getSpreadSheet().getSheet("Groups");
        SheetTest.assertEquals((int)0, (int)sheet.getColumnGroup().getChildren().size());
        TableGroup tableGroup = sheet.getRowGroup();
        SheetTest.assertNull((Object)tableGroup.getParent());
        SheetTest.assertSame((Object)sheet, tableGroup.getTable());
        SheetTest.assertEquals((int)sheet.getRowCount(), (int)tableGroup.getSize());
        SheetTest.assertEquals((int)1, (int)tableGroup.getChildren().size());
        TableGroup tableGroup2 = tableGroup.getChildren().get(0);
        SheetTest.assertEquals((int)1, (int)tableGroup2.getFirst());
        SheetTest.assertEquals((int)13, (int)tableGroup2.getSize());
        SheetTest.assertEquals((int)2, (int)sheet.getHeaderRowCount());
        SheetTest.assertEquals((int)1, (int)tableGroup.getHeaderCount());
        SheetTest.assertEquals((int)1, (int)tableGroup2.getHeaderCount());
        SheetTest.assertEquals((int)2, (int)tableGroup2.getChildren().size());
        TableGroup tableGroup3 = tableGroup2.getChildren().get(0);
        SheetTest.assertSame((Object)tableGroup2, (Object)tableGroup3.getParent());
        SheetTest.assertEquals((int)0, (int)tableGroup3.getChildren().size());
        SheetTest.assertEquals((int)2, (int)tableGroup3.getFirst());
        SheetTest.assertEquals((int)2, (int)tableGroup3.getSize());
        SheetTest.assertEquals((Object)"A3", (Object)sheet.getValueAt(0, tableGroup3.getFirst()));
        TableGroup tableGroup4 = tableGroup2.getChildren().get(1);
        SheetTest.assertSame((Object)tableGroup2, (Object)tableGroup4.getParent());
        SheetTest.assertEquals((int)0, (int)tableGroup4.getChildren().size());
        SheetTest.assertEquals((int)6, (int)tableGroup4.getFirst());
        SheetTest.assertEquals((int)4, (int)tableGroup4.getSize());
        SheetTest.assertEquals((Object)"group1,2", (Object)sheet.getValueAt(0, tableGroup4.getFirst()));
        SheetTest.assertSame((Object)sheet.getRowGroup(), (Object)sheet.getRowGroupAt(0));
        SheetTest.assertSame((Object)tableGroup2, (Object)sheet.getRowGroupAt(1));
        SheetTest.assertSame((Object)tableGroup3, (Object)sheet.getRowGroupAt(2));
        SheetTest.assertSame((Object)tableGroup3, (Object)sheet.getRowGroupAt(3));
        SheetTest.assertSame((Object)tableGroup2, (Object)sheet.getRowGroupAt(4));
        SheetTest.assertSame((Object)tableGroup2, (Object)sheet.getRowGroupAt(5));
        SheetTest.assertSame((Object)tableGroup4, (Object)sheet.getRowGroupAt(6));
        Sheet sheet2 = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("./rowscolumns-gnumeric.ods")).getSpreadSheet().getSheet(0);
        SheetTest.assertEquals((int)128, (int)sheet2.getRowCount());
        SheetTest.assertEquals((int)128, (int)sheet2.getColumnCount());
        Integer[][] integerArrayArray = new Integer[][]{{1, 2, 3}, {10, 20, 30}, {15, 5, 30}};
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                SheetTest.assertEquals((Object)BigDecimal.valueOf(integerArrayArray[i][j].intValue()), (Object)sheet2.getValueAt(i, j));
            }
        }
    }

    public void testRepeated() throws Exception {
        Row row = this.realSheet.getRow(26);
        SheetTest.assertEquals((int)1, (int)row.getRepeated());
        SheetTest.assertEquals((int)26, (int)row.getY());
        SheetTest.assertEquals((int)26, (int)row.getLastY());
        Row row2 = this.realSheet.getRow(27);
        SheetTest.assertEquals((int)5, (int)row2.getRepeated());
        SheetTest.assertEquals((int)27, (int)row2.getY());
        SheetTest.assertEquals((int)31, (int)row2.getLastY());
        SheetTest.assertSame(row2, this.realSheet.getRow(29));
        SheetTest.assertSame(row2, this.realSheet.getRow(31));
        SheetTest.assertNotSame(row2, this.realSheet.getRow(26));
        SheetTest.assertNotSame(row2, this.realSheet.getRow(32));
        SheetTest.assertEquals((Object)"", (Object)this.realSheet.getValueAt(0, 27));
        SheetTest.assertSame(row2, this.realSheet.getRow(27));
        SheetTest.assertEquals((int)5, (int)row2.getRepeated());
        this.realSheet.setValueAt("Break repeated", 0, 27);
        SheetTest.assertEquals((Object)"Break repeated", (Object)this.realSheet.getValueAt(0, 27));
        SheetTest.assertEquals((Object)"", (Object)this.realSheet.getValueAt(0, 28));
        SheetTest.assertNotSame(row2, this.realSheet.getRow(27));
        SheetTest.assertEquals((int)1, (int)this.realSheet.getRow(27).getRepeated());
        SheetTest.assertEquals((int)4, (int)this.realSheet.getRow(28).getRepeated());
    }

    public void testStyle() throws Exception {
        SheetTest.assertNull((Object)this.realSheet.getImmutableCellAt(2, 10).getStyleAttr());
        String string = this.realSheet.getStyleNameAt(2, 10);
        SheetTest.assertNotNull((Object)string);
        SheetTest.assertEquals((Object)Color.CYAN, (Object)((CellStyle)this.realSheet.getCellAt(2, 10).getStyle()).getBackgroundColor());
        SheetTest.assertEquals((String)string, (String)this.realSheet.getCellAt(2, 10).getStyleName());
        ODNode oDNode = Style.getStyle(this.realSheet.getSpreadSheet().getPackage(), CellStyle.class, "Heading");
        Object object = Style.getStyle(this.realSheet.getSpreadSheet().getPackage(), CellStyle.class, "Heading1");
        ODNode oDNode2 = this.realSheet.getCellAt("J3");
        Object object2 = (CellStyle)((StyledNode)oDNode2).getStyle();
        SheetTest.assertFalse((((StyleStyle)object2).equals(oDNode) || ((StyleStyle)object2).equals(object) ? 1 : 0) != 0);
        ((MutableCell)oDNode2).setValue(5);
        SheetTest.assertEquals(((StyledNode)oDNode2).getStyle(), (Object)this.realSheet.getStyleAt(((MutableCell)oDNode2).getX(), ((MutableCell)oDNode2).getY()));
        SheetTest.assertEquals((Object)oDNode, ((StyledNode)oDNode2).getStyle());
        String string2 = this.realSheet.getStyleNameAt(((MutableCell)oDNode2).getX(), ((MutableCell)oDNode2).getY());
        SheetTest.assertEquals((Object)object2, (Object)Style.getStyle(this.realSheet.getSpreadSheet().getPackage(), CellStyle.class, string2));
        ((MutableCell)oDNode2).setValue(6);
        SheetTest.assertEquals((Object)object2, ((StyledNode)oDNode2).getStyle());
        ((MutableCell)oDNode2).setValue(15);
        SheetTest.assertEquals((Object)object, ((StyledNode)oDNode2).getStyle());
        ((MutableCell)oDNode2).setValue(16);
        SheetTest.assertEquals((Object)object, ((StyledNode)oDNode2).getStyle());
        ODNode oDNode3 = this.realSheet.getCellAt("J4");
        object2 = (CellStyle)((StyledNode)oDNode3).getStyle();
        SheetTest.assertFalse((((StyleStyle)object2).equals(oDNode) || ((StyleStyle)object2).equals(object) ? 1 : 0) != 0);
        for (int i = 98; i <= 103; ++i) {
            ((MutableCell)oDNode3).setValue(String.valueOf((char)i));
            SheetTest.assertEquals((Object)(i >= 99 && i <= 102 ? object : object2), ((StyledNode)oDNode3).getStyle());
        }
        MutableCell mutableCell = this.realSheet.getCellAt("J5");
        object2 = (CellStyle)mutableCell.getStyle();
        SheetTest.assertFalse((((StyleStyle)object2).equals(oDNode) || ((StyleStyle)object2).equals(object) ? 1 : 0) != 0);
        for (int i = 0; i <= 4; ++i) {
            mutableCell.setValue(i);
            SheetTest.assertEquals((Object)(i < 1 || i > 3 ? object : object2), mutableCell.getStyle());
        }
        oDNode = this.realSheet.getCellAt(0, 0);
        SheetTest.assertNull((Object)((Cell)oDNode).getStyleAttr());
        SheetTest.assertFalse((boolean)((CellStyle)((StyledNode)oDNode).getStyle()).getReferences().contains(oDNode.getElement()));
        SheetTest.assertTrue((boolean)this.realSheet.getStyleReferences(this.realSheet.getStyleNameAt(0, 0)).contains(Tuple2.create(0, 0)));
        object = (CellStyle)this.realSheet.getCellAt("B9").getStyle();
        SheetTest.assertTrue((boolean)((Style)object).getReferences().contains(this.realSheet.getCellAt("B9").getElement()));
        SheetTest.assertEquals((String)"center", (String)((CellStyle)object).getParagraphProperties().getAlignment());
        SheetTest.assertEquals((String)"bold", (String)((CellStyle)object).getTextProperties().getWeight());
        SheetTest.assertEquals((String)"0.002cm solid #000000", (String)((CellStyle)object).getTableCellProperties().getBorder(SideStyleProperties.Side.LEFT));
        SheetTest.assertEquals(null, (Object)((CellStyle)object).getTableCellProperties().getBorderLineWidth(SideStyleProperties.Side.LEFT));
        SheetTest.assertEquals((int)0, (int)((CellStyle)object).getTableCellProperties().getRotationAngle());
        SheetTest.assertEquals((boolean)true, (boolean)((CellStyle)object).getTableCellProperties().isContentPrinted());
        SheetTest.assertEquals((boolean)false, (boolean)((CellStyle)object).getTableCellProperties().isContentRepeated());
        SheetTest.assertEquals((boolean)false, (boolean)((CellStyle)object).getTableCellProperties().isShrinkToFit());
        object = (CellStyle)this.realSheet.getCellAt("B6").getStyle();
        SheetTest.assertTrue((boolean)((Style)object).getReferences().contains(this.realSheet.getCellAt("B6").getElement()));
        SheetTest.assertEquals((String)"start", (String)((CellStyle)object).getParagraphProperties().getAlignment());
        SheetTest.assertEquals(null, (String)((CellStyle)object).getTextProperties().getWeight());
        SheetTest.assertEquals((String)"0.105cm double #000080", (String)((CellStyle)object).getTableCellProperties().getBorder(SideStyleProperties.Side.RIGHT));
        SheetTest.assertEquals((String)"none", (String)((CellStyle)object).getTableCellProperties().getBorder(SideStyleProperties.Side.TOP));
        SheetTest.assertEquals(Arrays.asList("0.035cm", "0.035cm", "0.035cm"), Arrays.asList(((CellStyle)object).getTableCellProperties().getBorderLineWidth(SideStyleProperties.Side.RIGHT)));
        SheetTest.assertEquals((int)333, (int)((CellStyle)object).getTableCellProperties().getRotationAngle());
        SheetTest.assertEquals((boolean)false, (boolean)((CellStyle)object).getTableCellProperties().isContentPrinted());
        SheetTest.assertEquals((boolean)false, (boolean)((CellStyle)object).getTableCellProperties().isContentRepeated());
        SheetTest.assertEquals((boolean)true, (boolean)((CellStyle)object).getTableCellProperties().isShrinkToFit());
        SheetTest.assertNull((Object)((CellStyle)CellStyle.DESC.createAutoStyle(this.sheet.getSpreadSheet().getPackage())).getBackgroundColor());
        SheetTest.assertEquals((Object)Float.valueOf(54.38f), (Object)this.realSheet.getColumn(1).getWidth());
        object = new ODPackage(((Object)((Object)this)).getClass().getResourceAsStream("test.sxc")).getSpreadSheet();
        SheetTest.assertEquals((Object)Float.valueOf(33.85f), (Object)((SpreadSheet)object).getSheet(0).getColumn(1).getWidth());
        oDNode2 = this.realSheet.getColumn(9);
        object2 = this.realSheet.getColumn(10);
        SheetTest.assertEquals((String)((ColumnStyle)((StyledNode)oDNode2).getStyle()).getName(), (String)((ColumnStyle)((StyledNode)object2).getStyle()).getName());
        this.checkStyleElements((Column<SpreadSheet>)oDNode2, (Column<SpreadSheet>)object2, true);
        SheetTest.assertNotNull((Object)((ColumnStyle)((StyledNode)oDNode2).getStyle()).getTableColumnProperties().getBreakBefore());
        float f = ((Column)object2).getWidth().floatValue();
        ((Column)oDNode2).setWidth(Float.valueOf(f + 15.0f));
        SheetTest.assertEquals((Object)Float.valueOf(f + 15.0f), (Object)((Column)oDNode2).getWidth());
        SheetTest.assertEquals((Object)Float.valueOf(f), (Object)((Column)object2).getWidth());
        SheetTest.assertEquals((String)((ColumnStyle)((StyledNode)object2).getStyle()).getTableColumnProperties().getBreakBefore(), (String)((ColumnStyle)((StyledNode)oDNode2).getStyle()).getTableColumnProperties().getBreakBefore());
        String string3 = ((ColumnStyle)((StyledNode)oDNode2).getStyle()).getName();
        SheetTest.assertFalse((boolean)string3.equals(((ColumnStyle)((StyledNode)object2).getStyle()).getName()));
        this.checkStyleElements((Column<SpreadSheet>)oDNode2, (Column<SpreadSheet>)object2, false);
        ((Column)oDNode2).setWidth(Float.valueOf(f + 17.0f));
        SheetTest.assertEquals((String)string3, (String)((ColumnStyle)((StyledNode)oDNode2).getStyle()).getName());
        Sheet sheet = this.realSheet.getSpreadSheet().addSheet("testEmptyStyle");
        SheetTest.assertNull(sheet.getColumn(0).getStyle());
        sheet.getColumn(0).setWidth(20);
        oDNode3 = (ColumnStyle)sheet.getColumn(0).getStyle();
        SheetTest.assertNotNull(oDNode3);
        SheetTest.assertEquals((String)((Style)oDNode3).getName(), (String)((ColumnStyle)sheet.getColumn(0).getPrivateStyle()).getName());
        SheetTest.assertEquals((Object)Float.valueOf(20.0f), (Object)sheet.getColumn(0).getWidth());
        SheetTest.assertEquals((String)"Default", (String)this.sheet.getStyleNameAt(0, 0));
        SheetTest.assertEquals((String)"Default", (String)this.sheet.getStyleNameAt(0, 1));
        oDNode2 = (CellStyle)CellStyle.DESC.createAutoStyle(this.sheet.getSpreadSheet().getPackage(), "defaultCell");
        object2 = this.sheet.getColumn(0).getElement();
        ((Element)object2).setAttribute("default-cell-style-name", ((Style)oDNode2).getName(), ((Element)object2).getNamespace());
        SheetTest.assertEquals((String)((Style)oDNode2).getName(), (String)this.sheet.getStyleNameAt(0, 0));
        SheetTest.assertEquals((String)((Style)oDNode2).getName(), (String)this.sheet.getStyleNameAt(0, 1));
        SheetTest.assertEquals(Collections.singletonList(object2), ((Style)oDNode2).getReferences());
        SheetTest.assertNull((Object)((CellStyle)oDNode2).getBackgroundColor());
        this.sheet.getCellAt(0, 0).setBackgroundColor(Color.CYAN);
        CellStyle cellStyle = this.sheet.getStyleAt(0, 0);
        SheetTest.assertFalse((boolean)((Style)oDNode2).getName().equals(cellStyle.getName()));
        SheetTest.assertEquals((String)((Style)oDNode2).getName(), (String)this.sheet.getStyleNameAt(0, 1));
        SheetTest.assertEquals((Object)Color.CYAN, (Object)cellStyle.getTableCellProperties().getBackgroundColor());
        SheetTest.assertNull((Object)this.sheet.getStyleAt(0, 1).getBackgroundColor());
        this.sheet.getCellAt(0, 0).setBackgroundColor(Color.YELLOW);
        SheetTest.assertEquals((String)cellStyle.getName(), (String)this.sheet.getStyleNameAt(0, 0));
        oDNode2 = Style.getStyleStyleDesc(CellStyle.class, ((SpreadSheet)this.realSheet.getODDocument()).getVersion()).findDefaultStyle(((SpreadSheet)this.realSheet.getODDocument()).getPackage());
        SheetTest.assertEquals((String)"Arial", (String)((CellStyle)oDNode2).getTextProperties().getFontName());
        object2 = (CellStyle)this.realSheet.getCellAt(0, 0).getStyle();
        SheetTest.assertNull((Object)((CellStyle)object2).getTextProperties().getElement().getAttribute("font-name", ((ODNode)object2).getElement().getNamespace("style")));
        SheetTest.assertEquals((String)"Arial", (String)((CellStyle)object2).getTextProperties().getFontName());
        this.assertValid(this.sheet.getSpreadSheet());
        this.assertValid(this.realSheet.getSpreadSheet());
    }

    private void checkStyleElements(Column<SpreadSheet> column, Column<SpreadSheet> column2, boolean bl) {
        Attribute attribute = column.getElement().getAttribute("style-name", column.getElement().getNamespace());
        SheetTest.assertSame((Object)((ColumnStyle)column.getStyle()).getElement(), (Object)Style.getReferencedStyleElement(this.realSheet.getSpreadSheet().getPackage(), attribute));
        Attribute attribute2 = column2.getElement().getAttribute("style-name", column2.getElement().getNamespace());
        SheetTest.assertSame((Object)((ColumnStyle)column2.getStyle()).getElement(), (Object)Style.getReferencedStyleElement(this.realSheet.getSpreadSheet().getPackage(), attribute2));
        if (bl) {
            SheetTest.assertSame((Object)((ColumnStyle)column.getStyle()).getElement(), (Object)((ColumnStyle)column2.getStyle()).getElement());
        } else {
            SheetTest.assertNotSame((Object)((ColumnStyle)column.getStyle()).getElement(), (Object)((ColumnStyle)column2.getStyle()).getElement());
        }
    }

    private void assertValid(SpreadSheet spreadSheet) {
        SheetTest.assertValid(spreadSheet.getPackage());
    }

    public static void assertValid(ODPackage oDPackage) {
        SheetTest.assertValid(oDPackage, true);
    }

    public static void assertValid(ODPackage oDPackage, boolean bl) {
        Map<String, String> map = oDPackage.validateSubDocuments();
        SheetTest.assertEquals((String)(map + ""), (boolean)bl, (boolean)map.isEmpty());
        String string = oDPackage.checkStyles();
        SheetTest.assertNull((String)string, (Object)string);
    }

    private void assertValid(Validator validator) {
        this.assertValid(validator, true);
    }

    private void assertValid(Validator validator, boolean bl) {
        String string = validator.isValid();
        if (bl) {
            SheetTest.assertNull((String)string, (Object)string);
        } else {
            SheetTest.assertNotNull((String)string, (Object)string);
        }
    }

    static {
        tm.addColumn("col1");
        tm.addColumn("col2");
        tm.addColumn("col3");
        tm.addRow(new Object[]{"un1", new BigDecimal("-5.320"), new Integer(123)});
    }
}

