/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.StyleProperties;
import org.jopendocument.dom.StyleStyleDesc;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.Axis;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.spreadsheet.RepeatedBreaker;
import org.jopendocument.dom.spreadsheet.RowStyle;
import org.jopendocument.dom.spreadsheet.Table;
import org.jopendocument.dom.spreadsheet.TableCalcNode;

public class Row<D extends ODDocument>
extends TableCalcNode<RowStyle, D> {
    private final Table<D> parent;
    private final int index;
    private int repeated;
    private Cell<D>[] cells;
    private int cellCount;

    static Element createEmpty(XMLVersion xMLVersion) {
        return new Element("table-row", xMLVersion.getTABLE());
    }

    Row(Table<D> table, Element element, int n, StyleDesc<RowStyle> styleDesc, StyleDesc<CellStyle> styleDesc2) {
        super(table.getODDocument(), element, styleDesc);
        this.parent = table;
        this.index = n;
        this.repeated = Axis.ROW.getRepeated(this.getElement());
        Cell[] cellArray = new Cell[table.getColumnCount()];
        this.cells = cellArray;
        this.cellCount = 0;
        for (Element element2 : this.getCellElements()) {
            this.addCellElem(element2, styleDesc2);
        }
    }

    private final void ensureRoom(int n) {
        int n2 = this.getCellCount() + n;
        if (n2 > this.cells.length) {
            this.cells = Arrays.copyOf(this.cells, n2);
        }
    }

    protected final Table<D> getSheet() {
        return this.parent;
    }

    final int getY() {
        return this.index;
    }

    final int getLastY() {
        return this.getY() + this.getRepeated() - 1;
    }

    final int getRepeated() {
        return this.repeated;
    }

    final void setRepeated(int n) {
        Axis.ROW.setRepeated(this.getElement(), n);
        this.repeated = n;
    }

    final int getX(MutableCell<D> mutableCell) {
        int n = this.getCellCount();
        for (int i = 0; i < n; ++i) {
            Cell<D> cell = this.cells[i];
            if (!mutableCell.equals(cell)) continue;
            return i;
        }
        return -1;
    }

    private void addCellElem(Element element, StyleDesc<CellStyle> styleDesc) {
        Cell cell = new Cell(this, element, styleDesc);
        String string = element.getAttributeValue("number-columns-repeated", this.getTABLE());
        int n = StyleProperties.parseInt(string, 1);
        int n2 = this.cellCount + n;
        for (int i = this.cellCount; i < n2; ++i) {
            this.cells[i] = cell;
        }
        this.cellCount = n2;
    }

    private List<Element> getCellElements() {
        return this.getElement().getChildren();
    }

    protected final int getCellCount() {
        return this.cellCount;
    }

    private final List<Cell<D>> getCellsAsList() {
        return Arrays.asList(this.cells);
    }

    protected final Cell<D> getCellAt(int n) {
        return this.cells[n];
    }

    protected final Cell<D> getValidCellAt(int n) {
        Cell<D> cell = this.getCellAt(n);
        if (!cell.isValid()) {
            throw new IllegalArgumentException("invalid cell " + cell);
        }
        return cell;
    }

    public final MutableCell<D> getMutableCellAt(int n) {
        Cell<D> cell = this.getValidCellAt(n);
        if (!(cell instanceof MutableCell)) {
            RepeatedBreaker.getCellBreaker().breakRepeated(this, this.getCellsAsList(), n);
        }
        return (MutableCell)this.getValidCellAt(n);
    }

    void columnCountChanged(StyleStyleDesc<CellStyle> styleStyleDesc) {
        int n = this.getSheet().getColumnCount() - this.getCellCount();
        if (n < 0) {
            throw new IllegalStateException("should have used Table.removeColumn()");
        }
        if (n > 0) {
            Element element = Cell.createEmpty(((ODDocument)this.getSheet().getODDocument()).getVersion(), n);
            this.getElement().addContent(element);
            this.ensureRoom(n);
            this.addCellElem(element, styleStyleDesc);
        }
        assert (this.getCellCount() == this.getSheet().getColumnCount());
    }

    void checkRemove(int n, int n2) {
        if (n2 > this.getCellCount()) {
            throw new IndexOutOfBoundsException(n2 + " > " + this.getCellCount());
        }
        if (!this.getCellAt(n).isValid()) {
            throw new IllegalArgumentException("unable to remove covered cell at " + n);
        }
    }

    void removeCells(int n, int n2) {
        int n3;
        this.getMutableCellAt(n).unmerge();
        if (n2 < this.getCellCount()) {
            if (!this.getCellAt(n2 - 1).isValid()) {
                n3 = n2 - 2;
                while (!this.getCellAt(n3).isValid()) {
                    --n3;
                }
                this.getMutableCellAt(n3).unmerge();
            }
            this.getMutableCellAt(n2 - 1).unmerge();
        }
        for (n3 = n; n3 < n2; ++n3) {
            this.cells[n3].getElement().detach();
        }
        n3 = this.getCellCount() - n2;
        System.arraycopy(this.cells, n2, this.cells, n, n3);
        this.cells = Arrays.copyOfRange(this.cells, 0, n + n3);
        this.cellCount = this.cells.length;
        assert (this.getCellCount() == this.getSheet().getColumnCount());
    }
}

