/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jopendocument.dom.Log;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODFrame;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.OOXML;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.spreadsheet.BytesProducer;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.dom.style.data.DataStyle;
import org.jopendocument.util.ExceptionUtils;
import org.jopendocument.util.FileUtils;
import org.jopendocument.util.Tuple3;

public class MutableCell<D extends ODDocument>
extends Cell<D> {
    private static final DateFormat TextPDateFormat = DateFormat.getDateInstance();
    private static final DateFormat TextPTimeFormat = DateFormat.getTimeInstance();
    private static final NumberFormat TextPMinuteSecondFormat = new DecimalFormat("00.###");
    private static final NumberFormat TextPFloatFormat = DecimalFormat.getNumberInstance();
    private static final NumberFormat TextPPercentFormat = DecimalFormat.getPercentInstance();
    private static final NumberFormat TextPCurrencyFormat = DecimalFormat.getCurrencyInstance();

    public static String formatNumber(Number number, CellStyle cellStyle) {
        return MutableCell.formatNumber(TextPFloatFormat, number, cellStyle, false);
    }

    public static String formatPercent(Number number, CellStyle cellStyle) {
        return MutableCell.formatNumber(TextPPercentFormat, number, cellStyle, true);
    }

    public static String formatCurrency(Number number, CellStyle cellStyle) {
        return MutableCell.formatNumber(TextPCurrencyFormat, number, cellStyle, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatNumber(NumberFormat numberFormat, Number number, CellStyle cellStyle, boolean bl) {
        NumberFormat numberFormat2 = numberFormat;
        synchronized (numberFormat2) {
            int n = DataStyle.getDecimalPlaces(cellStyle);
            numberFormat.setMinimumFractionDigits(bl ? n : 0);
            numberFormat.setMaximumFractionDigits(n);
            return numberFormat.format(number);
        }
    }

    MutableCell(Row<D> row, Element element, StyleDesc<CellStyle> styleDesc) {
        super(row, element, styleDesc);
    }

    public final int getX() {
        return this.getRow().getX(this);
    }

    public final int getY() {
        return this.getRow().getY();
    }

    public final Point getPoint() {
        return new Point(this.getX(), this.getY());
    }

    final void setRowsSpanned(int n) {
        if (n <= 1) {
            this.getElement().removeAttribute("number-rows-spanned", this.getNS().getTABLE());
        } else {
            this.getElement().setAttribute("number-rows-spanned", String.valueOf(n), this.getNS().getTABLE());
        }
    }

    private void setValueAttributes(ODValueType oDValueType, Object object) {
        if (oDValueType == null) {
            Attribute attribute = this.getElement().getAttribute("value-type", this.getValueNS());
            if (attribute != null) {
                attribute.detach();
                this.getElement().removeAttribute(ODValueType.get(attribute.getValue()).getValueAttribute(), this.getValueNS());
            }
        } else {
            this.getElement().setAttribute("value-type", oDValueType.getName(), this.getValueNS());
            this.getElement().setAttribute(oDValueType.getValueAttribute(), oDValueType.format(object), this.getValueNS());
        }
    }

    private void setTextP(String string) {
        if (string == null) {
            this.getElement().removeContent();
        } else {
            Element element = this.getElement().getChild("p", this.getNS().getTEXT());
            Element element2 = element != null ? element : new Element("p", this.getNS().getTEXT());
            element2.setContent(OOXML.get(((ODDocument)this.getODDocument()).getFormatVersion()).encodeWSasList(string));
            this.getElement().setContent(element2);
        }
    }

    private void setValue(ODValueType oDValueType, Object object, String string) {
        this.setValueAttributes(oDValueType, object);
        this.setTextP(string);
    }

    public void clearValue() {
        this.setValue(null, null, null);
    }

    public void setValue(Object object) {
        this.setValue(object, true);
    }

    public void setValue(Object object, boolean bl) throws UnsupportedOperationException {
        ODValueType oDValueType = this.getValueType();
        ODValueType oDValueType2 = oDValueType != null && oDValueType.canFormat(object.getClass()) ? oDValueType : ODValueType.forObject(object);
        if (oDValueType2 == null) {
            throw new IllegalArgumentException("Couldn't infer type of " + object);
        }
        this.setValue(object, oDValueType2, bl, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(Object object, ODValueType oDValueType, boolean bl, boolean bl2) throws UnsupportedOperationException {
        String string;
        Tuple3<String, ODValueType, Object> tuple3 = this.format(object, oDValueType, !bl, bl2);
        oDValueType = (ODValueType)((Object)tuple3.get1());
        object = tuple3.get2();
        if (tuple3.get0() != null) {
            string = (String)tuple3.get0();
        } else if (oDValueType == ODValueType.FLOAT) {
            string = MutableCell.formatNumber((Number)object, this.getDefaultStyle());
        } else if (oDValueType == ODValueType.PERCENTAGE) {
            string = MutableCell.formatPercent((Number)object, this.getDefaultStyle());
        } else if (oDValueType == ODValueType.CURRENCY) {
            string = MutableCell.formatCurrency((Number)object, this.getDefaultStyle());
        } else if (oDValueType == ODValueType.DATE) {
            Date date = object instanceof Calendar ? ((Calendar)object).getTime() : (Date)object;
            string = TextPDateFormat.format(date);
        } else if (oDValueType == ODValueType.TIME) {
            if (object instanceof Duration) {
                Duration duration = ((ODDocument)this.getODDocument()).getEpoch().normalizeToHours((Duration)object);
                string = "" + duration.getHours() + ':' + TextPMinuteSecondFormat.format(duration.getMinutes()) + ':' + TextPMinuteSecondFormat.format(duration.getField(DatatypeConstants.SECONDS));
            } else {
                string = TextPTimeFormat.format(((Calendar)object).getTime());
            }
        } else if (oDValueType == ODValueType.BOOLEAN) {
            if (!bl2) throw new UnsupportedOperationException((Object)((Object)oDValueType) + " not supported");
            string = object.toString();
        } else {
            if (oDValueType != ODValueType.STRING) throw new IllegalStateException((Object)((Object)oDValueType) + " unknown");
            string = object.toString();
        }
        this.setValue(oDValueType, object, string);
    }

    private Tuple3<String, ODValueType, Object> format(Object object, ODValueType oDValueType, boolean bl, boolean bl2) {
        String string = null;
        try {
            Tuple3<DataStyle, ODValueType, Object> tuple3 = this.getDataStyleAndValue(object, oDValueType, bl);
            if (tuple3 != null) {
                object = tuple3.get2();
                oDValueType = (ODValueType)((Object)tuple3.get1());
                if (((DataStyle)tuple3.get0()).canFormat(object.getClass())) {
                    string = ((DataStyle)tuple3.get0()).format(object, this.getDefaultStyle(), bl2);
                }
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            if (bl2) {
                Log.get().warning(ExceptionUtils.getStackTrace(unsupportedOperationException));
            }
            throw unsupportedOperationException;
        }
        return Tuple3.create(string, oDValueType, object);
    }

    public final DataStyle getDataStyle() {
        Tuple3<DataStyle, ODValueType, Object> tuple3 = this.getDataStyleAndValue(this.getValue(), this.getValueType(), true);
        return tuple3 != null ? (DataStyle)tuple3.get0() : null;
    }

    private final Tuple3<DataStyle, ODValueType, Object> getDataStyleAndValue(Object object, ODValueType oDValueType, boolean bl) {
        CellStyle cellStyle = (CellStyle)this.getStyle();
        return cellStyle != null ? ((CellStyle)this.getStyle()).getDataStyle(object, oDValueType, bl) : null;
    }

    protected final CellStyle getDefaultStyle() {
        return this.getRow().getSheet().getDefaultCellStyle();
    }

    public void replaceBy(String string, String string2) {
        this.replaceContentBy(this.getElement(), string, string2);
    }

    private void replaceContentBy(Element element, String string, String string2) {
        List list = element.getContent();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof Text) {
                Text text = (Text)e;
                text.setText(text.getText().replaceAll(string, string2));
                continue;
            }
            if (!(e instanceof Element)) continue;
            this.replaceContentBy((Element)e, string, string2);
        }
    }

    public final void unmerge() {
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getColumnsSpanned();
        int n4 = this.getRowsSpanned();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                this.getRow().getSheet().getImmutableCellAt(n + i, n2 + j).getElement().setName("table-cell");
            }
        }
        this.getElement().removeAttribute("number-columns-spanned", this.getNS().getTABLE());
        this.getElement().removeAttribute("number-rows-spanned", this.getNS().getTABLE());
    }

    public final void merge(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.getColumnsSpanned();
        int n8 = this.getRowsSpanned();
        if (n == n7 && n2 == n8) {
            return;
        }
        int n9 = this.getX();
        int n10 = this.getY();
        for (n6 = 0; n6 < n; ++n6) {
            for (n5 = 0; n5 < n2; ++n5) {
                int n11 = n4 = n6 < n7 && n5 < n8 ? 1 : 0;
                if (n4 != 0) continue;
                n3 = n9 + n6;
                int n12 = n10 + n5;
                Cell cell = this.getRow().getSheet().getImmutableCellAt(n3, n12);
                if (cell.coversOtherCells()) {
                    throw new IllegalArgumentException("Cell at " + n3 + "," + n12 + " is a merged cell.");
                }
                if (!cell.getElement().getName().equals("covered-table-cell")) continue;
                throw new IllegalArgumentException("Cell at " + n3 + "," + n12 + " is already covered.");
            }
        }
        int n13 = n6 = n < n7 || n2 < n8 ? 1 : 0;
        if (n6 != 0) {
            this.unmerge();
        }
        for (n5 = 0; n5 < n; ++n5) {
            for (n4 = 0; n4 < n2; ++n4) {
                int n14 = n3 = n5 < n7 && n4 < n8 ? 1 : 0;
                if (n5 == 0 && n4 == 0 || n6 == 0 && n3 != 0) continue;
                this.getRow().getSheet().getCellAt(n9 + n5, n10 + n4).getElement().setName("covered-table-cell");
            }
        }
        this.getElement().setAttribute("number-columns-spanned", n + "", this.getNS().getTABLE());
        this.getElement().setAttribute("number-rows-spanned", n2 + "", this.getNS().getTABLE());
    }

    @Override
    public final String getStyleName() {
        return this.getRow().getSheet().getStyleNameAt(this.getX(), this.getY());
    }

    public void setImage(File file) throws IOException {
        this.setImage(file, false);
    }

    public void setImage(File file, boolean bl) throws IOException {
        this.setImage(file.getName(), new BytesProducer.ByteArrayProducer(FileUtils.readBytes(file), bl));
    }

    public void setImage(String string, Image image) throws IOException {
        this.setImage(string, image == null ? null : new BytesProducer.ImageProducer(image, true));
    }

    private void setImage(String string, BytesProducer bytesProducer) {
        Element element;
        Namespace namespace = this.getNS().getNS("draw");
        Element element2 = this.getElement().getChild("frame", namespace);
        Element element3 = element = element2 == null ? null : element2.getChild("image", namespace);
        if (element != null) {
            Attribute attribute = element.getAttribute("href", this.getNS().getNS("xlink"));
            ((ODDocument)this.getODDocument()).getPackage().putFile(attribute.getValue(), null);
            if (bytesProducer == null) {
                element2.detach();
            } else {
                attribute.setValue("Pictures/" + string + (bytesProducer.getFormat() != null ? "." + bytesProducer.getFormat() : ""));
                ((ODDocument)this.getODDocument()).getPackage().putFile(attribute.getValue(), bytesProducer.getBytes(new ODFrame(this.getODDocument(), element2)));
            }
        } else if (bytesProducer != null) {
            throw new IllegalStateException("this cell doesn't contain an image: " + this);
        }
    }

    public final void setBackgroundColor(Color color) {
        ((CellStyle)this.getPrivateStyle()).getTableCellProperties().setBackgroundColor(color);
    }
}

