/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import org.jdom.Document;
import org.jdom.Element;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.XMLVersion;

public abstract class StyledNode<S extends Style, D extends ODDocument>
extends ODNode {
    private final StyleDesc<S> styleClass;

    protected static final <S extends Style> StyleDesc<S> getStyleDesc(Element element, Class<S> clazz) {
        return Style.getStyleDesc(clazz, XMLVersion.getVersion(element));
    }

    public StyledNode(Element element, Class<S> clazz) {
        this(element, StyledNode.getStyleDesc(element, clazz));
    }

    protected StyledNode(Element element, StyleDesc<S> styleDesc) {
        super(element);
        if (styleDesc == null) {
            throw new NullPointerException("null style desc");
        }
        this.styleClass = styleDesc;
        assert (styleDesc.getVersion().equals((Object)XMLVersion.getVersion(element)));
        assert (this.styleClass.getRefElements().contains(this.getElement().getQualifiedName())) : this.getElement().getQualifiedName() + " not in " + this.styleClass;
    }

    public abstract D getODDocument();

    public final S getStyle() {
        return this.getStyle(null);
    }

    protected final S getStyle(String string) {
        D d = this.getODDocument();
        return d == null ? null : (S)this.getStyle(((ODDocument)d).getPackage(), this.getElement().getDocument(), string == null ? this.getStyleName() : string);
    }

    protected final S getStyle(ODPackage oDPackage, Document document) {
        return this.getStyle(oDPackage, document, this.getStyleName());
    }

    protected final S getStyle(ODPackage oDPackage, Document document, String string) {
        return this.styleClass.findStyleForNode(oDPackage, document, this, string);
    }

    public final S getPrivateStyle() {
        S s = this.getStyle();
        if (s != null && ((Style)s).isReferencedAtMostOnce()) {
            return s;
        }
        Object object = s == null ? this.styleClass.createAutoStyle(((ODDocument)this.getODDocument()).getPackage()) : (Style)this.styleClass.getStyleClass().cast(((Style)s).dup());
        this.setStyleName(((Style)object).getName());
        assert (((Style)this.getStyle()).equals(object));
        return (S)object;
    }

    protected String getStyleName() {
        return this.getElement().getAttributeValue("style-name", this.getElement().getNamespace());
    }

    public final void setStyleName(String string) {
        this.getElement().setAttribute("style-name", string, this.getElement().getNamespace());
    }
}

