/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import org.jdom.Element;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.StyleStyleDesc;

public class StyleStyle
extends Style {
    private final String family = StyleStyleDesc.getFamily(this.getElement());

    public StyleStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element);
        if (!((StyleStyleDesc)this.getDesc()).getFamily().equals(this.getFamily())) {
            throw new IllegalArgumentException("expected " + ((StyleStyleDesc)this.getDesc()).getFamily() + " but got " + this.getFamily() + " for " + element);
        }
    }

    @Override
    protected void checkElemName() {
        if (!"default-style".equals(this.getElement().getName()) && !this.getDesc().getElementName().equals(this.getElement().getName())) {
            throw new IllegalArgumentException("expected a default style (default-style) or " + this.getDesc().getElementName() + " but got " + this.getElement());
        }
    }

    protected StyleStyleDesc<?> getDesc() {
        return (StyleStyleDesc)super.getDesc();
    }

    public final String getFamily() {
        return this.family;
    }

    @Override
    public final Element getFormattingProperties() {
        return this.getFormattingProperties(this.getFamily());
    }

    public final StyleStyle getDefaultStyle() {
        return ((StyleStyleDesc)this.getDesc()).findDefaultStyle(this.getPackage());
    }

    @Override
    public final boolean equals(Object object) {
        if (!(object instanceof StyleStyle) || !super.equals(object)) {
            return false;
        }
        StyleStyle styleStyle = (StyleStyle)object;
        return this.getFamily().equals(styleStyle.getFamily());
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.getFamily().hashCode();
    }
}

