/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.awt.Color;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.StyleStyle;

public abstract class StyleProperties {
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    public static final String TRANSPARENT_NAME = "transparent";
    private final Style parentStyle;
    private final String propPrefix;

    public static final boolean parseBoolean(String string, boolean bl) {
        return string == null ? bl : Boolean.parseBoolean(string);
    }

    public static final int parseInt(String string, int n) {
        return string == null ? n : Integer.parseInt(string);
    }

    public static final Integer parseInteger(String string) {
        return string == null ? null : Integer.valueOf(string);
    }

    public StyleProperties(Style style, String string) {
        this.parentStyle = style;
        this.propPrefix = string;
    }

    public final Style getParentStyle() {
        return this.parentStyle;
    }

    public final Element getElement() {
        return this.getElement(this.getParentStyle(), true);
    }

    protected final Element getElement(Style style, boolean bl) {
        return style.getFormattingProperties(this.propPrefix, bl);
    }

    private final String getAttributeValue(Style style, String string, Namespace namespace) {
        if (style == null) {
            return null;
        }
        Element element = this.getElement(style, false);
        if (element == null) {
            return null;
        }
        return element.getAttributeValue(string, namespace);
    }

    protected final String getAttributeValue(String string, Namespace namespace) {
        String string2 = this.getAttributeValue(this.getParentStyle(), string, namespace);
        if (string2 != null) {
            return string2;
        }
        if (this.getParentStyle() instanceof StyleStyle) {
            StyleStyle styleStyle = ((StyleStyle)this.getParentStyle()).getDefaultStyle();
            return this.getAttributeValue(styleStyle, string, namespace);
        }
        return null;
    }

    protected final Namespace getNS(String string) {
        return this.getParentStyle().getNS().getNS(string);
    }

    public final String getRawBackgroundColor() {
        return this.getAttributeValue("background-color", this.getNS("fo"));
    }

    public final Color getBackgroundColor() {
        String string = this.getRawBackgroundColor();
        if (string == null) {
            return null;
        }
        if (TRANSPARENT_NAME.equals(string)) {
            return TRANSPARENT;
        }
        return OOUtils.decodeRGB(string);
    }

    public final void setBackgroundColor(Color color) {
        this.setBackgroundColor(color.getAlpha() == TRANSPARENT.getAlpha() ? TRANSPARENT_NAME : OOUtils.encodeRGB(color));
    }

    public final void setBackgroundColor(String string) {
        this.getElement().setAttribute("background-color", string, this.getNS("fo"));
    }
}

