/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.ContentType;
import org.jopendocument.dom.ContentTypeVersioned;
import org.jopendocument.dom.ODMeta;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODPackageEntry;
import org.jopendocument.dom.ODUserDefinedMeta;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.XMLFormatVersion;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.util.CopyUtils;
import org.jopendocument.util.JDOMUtils;
import org.jopendocument.util.ProductInfo;
import org.jopendocument.util.SimpleXMLPath;
import org.jopendocument.util.Step;
import org.jopendocument.util.cc.IFactory;

public class ODSingleXMLDocument
extends ODXMLDocument
implements Cloneable {
    static final Set<String> DONT_PREFIX = new HashSet<String>();
    private static final String COUNT = "SingleXMLDocument_count";
    private int numero;
    private final Set<String> stylesNames;
    private final Set<String> listStylesNames;
    private ODPackage pkg;
    private final ODMeta meta;
    private Element pageBreak;
    private final ODXMLDocument.ElementTransformer prefixTransf = new ODXMLDocument.ElementTransformer(){

        @Override
        public Element transform(Element element) throws JDOMException {
            ODSingleXMLDocument.this.prefix(element, true);
            return element;
        }
    };
    private final ODXMLDocument.ElementTransformer prefixTransfNoRef = new ODXMLDocument.ElementTransformer(){

        @Override
        public Element transform(Element element) throws JDOMException {
            ODSingleXMLDocument.this.prefix(element, false);
            return element;
        }
    };

    public static ODSingleXMLDocument createFromDocument(Document document, Document document2) {
        return ODPackage.createFromDocuments(document, document2).toSingle();
    }

    static ODSingleXMLDocument create(ODPackage oDPackage) {
        Document document = oDPackage.getContent().getDocument();
        Document document2 = oDPackage.getDocument(ODPackage.RootElement.STYLES.getZipEntry());
        Document document3 = ODPackage.RootElement.createSingle(document);
        ODSingleXMLDocument.copyNS(document, document3);
        oDPackage.getContentType().setType(document3);
        Element element = document3.getRootElement();
        element.addContent(document.getRootElement().removeContent());
        ODSingleXMLDocument.prependToRoot(oDPackage.getDocument(ODPackage.RootElement.SETTINGS.getZipEntry()), element);
        ODSingleXMLDocument.prependToRoot(oDPackage.getDocument(ODPackage.RootElement.META.getZipEntry()), element);
        ODSingleXMLDocument oDSingleXMLDocument = new ODSingleXMLDocument(document3, oDPackage);
        if (oDSingleXMLDocument.getChild("body") == null) {
            throw new IllegalArgumentException("no body in " + oDSingleXMLDocument);
        }
        if (document2 != null) {
            try {
                oDSingleXMLDocument.mergeAllStyles(new ODXMLDocument(document2), true);
            }
            catch (JDOMException jDOMException) {
                throw new IllegalArgumentException("style is not valid", jDOMException);
            }
        }
        return oDSingleXMLDocument;
    }

    private static void prependToRoot(Document document, Element element) {
        if (document != null) {
            ODSingleXMLDocument.copyNS(document, element.getDocument());
            Element element2 = (Element)document.getRootElement().getChildren().get(0);
            element.addContent(0, (Element)element2.clone());
        }
    }

    private static void copyNS(Document document, Document document2) {
        JDOMUtils.addNamespaces(document2.getRootElement(), document.getRootElement().getAdditionalNamespaces());
    }

    public static ODSingleXMLDocument createFromFile(File file) throws JDOMException, IOException {
        return new ODPackage(file).toSingle();
    }

    public ODSingleXMLDocument(Document document) {
        this(document, new ODPackage());
    }

    private ODSingleXMLDocument(Document document, ODPackage oDPackage) {
        super(document);
        Object object;
        Object object22;
        this.pageBreak = null;
        this.pkg = oDPackage;
        for (Object object22 : ODPackage.RootElement.getPackageElements()) {
            this.pkg.rmFile(object22.getZipEntry());
        }
        this.pkg.putFile(ODPackage.RootElement.CONTENT.getZipEntry(), this, "text/xml");
        this.getChild("meta", true);
        Properties properties = ProductInfo.getInstance().getProps();
        object22 = properties == null ? this.getClass().getName() : properties.getProperty("NAME") + "/" + properties.getProperty("VERSION");
        this.meta = ODMeta.create(this);
        this.meta.setGenerator((String)object22);
        ODUserDefinedMeta oDUserDefinedMeta = this.meta.getUserMeta(COUNT);
        if (oDUserDefinedMeta != null) {
            object = oDUserDefinedMeta.getValue();
            this.numero = object instanceof Number ? ((Number)object).intValue() : new BigDecimal(object.toString()).intValue();
        } else {
            this.setNumero(0);
        }
        this.stylesNames = new HashSet<String>(64);
        this.listStylesNames = new HashSet<String>(16);
        object = this.getChild("styles");
        if (object != null) {
            Element element = this.getDocument().getRootElement();
            Document document2 = new Document(new Element(element.getName(), element.getNamespace()));
            document2.getRootElement().addContent(((Content)object).detach());
            try {
                this.mergeStyles(new ODXMLDocument(document2));
            }
            catch (JDOMException jDOMException) {
                throw new IllegalArgumentException("can't find common styles names.");
            }
            ((Content)object).detach();
            this.setChild((Element)object);
        }
    }

    ODSingleXMLDocument(ODSingleXMLDocument oDSingleXMLDocument, ODPackage oDPackage) {
        super(oDSingleXMLDocument);
        if (oDPackage == null) {
            throw new NullPointerException("Null package");
        }
        this.stylesNames = new HashSet<String>(oDSingleXMLDocument.stylesNames);
        this.listStylesNames = new HashSet<String>(oDSingleXMLDocument.listStylesNames);
        this.pkg = oDPackage;
        this.meta = ODMeta.create(this);
        this.setNumero(oDSingleXMLDocument.numero);
    }

    public ODSingleXMLDocument clone() {
        ODPackage oDPackage = new ODPackage(this.pkg);
        return (ODSingleXMLDocument)oDPackage.getContent();
    }

    private void setNumero(int n) {
        this.numero = n;
        this.meta.getUserMeta(COUNT, true).setValue(this.numero);
    }

    public final int getNumero() {
        return this.numero;
    }

    public ODPackage getPackage() {
        return this.pkg;
    }

    public synchronized void add(ODSingleXMLDocument oDSingleXMLDocument) {
        this.add(oDSingleXMLDocument, true);
    }

    public synchronized void add(ODSingleXMLDocument oDSingleXMLDocument, boolean bl) {
        if (oDSingleXMLDocument != null && bl) {
            this.getBody().addContent(this.getPageBreak());
        }
        this.add(null, 0, oDSingleXMLDocument);
    }

    public synchronized void replace(Element element, ODSingleXMLDocument oDSingleXMLDocument) {
        Element element2 = element.getParentElement();
        this.add(element2, element2.indexOf(element), oDSingleXMLDocument);
        element.detach();
    }

    public synchronized void add(Element element, int n, ODSingleXMLDocument oDSingleXMLDocument) {
        if (oDSingleXMLDocument == null) {
            return;
        }
        if (!this.getVersion().equals((Object)oDSingleXMLDocument.getVersion())) {
            throw new IllegalArgumentException("version mismatch");
        }
        this.setNumero(this.numero + 1);
        try {
            ODSingleXMLDocument.copyNS(oDSingleXMLDocument.getDocument(), this.getDocument());
            this.mergeEmbedded(oDSingleXMLDocument);
            this.mergeSettings(oDSingleXMLDocument);
            this.mergeAllStyles(oDSingleXMLDocument, false);
            this.mergeBody(element, n, oDSingleXMLDocument);
        }
        catch (JDOMException jDOMException) {
            throw new IllegalArgumentException("XML error", jDOMException);
        }
    }

    private void mergeAllStyles(ODXMLDocument oDXMLDocument, boolean bl) throws JDOMException {
        this.mergeFontDecls(oDXMLDocument);
        this.mergeStyles(oDXMLDocument);
        this.mergeAutoStyles(oDXMLDocument, !bl);
        this.mergeMasterStyles(oDXMLDocument, !bl);
    }

    private void mergeEmbedded(ODSingleXMLDocument oDSingleXMLDocument) {
        this.pkg.rmFile("Thumbnails/thumbnail.png");
        ODPackage oDPackage = CopyUtils.copy(oDSingleXMLDocument.pkg);
        for (String string : oDPackage.getEntries()) {
            ODPackageEntry oDPackageEntry = oDPackage.getEntry(string);
            if (ODPackage.isStandardFile(oDPackageEntry.getName())) continue;
            this.pkg.putFile(this.prefix(oDPackageEntry.getName()), oDPackageEntry.getData(), oDPackageEntry.getType());
        }
    }

    private void mergeSettings(ODSingleXMLDocument oDSingleXMLDocument) throws JDOMException {
        this.addIfNotPresent(oDSingleXMLDocument, "./office:settings", 0);
    }

    private void mergeFontDecls(ODXMLDocument oDXMLDocument) throws JDOMException {
        String[] stringArray = this.getFontDecls();
        this.mergeUnique(oDXMLDocument, stringArray[0], stringArray[1]);
    }

    private String[] getFontDecls() {
        return this.getXML().getFontDecls();
    }

    private void mergeStyles(ODXMLDocument oDXMLDocument) throws JDOMException {
        this.mergeUnique(oDXMLDocument, "styles", "style:default-style", "style:family", NOP_ElementTransformer);
        this.stylesNames.addAll(this.mergeUnique(oDXMLDocument, "styles", "style:style"));
        this.addStylesIfNotPresent(oDXMLDocument, "outline-style");
        this.listStylesNames.addAll(this.mergeUnique(oDXMLDocument, "styles", "text:list-style"));
        if (this.getVersion() == XMLVersion.OOo) {
            this.addStylesIfNotPresent(oDXMLDocument, "footnotes-configuration");
            this.addStylesIfNotPresent(oDXMLDocument, "endnotes-configuration");
        } else {
            this.mergeUnique(oDXMLDocument, "styles", "text:notes-configuration", "text:note-class", NOP_ElementTransformer);
        }
        this.addStylesIfNotPresent(oDXMLDocument, "bibliography-configuration");
        this.addStylesIfNotPresent(oDXMLDocument, "linenumbering-configuration");
    }

    private void mergeAutoStyles(ODXMLDocument oDXMLDocument, boolean bl) throws JDOMException {
        List<Element> list = this.prefixAndAddAutoStyles(oDXMLDocument);
        for (Element element : list) {
            this.prefix(element, bl);
        }
    }

    private void mergeMasterStyles(ODXMLDocument oDXMLDocument, boolean bl) throws JDOMException {
        this.mergeUnique(oDXMLDocument, "master-styles", "style:master-page", bl ? this.prefixTransf : this.prefixTransfNoRef);
    }

    private void mergeBody(Element element, int n, ODSingleXMLDocument oDSingleXMLDocument) throws JDOMException {
        final Namespace namespace = this.getVersion().getOFFICE();
        String string = this.getContentTypeVersioned().getBodyPath();
        this.add(new IFactory<Element>(){

            @Override
            public Element createChecked() {
                Element element = ODSingleXMLDocument.this.getBody().getChild("forms", namespace);
                if (element != null) {
                    return element;
                }
                Element element2 = new Element("forms", namespace);
                ODSingleXMLDocument.this.getBody().addContent(0, element2);
                return element2;
            }
        }, -1, (ODXMLDocument)oDSingleXMLDocument, string + "/" + namespace.getPrefix() + ":" + "forms", this.prefixTransf);
        this.add(element, n, (ODXMLDocument)oDSingleXMLDocument, string, new ODXMLDocument.ElementTransformer(){

            @Override
            public Element transform(Element element) throws JDOMException {
                if (element.getName().equals("sequence-decls") || element.getName().equals("forms") && element.getNamespace().equals(namespace)) {
                    return null;
                }
                if (element.getName().equals("user-field-decls")) {
                    ODSingleXMLDocument.this.detachDuplicate(element);
                }
                if (element.getName().equals("variable-decls")) {
                    ODSingleXMLDocument.this.detachDuplicate(element);
                }
                return ODSingleXMLDocument.this.prefixTransf.transform(element);
            }
        });
    }

    protected final void detachDuplicate(Element element) throws JDOMException {
        String string = element.getName().substring(0, element.getName().length() - 1);
        List list = this.getXPath("./text:" + string + "s/text:" + string + "/@text:name").selectNodes(this.getChild("body"));
        CollectionUtils.transform(list, new Transformer(){

            @Override
            public Object transform(Object object) {
                return ((Attribute)object).getValue();
            }
        });
        Iterator iterator = element.getChildren().iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            if (!list.contains(element2.getAttributeValue("name", this.getVersion().getTEXT()))) continue;
            iterator.remove();
        }
    }

    public final Element getBody() {
        return this.getContentTypeVersioned().getBody(this.getDocument());
    }

    private ContentTypeVersioned getContentTypeVersioned() {
        return ContentType.TEXT.getVersioned(this.getVersion());
    }

    void prefix(Element element, boolean bl) throws JDOMException {
        String string;
        for (Attribute attribute : this.getXPath(".//@text:style-name | .//@table:style-name | .//@draw:style-name | .//@style:data-style-name").selectNodes(element)) {
            if (this.listStylesNames.contains(attribute.getValue()) || this.stylesNames.contains(attribute.getValue())) continue;
            attribute.setValue(this.prefix(attribute.getValue()));
        }
        for (Attribute attribute : this.getXPath(".//@style:list-style-name").selectNodes(element)) {
            if (this.listStylesNames.contains(attribute.getValue())) continue;
            attribute.setValue(this.prefix(attribute.getValue()));
        }
        for (Attribute attribute : this.getXPath(".//@style:page-master-name | .//@style:page-layout-name | .//@text:name | .//@form:name | .//@form:property-name").selectNodes(element)) {
            string = attribute.getParent().getName();
            if (DONT_PREFIX.contains(string)) continue;
            attribute.setValue(this.prefix(attribute.getValue()));
        }
        if (bl) {
            for (Attribute attribute : this.getXPath(".//@xlink:href[../@xlink:show='embed']").selectNodes(element)) {
                string = this.prefixPath(attribute.getValue());
                if (string == null) continue;
                attribute.setValue(string);
            }
        }
    }

    private String prefixPath(String string) {
        boolean bl;
        URI uRI;
        if (this.getVersion().equals((Object)XMLVersion.OOo)) {
            boolean bl2 = string.startsWith("#");
            if (bl2) {
                return "#" + this.prefix(string.substring(1));
            }
            return null;
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRI = null;
        }
        boolean bl3 = bl = uRI == null || uRI.getScheme() == null && uRI.getAuthority() == null && uRI.getPath().charAt(0) != '/';
        if (bl) {
            if (string.startsWith("./")) {
                return "./" + this.prefix(string.substring("./".length()));
            }
            return this.prefix(string);
        }
        return null;
    }

    private String prefix(String string) {
        return "_" + this.numero + string;
    }

    private List<String> mergeUnique(ODXMLDocument oDXMLDocument, String string, String string2) throws JDOMException {
        return this.mergeUnique(oDXMLDocument, string, string2, NOP_ElementTransformer);
    }

    private List<String> mergeUnique(ODXMLDocument oDXMLDocument, String string, String string2, ODXMLDocument.ElementTransformer elementTransformer) throws JDOMException {
        return this.mergeUnique(oDXMLDocument, string, string2, "style:name", elementTransformer);
    }

    private List<String> mergeUnique(ODXMLDocument oDXMLDocument, String string, String string2, String string3, ODXMLDocument.ElementTransformer elementTransformer) throws JDOMException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Element element = this.getChild(string, true);
        XPath xPath = this.getXPath("./" + string2 + "/@" + string3);
        List list = xPath.selectNodes(element);
        CollectionUtils.transform(list, new Transformer(){

            @Override
            public Object transform(Object object) {
                return ((Attribute)object).getValue();
            }
        });
        for (Attribute attribute : xPath.selectNodes(oDXMLDocument.getChild(string))) {
            if (list.contains(attribute.getValue())) continue;
            element.addContent(elementTransformer.transform((Element)attribute.getParent().clone()));
            arrayList.add(attribute.getValue());
        }
        return arrayList;
    }

    private void addStylesIfNotPresent(ODXMLDocument oDXMLDocument, String string) throws JDOMException {
        this.addIfNotPresent(oDXMLDocument, "./office:styles/text:" + string);
    }

    private List<Element> prefixAndAddAutoStyles(ODXMLDocument oDXMLDocument) throws JDOMException {
        ArrayList<Element> arrayList = new ArrayList<Element>(128);
        List list = this.getXPath("./*/@style:name").selectNodes(oDXMLDocument.getChild("automatic-styles"));
        for (Attribute attribute : list) {
            Element element = (Element)attribute.getParent().clone();
            element.setAttribute("name", this.prefix(attribute.getValue()), this.getVersion().getSTYLE());
            this.getChild("automatic-styles").addContent(element);
            arrayList.add(element);
        }
        return arrayList;
    }

    public final boolean isDead() {
        return this.getPackage() == null;
    }

    final Map<ODPackage.RootElement, Document> split() {
        Parent parent;
        HashMap<ODPackage.RootElement, Document> hashMap = new HashMap<ODPackage.RootElement, Document>();
        XMLVersion xMLVersion = this.getVersion();
        Element element = this.getDocument().getRootElement();
        XMLFormatVersion xMLFormatVersion = this.getFormatVersion();
        Parent parent2 = element.getChild("meta", xMLVersion.getOFFICE());
        if (parent2 != null) {
            parent = this.createDocument(hashMap, ODPackage.RootElement.META, xMLFormatVersion);
            ((Document)parent).getRootElement().addContent(((Content)((Object)parent2)).detach());
        }
        if ((parent2 = element.getChild("settings", xMLVersion.getOFFICE())) != null) {
            parent = this.createDocument(hashMap, ODPackage.RootElement.SETTINGS, xMLFormatVersion);
            ((Document)parent).getRootElement().addContent(((Content)((Object)parent2)).detach());
        }
        parent2 = this.createDocument(hashMap, ODPackage.RootElement.STYLES, xMLFormatVersion);
        ((Document)parent2).getRootElement().addContent((Element)element.getChild(this.getFontDecls()[0], xMLVersion.getOFFICE()).clone());
        ((Document)parent2).getRootElement().addContent(element.getChild("styles", xMLVersion.getOFFICE()).detach());
        parent = element.getChild("automatic-styles", xMLVersion.getOFFICE());
        Element element2 = new Element(((Element)parent).getName(), ((Element)parent).getNamespace());
        Element element3 = element.getChild("master-styles", xMLVersion.getOFFICE());
        HashSet<Element> hashSet = new HashSet<Element>();
        SimpleXMLPath<Attribute> simpleXMLPath = SimpleXMLPath.create(Step.createElementStep(Step.Axis.descendantOrSelf, null), Step.createAttributeStep(null, null));
        for (Attribute cloneable : simpleXMLPath.selectNodes(element3)) {
            Element element4 = Style.getReferencedStyleElement(this.pkg, cloneable);
            if (element4 == null) continue;
            hashSet.add(element4);
        }
        for (Element element5 : hashSet) {
            assert (element5.getParentElement() == parent);
            element2.addContent(element5.detach());
        }
        ((Document)parent2).getRootElement().addContent(element2);
        ((Document)parent2).getRootElement().addContent(element3.detach());
        this.pkg = null;
        parent2 = this.createDocument(hashMap, ODPackage.RootElement.CONTENT, xMLFormatVersion);
        this.getContentTypeVersioned().setType((Document)parent2);
        ((Document)parent2).getRootElement().addContent(element.removeContent());
        return hashMap;
    }

    private Document createDocument(Map<ODPackage.RootElement, Document> map, ODPackage.RootElement rootElement, XMLFormatVersion xMLFormatVersion) {
        Document document = rootElement.createDocument(xMLFormatVersion);
        ODSingleXMLDocument.copyNS(this.getDocument(), document);
        map.put(rootElement, document);
        return document;
    }

    public File saveAs(File file) throws IOException {
        return this.pkg.saveAs(file);
    }

    private Element getPageBreak() {
        if (this.pageBreak == null) {
            try {
                XPath xPath = this.getXPath("./style:style[@style:name='PageBreak']");
                Element element = this.getChild("styles", true);
                if (xPath.selectSingleNode(element) == null) {
                    Element element2 = new Element("style", this.getVersion().getSTYLE());
                    element2.setAttribute("name", "PageBreak", this.getVersion().getSTYLE());
                    element2.setAttribute("family", "paragraph", this.getVersion().getSTYLE());
                    element2.setContent(this.getPProps().setAttribute("break-after", "page", this.getVersion().getNS("fo")));
                    element.addContent(element2);
                }
            }
            catch (JDOMException jDOMException) {
                throw new IllegalStateException("pb while searching for PageBreak", jDOMException);
            }
            this.pageBreak = new Element("p", this.getVersion().getTEXT()).setAttribute("style-name", "PageBreak", this.getVersion().getTEXT());
        }
        return (Element)this.pageBreak.clone();
    }

    private final Element getPProps() {
        return this.getXML().createFormattingProperties("paragraph");
    }

    static {
        DONT_PREFIX.add("user-field-decl");
        DONT_PREFIX.add("user-field-get");
        DONT_PREFIX.add("variable-get");
        DONT_PREFIX.add("variable-decl");
        DONT_PREFIX.add("variable-set");
    }
}

