/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import org.jdom.Attribute;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jopendocument.dom.ContentType;
import org.jopendocument.dom.ContentTypeVersioned;
import org.jopendocument.dom.Manifest;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODMeta;
import org.jopendocument.dom.ODPackageEntry;
import org.jopendocument.dom.ODSingleXMLDocument;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.OOXML;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.StyleStyleDesc;
import org.jopendocument.dom.XMLFormatVersion;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import org.jopendocument.dom.text.TextDocument;
import org.jopendocument.util.CollectionMap;
import org.jopendocument.util.CollectionUtils;
import org.jopendocument.util.CopyUtils;
import org.jopendocument.util.ExceptionUtils;
import org.jopendocument.util.FileUtils;
import org.jopendocument.util.JDOMUtils;
import org.jopendocument.util.StreamUtils;
import org.jopendocument.util.StringInputStream;
import org.jopendocument.util.Tuple3;
import org.jopendocument.util.Zip;
import org.jopendocument.util.ZippedFilesProcessor;
import org.jopendocument.util.cc.ITransformer;

public class ODPackage {
    private static final XMLOutputter OUTPUTTER = new XMLOutputter(Format.getRawFormat());
    static final String MIMETYPE_ENTRY = "mimetype";
    static final Charset MIMETYPE_ENC = Charset.forName("UTF-8");
    private static final Set<String> subdocNames = new HashSet<String>();
    private final Map<String, ODPackageEntry> files = new HashMap<String, ODPackageEntry>();
    private ContentTypeVersioned type = null;
    private XMLFormatVersion version = null;
    private File file = null;
    private ODDocument doc = null;

    public static final boolean isStandardFile(String string) {
        return string.equals(MIMETYPE_ENTRY) || subdocNames.contains(string) || string.startsWith("Thumbnails") || string.startsWith("META-INF") || string.startsWith("Configurations");
    }

    public static ODPackage createFromDocuments(Document document, Document document2) {
        return ODPackage.createFromDocuments(null, document, document2, null, null);
    }

    public static ODPackage createFromDocuments(ContentTypeVersioned contentTypeVersioned, Document document, Document document2, Document document3, Document document4) {
        ODPackage oDPackage = new ODPackage();
        if (contentTypeVersioned != null) {
            oDPackage.setContentType(contentTypeVersioned);
        }
        oDPackage.putFile(RootElement.CONTENT.getZipEntry(), document);
        oDPackage.putFile(RootElement.STYLES.getZipEntry(), document2);
        oDPackage.putFile(RootElement.META.getZipEntry(), document3);
        oDPackage.putFile(RootElement.SETTINGS.getZipEntry(), document4);
        return oDPackage;
    }

    private static XMLVersion getVersion(XMLFormatVersion xMLFormatVersion, ContentTypeVersioned contentTypeVersioned) {
        XMLVersion xMLVersion = contentTypeVersioned == null && xMLFormatVersion == null ? null : (contentTypeVersioned != null ? contentTypeVersioned.getVersion() : xMLFormatVersion.getXMLVersion());
        assert (xMLFormatVersion == null || contentTypeVersioned == null || xMLFormatVersion.getXMLVersion() == contentTypeVersioned.getVersion());
        return xMLVersion;
    }

    private static <T> void checkVersion(Class<T> clazz, String string, T t, T t2) {
        boolean bl;
        if (t != null && t2 != null && !(bl = t instanceof ContentTypeVersioned ? ((ContentTypeVersioned)((Object)t)).getNonTemplate().equals((Object)((ContentTypeVersioned)((Object)t2)).getNonTemplate()) : t.equals(t2))) {
            throw new IllegalArgumentException("Cannot change " + string + " from " + t2 + " to " + t);
        }
    }

    public ODPackage() {
    }

    public ODPackage(InputStream inputStream) throws IOException {
        this();
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        new ZippedFilesProcessor(){

            @Override
            protected void processEntry(ZipEntry zipEntry, InputStream inputStream) throws IOException {
                Object object;
                String string = zipEntry.getName();
                if (subdocNames.contains(string)) {
                    try {
                        object = OOUtils.getBuilder().build(inputStream);
                    }
                    catch (JDOMException jDOMException) {
                        throw new IllegalStateException("parse error", jDOMException);
                    }
                } else {
                    byteArrayOutputStream.reset();
                    StreamUtils.copy(inputStream, byteArrayOutputStream);
                    object = byteArrayOutputStream.toByteArray();
                }
                ODPackage.this.putFile(string, object, null, zipEntry.getMethod() == 8);
            }
        }.process(inputStream);
        ODPackageEntry oDPackageEntry = this.files.remove("META-INF/manifest.xml");
        if (oDPackageEntry != null) {
            byte[] byArray = (byte[])oDPackageEntry.getData();
            try {
                Map<String, String> map = Manifest.parse(new ByteArrayInputStream(byArray));
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    String string = entry.getKey();
                    ODPackageEntry oDPackageEntry2 = this.files.get(string);
                    if (oDPackageEntry2 == null) {
                        this.files.put(string, new ODPackageEntry(string, entry.getValue(), null));
                        continue;
                    }
                    oDPackageEntry2.setType(entry.getValue());
                }
            }
            catch (JDOMException jDOMException) {
                throw new IllegalArgumentException("bad manifest " + new String(byArray), jDOMException);
            }
        }
    }

    public ODPackage(File file) throws IOException {
        this(new BufferedInputStream(new FileInputStream(file), 524288));
        this.file = file;
    }

    public ODPackage(ODPackage oDPackage) {
        this();
        for (String string : oDPackage.getEntries()) {
            ODPackageEntry oDPackageEntry = oDPackage.getEntry(string);
            Object object = oDPackageEntry.getData();
            Object object2 = object instanceof byte[] ? object : (object instanceof ODSingleXMLDocument ? new ODSingleXMLDocument((ODSingleXMLDocument)object, this) : CopyUtils.copy(object));
            this.putFile(string, object2, oDPackageEntry.getType(), oDPackageEntry.isCompressed());
        }
        this.type = oDPackage.type;
        this.version = oDPackage.version;
        this.file = oDPackage.file;
        this.doc = null;
    }

    public final File getFile() {
        return this.file;
    }

    public final void setFile(File file) {
        this.file = this.addExt(file);
    }

    private final File addExt(File file) {
        String string = '.' + this.getContentType().getExtension();
        if (!file.getName().endsWith(string)) {
            file = new File(file.getParentFile(), file.getName() + string);
        }
        return file;
    }

    public final XMLVersion getVersion() {
        return ODPackage.getVersion(this.version, this.type);
    }

    public final XMLFormatVersion getFormatVersion() {
        return this.version;
    }

    public final ContentTypeVersioned getContentType() {
        return this.type;
    }

    public final void setContentType(ContentTypeVersioned contentTypeVersioned) {
        this.putFile(MIMETYPE_ENTRY, contentTypeVersioned.getMimeType().getBytes(MIMETYPE_ENC));
    }

    private void updateTypeAndVersion(String string, ODXMLDocument oDXMLDocument) {
        this.setTypeAndVersion(string.equals(RootElement.CONTENT.getZipEntry()) ? ContentTypeVersioned.fromContent(oDXMLDocument) : null, oDXMLDocument.getFormatVersion(), string);
    }

    private void updateTypeAndVersion(byte[] byArray) {
        this.setTypeAndVersion(ContentTypeVersioned.fromMime(byArray), null, MIMETYPE_ENTRY);
    }

    private final void setTypeAndVersion(ContentTypeVersioned contentTypeVersioned, XMLFormatVersion xMLFormatVersion, String string) {
        Tuple3<XMLVersion, ContentTypeVersioned, XMLFormatVersion> tuple3 = this.getRequired(string);
        if (tuple3 != null) {
            ODPackage.checkVersion(XMLVersion.class, "version", ODPackage.getVersion(xMLFormatVersion, contentTypeVersioned), tuple3.get0());
            ODPackage.checkVersion(ContentTypeVersioned.class, "type", contentTypeVersioned, tuple3.get1());
            ODPackage.checkVersion(XMLFormatVersion.class, "format version", xMLFormatVersion, tuple3.get2());
        }
        if (xMLFormatVersion != null && !xMLFormatVersion.equals(this.version)) {
            this.version = xMLFormatVersion;
        }
        if (contentTypeVersioned != null && !contentTypeVersioned.equals((Object)this.type) && (this.type == null || string.equals(MIMETYPE_ENTRY))) {
            this.type = contentTypeVersioned;
        }
    }

    private final Tuple3<XMLVersion, ContentTypeVersioned, XMLFormatVersion> getRequired(String string) {
        Object object2;
        if (this.files.size() == 0 || this.files.size() == 1 && this.files.containsKey(string)) {
            return null;
        }
        byte[] byArray = this.files.containsKey(MIMETYPE_ENTRY) && !MIMETYPE_ENTRY.equals(string) ? this.getBinaryFile(MIMETYPE_ENTRY) : null;
        XMLFormatVersion xMLFormatVersion = null;
        HashMap<String, ODXMLDocument> hashMap = new HashMap<String, ODXMLDocument>();
        for (Object object2 : subdocNames) {
            if (!this.files.containsKey(object2) || object2.equals(string)) continue;
            ODXMLDocument oDXMLDocument = this.getXMLFile((String)object2);
            hashMap.put((String)object2, oDXMLDocument);
            if (xMLFormatVersion == null) {
                xMLFormatVersion = oDXMLDocument.getFormatVersion();
                continue;
            }
            assert (xMLFormatVersion.equals(oDXMLDocument.getFormatVersion())) : "Incoherence";
        }
        ODXMLDocument oDXMLDocument = (ODXMLDocument)hashMap.get(RootElement.CONTENT.getZipEntry());
        object2 = byArray != null ? ContentTypeVersioned.fromMime(byArray) : (oDXMLDocument != null ? ContentTypeVersioned.fromContent(oDXMLDocument) : null);
        return Tuple3.create(ODPackage.getVersion(xMLFormatVersion, (ContentTypeVersioned)((Object)object2)), object2, xMLFormatVersion);
    }

    public final String getMimeType() {
        return this.getContentType().getMimeType();
    }

    public final boolean isTemplate() {
        return this.getContentType().isTemplate();
    }

    public final void setTemplate(boolean bl) {
        ContentTypeVersioned contentTypeVersioned;
        if (this.type == null) {
            throw new IllegalStateException("No type");
        }
        ContentTypeVersioned contentTypeVersioned2 = contentTypeVersioned = bl ? this.type.getTemplate() : this.type.getNonTemplate();
        if (contentTypeVersioned == null) {
            throw new IllegalStateException("Missing " + (bl ? "" : "non-") + "template for " + (Object)((Object)this.type));
        }
        this.setContentType(contentTypeVersioned);
    }

    public final Map<String, String> validateSubDocuments() {
        return this.validateSubDocuments(true);
    }

    public final Map<String, String> validateSubDocuments(boolean bl) {
        OOXML oOXML = this.getFormatVersion().getXML();
        if (!oOXML.canValidate()) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : subdocNames) {
            Object object;
            Document document = this.getDocument(string);
            if (document == null) continue;
            if (bl && (object = RootElement.fromDocument(document).createDocType(oOXML.getVersion())) != null && document.getDocType() == null) {
                document.setDocType((DocType)object);
            }
            if ((object = oOXML.getValidator(document).isValid()) == null) continue;
            hashMap.put(string, (String)object);
        }
        return hashMap;
    }

    public final ODDocument getODDocument() {
        if (this.doc == null) {
            ContentType contentType = this.getContentType().getType();
            if (contentType.equals((Object)ContentType.SPREADSHEET)) {
                this.doc = SpreadSheet.get(this);
            } else if (contentType.equals((Object)ContentType.TEXT)) {
                this.doc = TextDocument.get(this);
            }
        }
        return this.doc;
    }

    public final boolean hasODDocument() {
        return this.doc != null;
    }

    public final SpreadSheet getSpreadSheet() {
        return (SpreadSheet)this.getODDocument();
    }

    public final TextDocument getTextDocument() {
        return (TextDocument)this.getODDocument();
    }

    public final Set<String> getEntries() {
        return this.files.keySet();
    }

    public final ODPackageEntry getEntry(String string) {
        return this.files.get(string);
    }

    protected final Object getData(String string) {
        ODPackageEntry oDPackageEntry = this.getEntry(string);
        return oDPackageEntry == null ? null : oDPackageEntry.getData();
    }

    public final byte[] getBinaryFile(String string) {
        return (byte[])this.getData(string);
    }

    public final ODXMLDocument getXMLFile(String string) {
        return (ODXMLDocument)this.getData(string);
    }

    public final ODXMLDocument getXMLFile(Document document) {
        for (String string : subdocNames) {
            ODXMLDocument oDXMLDocument = this.getXMLFile(string);
            if (oDXMLDocument == null || oDXMLDocument.getDocument() != document) continue;
            return oDXMLDocument;
        }
        return null;
    }

    public final ODXMLDocument getStyles() {
        ODXMLDocument oDXMLDocument = this.isSingle() ? this.getContent() : this.getXMLFile(RootElement.STYLES.getZipEntry());
        return oDXMLDocument;
    }

    public final ODXMLDocument getContent() {
        return this.getXMLFile(RootElement.CONTENT.getZipEntry());
    }

    public final ODMeta getMeta() {
        ODMeta oDMeta = this.getEntries().contains(RootElement.META.getZipEntry()) ? ODMeta.create(this.getXMLFile(RootElement.META.getZipEntry())) : ODMeta.create(this.getContent());
        return oDMeta;
    }

    public Document getDocument(String string) {
        ODXMLDocument oDXMLDocument = this.getXMLFile(string);
        return oDXMLDocument == null ? null : oDXMLDocument.getDocument();
    }

    public final Element getStyle(StyleDesc<?> styleDesc, String string) {
        return this.getStyle(this.getContent().getDocument(), styleDesc, string);
    }

    /*
     * WARNING - void declaration
     */
    public final Element getStyle(Document document, StyleDesc<?> styleDesc, String string) {
        void var6_9;
        String[] stringArray;
        if (string == null) {
            return null;
        }
        String string2 = null;
        for (String string3 : stringArray = new String[]{RootElement.CONTENT.getZipEntry(), RootElement.STYLES.getZipEntry()}) {
            if (this.getDocument(string3) != document) continue;
            string2 = string3;
        }
        if (string2 == null) {
            throw new IllegalArgumentException("neither in content nor styles : " + document);
        }
        Element element = this.getXMLFile(string2).getStyle(styleDesc, string);
        if (element == null && string2.equals(stringArray[0]) && this.getXMLFile(stringArray[1]) != null) {
            Element element2 = this.getXMLFile(stringArray[1]).getStyle(styleDesc, string);
        }
        return var6_9;
    }

    public final Element getDefaultStyle(StyleStyleDesc<?> styleStyleDesc) {
        return this.getStyles().getDefaultStyle(styleStyleDesc);
    }

    public final String checkStyles() {
        Element element;
        ODXMLDocument oDXMLDocument = this.getStyles();
        ODXMLDocument oDXMLDocument2 = this.getContent();
        if (oDXMLDocument != null) {
            element = oDXMLDocument.getChild("styles");
            String string = ODPackage.checkStyles(oDXMLDocument, element);
            if (string != null) {
                return string;
            }
        } else {
            element = oDXMLDocument2.getChild("styles");
        }
        return ODPackage.checkStyles(oDXMLDocument2, element);
    }

    private static final String checkStyles(ODXMLDocument oDXMLDocument, Element element) {
        try {
            CollectionMap<String, String> collectionMap = ODPackage.getStylesNames(oDXMLDocument, element, oDXMLDocument.getChild("automatic-styles"));
            HashSet<String> hashSet = new HashSet<String>(collectionMap.values());
            for (Attribute attribute : oDXMLDocument.getXPath(".//@text:style-name | .//@table:style-name | .//@draw:style-name | .//@style:data-style-name | .//@style:list-style-name").selectNodes(oDXMLDocument.getDocument())) {
                if (hashSet.contains(attribute.getValue())) continue;
                return "unknown style referenced by " + attribute.getName() + " in " + JDOMUtils.output(attribute.getParent());
            }
        }
        catch (IllegalStateException illegalStateException) {
            return ExceptionUtils.getStackTrace(illegalStateException);
        }
        catch (JDOMException jDOMException) {
            return ExceptionUtils.getStackTrace(jDOMException);
        }
        return null;
    }

    private static final CollectionMap<String, String> getStylesNames(ODXMLDocument oDXMLDocument, Element element, Element element2) throws IllegalStateException {
        CollectionMap<String, String> collectionMap = new CollectionMap<String, String>(HashSet.class);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        if (element != null) {
            arrayList.add(element);
        }
        if (element2 != null) {
            arrayList.add(element2);
        }
        try {
            Object object2;
            for (Object object2 : oDXMLDocument.getXPath("./style:style/@style:name").selectNodes(arrayList)) {
                String string = ((Attribute)object2).getValue();
                Object object3 = ((Attribute)object2).getParent().getAttributeValue("family", ((Attribute)object2).getNamespace());
                if (collectionMap.getNonNull((String)object3).contains(string)) {
                    throw new IllegalStateException("duplicate style in " + (String)object3 + " :  " + (String)string);
                }
                collectionMap.put(object3, (Object)string);
            }
            List<String> list = Arrays.asList("number-style", "currency-style", "percentage-style", "date-style", "time-style", "boolean-style", "text-style");
            object2 = CollectionUtils.join(list, " | ", new ITransformer<String, String>(){

                @Override
                public String transformChecked(String string) {
                    return "./number:" + string;
                }
            });
            for (Object object3 : oDXMLDocument.getXPath("./text:list-style | " + (String)object2).selectNodes(arrayList)) {
                collectionMap.put((Object)((Element)object3).getQualifiedName(), (Object)((Element)object3).getAttributeValue("name", oDXMLDocument.getVersion().getSTYLE()));
            }
        }
        catch (JDOMException jDOMException) {
            throw new IllegalStateException(jDOMException);
        }
        return collectionMap;
    }

    public void putFile(String string, Object object) {
        this.putFile(string, object, null);
    }

    public void putFile(String string, Object object, String string2) {
        this.putFile(string, object, string2, true);
    }

    public void putFile(String string, Object object, String string2, boolean bl) {
        Object object2;
        Object object3;
        if (string == null) {
            throw new NullPointerException("null name");
        }
        if (object == null) {
            this.rmFile(string);
            return;
        }
        if (subdocNames.contains(string)) {
            object3 = object instanceof Document ? ODXMLDocument.create((Document)object) : (ODXMLDocument)object;
            this.checkEntryForDocument(string);
            this.updateTypeAndVersion(string, (ODXMLDocument)object3);
            object2 = object3;
        } else {
            if (!(object instanceof byte[])) {
                throw new IllegalArgumentException("should be byte[] for " + string + ": " + object);
            }
            if (string.equals(MIMETYPE_ENTRY)) {
                this.updateTypeAndVersion((byte[])object);
            }
            object2 = object;
        }
        object3 = string2 != null ? string2 : FileUtils.findMimeType(string);
        this.files.put(string, new ODPackageEntry(string, (String)object3, object2, bl));
    }

    private void checkEntryForDocument(String string) {
        if (this.hasODDocument() && (string.equals(RootElement.CONTENT.getZipEntry()) || string.equals(RootElement.STYLES.getZipEntry()))) {
            throw new IllegalArgumentException("Cannot change content or styles with existing ODDocument");
        }
    }

    public void rmFile(String string) {
        this.checkEntryForDocument(string);
        this.files.remove(string);
        if (string.equals(MIMETYPE_ENTRY) || subdocNames.contains(string)) {
            Tuple3<XMLVersion, ContentTypeVersioned, XMLFormatVersion> tuple3 = this.getRequired(string);
            this.type = tuple3 == null ? null : (ContentTypeVersioned)((Object)tuple3.get1());
            this.version = tuple3 == null ? null : tuple3.get2();
        }
    }

    public void clear() {
        this.files.clear();
        this.type = null;
        this.version = null;
    }

    public ODSingleXMLDocument toSingle() {
        if (!this.isSingle()) {
            return ODSingleXMLDocument.create(this);
        }
        return (ODSingleXMLDocument)this.getContent();
    }

    public final boolean isSingle() {
        return this.getContent() instanceof ODSingleXMLDocument;
    }

    public final boolean split() {
        boolean bl;
        if (this.isSingle()) {
            Map<RootElement, Document> map = ((ODSingleXMLDocument)this.getContent()).split();
            assert ((map.containsKey((Object)RootElement.CONTENT) || map.containsKey((Object)RootElement.STYLES)) && RootElement.getPackageElements().containsAll(map.keySet())) : "wrong elements " + map;
            XMLFormatVersion xMLFormatVersion = this.getFormatVersion();
            for (Map.Entry<RootElement, Document> entry : map.entrySet()) {
                this.putFile(entry.getKey().getZipEntry(), new ODXMLDocument(entry.getValue(), xMLFormatVersion));
            }
            bl = true;
        } else {
            bl = false;
        }
        assert (!this.isSingle());
        return bl;
    }

    public final void save(OutputStream outputStream) throws IOException {
        if (this.isSingle()) {
            assert (this.getClass() == ODPackage.class);
            ODPackage oDPackage = new ODPackage(this);
            oDPackage.split();
            oDPackage.save(outputStream);
            return;
        }
        Zip zip = new Zip(outputStream);
        zip.zipNonCompressed(MIMETYPE_ENTRY, this.getMimeType().getBytes(MIMETYPE_ENC));
        Manifest manifest = new Manifest(this.getVersion(), this.getMimeType());
        for (String string : this.files.keySet()) {
            Object object;
            if (string.equals(MIMETYPE_ENTRY) || string.equals("META-INF/manifest.xml")) continue;
            ODPackageEntry oDPackageEntry = this.files.get(string);
            Object object2 = oDPackageEntry.getData();
            if (object2 != null) {
                if (object2 instanceof ODXMLDocument) {
                    object = zip.createEntry(string);
                    OUTPUTTER.output(((ODXMLDocument)object2).getDocument(), (OutputStream)object);
                    ((OutputStream)object).close();
                } else {
                    zip.zip(string, (byte[])object2, oDPackageEntry.isCompressed());
                }
            }
            manifest.addEntry(string, (String)((object = oDPackageEntry.getType()) == null ? "" : object));
        }
        zip.zip("META-INF/manifest.xml", new StringInputStream(manifest.asString()));
        zip.close();
    }

    public File save() throws IOException {
        return this.saveAs(this.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File saveAs(File file) throws IOException {
        File file2 = this.addExt(file);
        if (file2.getParentFile() != null) {
            file2.getParentFile().mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 524288);
        try {
            this.save(bufferedOutputStream);
        }
        finally {
            bufferedOutputStream.close();
        }
        return file2;
    }

    static {
        for (RootElement rootElement : RootElement.getPackageElements()) {
            if (rootElement.getZipEntry() == null) continue;
            subdocNames.add(rootElement.getZipEntry());
        }
    }

    public static enum RootElement {
        SINGLE_CONTENT("office", "document", null),
        CONTENT("office", "document-content", "content.xml"),
        STYLES("office", "document-styles", "styles.xml"),
        META("office", "document-meta", "meta.xml"),
        SETTINGS("office", "document-settings", "settings.xml");

        private final String nsPrefix;
        private final String name;
        private final String zipEntry;

        public static final EnumSet<RootElement> getPackageElements() {
            return EnumSet.of(CONTENT, STYLES, META, SETTINGS);
        }

        public static final RootElement fromDocument(Document document) {
            return RootElement.fromElementName(document.getRootElement().getName());
        }

        public static final RootElement fromElementName(String string) {
            for (RootElement rootElement : RootElement.values()) {
                if (!rootElement.getElementName().equals(string)) continue;
                return rootElement;
            }
            return null;
        }

        static final Document createSingle(Document document) {
            return SINGLE_CONTENT.createDocument(XMLFormatVersion.get(document));
        }

        private RootElement(String string2, String string3, String string4) {
            this.nsPrefix = string2;
            this.name = string3;
            this.zipEntry = string4;
        }

        public final String getElementNSPrefix() {
            return this.nsPrefix;
        }

        public final String getElementName() {
            return this.name;
        }

        public final Document createDocument(XMLFormatVersion xMLFormatVersion) {
            XMLVersion xMLVersion = xMLFormatVersion.getXMLVersion();
            Element element = new Element(this.getElementName(), xMLVersion.getNS(this.getElementNSPrefix()));
            if (xMLFormatVersion.getOfficeVersion() != null) {
                element.setAttribute("version", xMLFormatVersion.getOfficeVersion(), xMLVersion.getOFFICE());
            }
            for (Namespace namespace : xMLVersion.getALL()) {
                element.addNamespaceDeclaration(namespace);
            }
            return new Document(element, this.createDocType(xMLVersion));
        }

        public final DocType createDocType(XMLVersion xMLVersion) {
            if (xMLVersion == XMLVersion.OOo) {
                return new DocType(this.getElementNSPrefix() + ":" + this.getElementName(), "-//OpenOffice.org//DTD OfficeDocument 1.0//EN", "office.dtd");
            }
            return null;
        }

        public final String getZipEntry() {
            return this.zipEntry;
        }
    }
}

