/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import org.jopendocument.util.TimeUtils;

public final class ODEpoch {
    private static final BigDecimal MS_PER_DAY = BigDecimal.valueOf(86400000L);
    private static final DateFormat DATE_FORMAT;
    private static final ODEpoch DEFAULT_EPOCH;
    private static final Map<String, ODEpoch> cache;
    private final String dateString;
    private final Calendar epochUTC;

    public static final ODEpoch getDefaultEpoch() {
        return DEFAULT_EPOCH;
    }

    public static final ODEpoch getInstance(String string) throws ParseException {
        if (string == null || string.equals(DEFAULT_EPOCH.getDateString())) {
            return DEFAULT_EPOCH;
        }
        ODEpoch oDEpoch = cache.get(string);
        if (oDEpoch == null) {
            oDEpoch = new ODEpoch(string);
            cache.put(string, oDEpoch);
        }
        return oDEpoch;
    }

    private static final Calendar parse(String string) throws ParseException {
        Calendar calendar = (Calendar)DATE_FORMAT.getCalendar().clone();
        calendar.setTime(DATE_FORMAT.parse(string));
        return calendar;
    }

    private ODEpoch(String string) throws ParseException {
        this.dateString = string;
        this.epochUTC = ODEpoch.parse(string);
        assert (this.epochUTC.getTimeZone().equals(DATE_FORMAT.getTimeZone()));
    }

    public final String getDateString() {
        return this.dateString;
    }

    public final Calendar getCalendar() {
        return (Calendar)this.epochUTC.clone();
    }

    private final Calendar getDate(Duration duration) {
        Calendar calendar = this.getCalendar();
        duration.addTo(calendar);
        return calendar;
    }

    public final Duration normalizeToDays(Duration duration) {
        Duration duration2;
        Duration duration3 = duration2 = duration.getYears() == 0 && duration.getMonths() == 0 ? duration : ODEpoch.getDuration(this.getDays(duration));
        assert (duration2.getYears() == 0 && duration2.getMonths() == 0);
        return duration2;
    }

    public final Duration normalizeToHours(Duration duration) {
        Duration duration2 = this.normalizeToDays(duration);
        BigInteger bigInteger = (BigInteger)duration2.getField(DatatypeConstants.DAYS);
        BigInteger bigInteger2 = ((BigInteger)duration2.getField(DatatypeConstants.HOURS)).add(bigInteger.multiply(BigInteger.valueOf(24L)));
        return TimeUtils.getTypeFactory().newDuration(bigInteger.signum() >= 0, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, bigInteger2, (BigInteger)duration2.getField(DatatypeConstants.MINUTES), (BigDecimal)duration2.getField(DatatypeConstants.SECONDS));
    }

    public final BigDecimal getDays(Duration duration) {
        return this.getDays(this.getDate(duration));
    }

    public final BigDecimal getDays(Calendar calendar) {
        long l = TimeUtils.normalizeLocalTime(calendar) - this.epochUTC.getTimeInMillis();
        return BigDecimal.valueOf(l).divide(MS_PER_DAY, MathContext.DECIMAL128);
    }

    public final Calendar getDate(BigDecimal bigDecimal) {
        return this.getDate(bigDecimal, Calendar.getInstance());
    }

    public final Calendar getDate(BigDecimal bigDecimal, Calendar calendar) {
        Calendar calendar2 = this.getDate(ODEpoch.getDuration(bigDecimal));
        return TimeUtils.copyLocalTime(calendar2, calendar);
    }

    private static final Duration getDuration(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal.abs();
        BigInteger bigInteger = bigDecimal2.toBigInteger().abs();
        BigDecimal bigDecimal3 = bigDecimal2.subtract(new BigDecimal(bigInteger)).multiply(BigDecimal.valueOf(24L));
        BigInteger bigInteger2 = bigDecimal3.toBigInteger();
        BigDecimal bigDecimal4 = bigDecimal3.subtract(new BigDecimal(bigInteger2)).multiply(BigDecimal.valueOf(60L));
        BigInteger bigInteger3 = bigDecimal4.toBigInteger();
        BigDecimal bigDecimal5 = bigDecimal4.subtract(new BigDecimal(bigInteger3)).multiply(BigDecimal.valueOf(60L)).round(MathContext.DECIMAL64);
        return TimeUtils.getTypeFactory().newDuration(bigDecimal.signum() >= 0, BigInteger.ZERO, BigInteger.ZERO, bigInteger, bigInteger2, bigInteger3, bigDecimal5);
    }

    static {
        cache = new LinkedHashMap<String, ODEpoch>(4, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ODEpoch> entry) {
                return this.size() > 16;
            }
        };
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        DATE_FORMAT.setCalendar(Calendar.getInstance(TimeZone.getTimeZone("UTC")));
        try {
            DEFAULT_EPOCH = new ODEpoch("1899-12-30");
        }
        catch (ParseException parseException) {
            throw new IllegalStateException(parseException);
        }
    }
}

