/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.ODEpoch;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.XMLFormatVersion;
import org.jopendocument.dom.XMLVersion;

public abstract class ODDocument {
    private final ODPackage pkg;
    private ODEpoch epoch;

    protected ODDocument(ODPackage oDPackage) {
        if (oDPackage.hasODDocument()) {
            throw new IllegalStateException("ODPackage already has an ODDocument");
        }
        this.pkg = oDPackage;
    }

    public final XMLVersion getVersion() {
        return this.getFormatVersion().getXMLVersion();
    }

    public final XMLFormatVersion getFormatVersion() {
        return this.getPackage().getFormatVersion();
    }

    public final ODPackage getPackage() {
        return this.pkg;
    }

    public final Document getContentDocument() {
        return this.getPackage().getContent().getDocument();
    }

    protected final Element getBody() {
        return this.getPackage().getContentType().getBody(this.getContentDocument());
    }

    private final String findEpoch() throws ParseException {
        Element element;
        Namespace namespace = this.getVersion().getTABLE();
        Element element2 = this.getBody().getChild("calculation-settings", namespace);
        if (element2 != null && (element = element2.getChild("null-date", namespace)) != null) {
            return element.getAttributeValue("date-value", namespace);
        }
        return null;
    }

    public final ODEpoch getEpoch() {
        return this.getEpoch(false);
    }

    public final ODEpoch getEpoch(boolean bl) {
        if (this.epoch == null || bl) {
            try {
                this.epoch = ODEpoch.getInstance(this.findEpoch());
            }
            catch (ParseException parseException) {
                throw new IllegalStateException("Unable to parse the epoch of " + this, parseException);
            }
        }
        assert (this.epoch != null);
        return this.epoch;
    }

    public File saveAs(File file) throws FileNotFoundException, IOException {
        this.getPackage().setFile(file);
        return this.getPackage().save();
    }
}

