/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.Arrays;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.ContentType;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.XMLFormatVersion;
import org.jopendocument.dom.XMLVersion;

public class ContentTypeVersioned
extends Enum<ContentTypeVersioned> {
    public static final /* enum */ ContentTypeVersioned TEXT_V1 = new ContentTypeVersioned(ContentType.TEXT, XMLVersion.OOo, "application/vnd.sun.xml.writer", "text", "sxw"){};
    public static final /* enum */ ContentTypeVersioned GRAPHICS_V1 = new ContentTypeVersioned(ContentType.GRAPHICS, XMLVersion.OOo, "application/vnd.sun.xml.draw", "drawing", "sxd"){};
    public static final /* enum */ ContentTypeVersioned PRESENTATION_V1 = new ContentTypeVersioned(ContentType.PRESENTATION, XMLVersion.OOo, "application/vnd.sun.xml.impress", "presentation", "sxi"){};
    public static final /* enum */ ContentTypeVersioned SPREADSHEET_V1 = new ContentTypeVersioned(ContentType.SPREADSHEET, XMLVersion.OOo, "application/vnd.sun.xml.calc", "spreadsheet", "sxc"){};
    public static final /* enum */ ContentTypeVersioned TEXT = new ContentTypeVersioned(ContentType.TEXT, XMLVersion.OD, "application/vnd.oasis.opendocument.text", "text", "odt"){};
    public static final /* enum */ ContentTypeVersioned TEXT_TEMPLATE = new ContentTypeVersioned(ContentType.TEXT, XMLVersion.OD, "application/vnd.oasis.opendocument.text-template", "text", "ott"){};
    public static final /* enum */ ContentTypeVersioned GRAPHICS = new ContentTypeVersioned(ContentType.GRAPHICS, XMLVersion.OD, "application/vnd.oasis.opendocument.graphics", "drawing", "odg"){};
    public static final /* enum */ ContentTypeVersioned GRAPHICS_TEMPLATE = new ContentTypeVersioned(ContentType.GRAPHICS, XMLVersion.OD, "application/vnd.oasis.opendocument.graphics-template", "drawing", "otg"){};
    public static final /* enum */ ContentTypeVersioned PRESENTATION = new ContentTypeVersioned(ContentType.PRESENTATION, XMLVersion.OD, "application/vnd.oasis.opendocument.presentation", "presentation", "odp"){};
    public static final /* enum */ ContentTypeVersioned PRESENTATION_TEMPLATE = new ContentTypeVersioned(ContentType.PRESENTATION, XMLVersion.OD, "application/vnd.oasis.opendocument.presentation-template", "presentation", "otp"){};
    public static final /* enum */ ContentTypeVersioned SPREADSHEET = new ContentTypeVersioned(ContentType.SPREADSHEET, XMLVersion.OD, "application/vnd.oasis.opendocument.spreadsheet", "spreadsheet", "ods"){};
    public static final /* enum */ ContentTypeVersioned SPREADSHEET_TEMPLATE = new ContentTypeVersioned(ContentType.SPREADSHEET, XMLVersion.OD, "application/vnd.oasis.opendocument.spreadsheet-template", "spreadsheet", "ots"){};
    private final ContentType type;
    private final XMLVersion version;
    private final String mimeType;
    private final String shortName;
    private final String extension;
    private static final String TEMPLATE_SUFFIX = "-template";
    private static final /* synthetic */ ContentTypeVersioned[] $VALUES;

    public static ContentTypeVersioned[] values() {
        return (ContentTypeVersioned[])$VALUES.clone();
    }

    public static ContentTypeVersioned valueOf(String string) {
        return Enum.valueOf(ContentTypeVersioned.class, string);
    }

    private ContentTypeVersioned(ContentType contentType, XMLVersion xMLVersion, String string2, String string3, String string4) {
        this.type = contentType;
        this.mimeType = string2;
        this.version = xMLVersion;
        this.shortName = string3;
        this.extension = string4;
    }

    public final XMLVersion getVersion() {
        return this.version;
    }

    public final String getShortName() {
        return this.shortName;
    }

    public final String getBodyPath() {
        return this.getVersion() == XMLVersion.OOo ? "./office:body" : "./office:body/office:" + this.getShortName();
    }

    public final Element getBody(Document document) {
        Namespace namespace = this.getVersion().getOFFICE();
        Element element = document.getRootElement().getChild("body", namespace);
        if (this.getVersion().equals((Object)XMLVersion.OOo)) {
            return element;
        }
        return element.getChild(this.getShortName(), namespace);
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    public final ContentType getType() {
        return this.type;
    }

    public final String getExtension() {
        return this.extension;
    }

    public final boolean isTemplate() {
        return this.getMimeType().endsWith(TEMPLATE_SUFFIX);
    }

    public final ContentTypeVersioned getTemplate() {
        if (this.isTemplate()) {
            return this;
        }
        return ContentTypeVersioned.fromMime(this.getMimeType() + TEMPLATE_SUFFIX);
    }

    public final ContentTypeVersioned getNonTemplate() {
        if (this.isTemplate()) {
            return ContentTypeVersioned.fromMime(this.getMimeType().substring(0, this.getMimeType().length() - TEMPLATE_SUFFIX.length()));
        }
        return this;
    }

    public final Element createContent(XMLFormatVersion xMLFormatVersion) {
        return this.createContent(xMLFormatVersion, false);
    }

    public Element createContent(XMLFormatVersion xMLFormatVersion, boolean bl) {
        Element element;
        this.checkVersion(xMLFormatVersion);
        ODPackage.RootElement rootElement = bl ? ODPackage.RootElement.SINGLE_CONTENT : ODPackage.RootElement.CONTENT;
        Document document = rootElement.createDocument(xMLFormatVersion);
        Namespace namespace = this.getVersion().getOFFICE();
        this.setType(document, rootElement, namespace);
        document.getRootElement().addContent(new Element("automatic-styles", namespace));
        Element element2 = new Element("body", namespace);
        if (this.getVersion().equals((Object)XMLVersion.OD)) {
            element = new Element(this.getShortName(), namespace);
            element2.addContent(element);
        } else {
            element = element2;
        }
        document.getRootElement().addContent(element2);
        return element;
    }

    private final void checkVersion(XMLFormatVersion xMLFormatVersion) {
        if (xMLFormatVersion.getXMLVersion() != this.getVersion()) {
            throw new IllegalArgumentException("Version mismatch : " + (Object)((Object)xMLFormatVersion.getXMLVersion()));
        }
    }

    public void setType(Document document) {
        this.setType(document, ODPackage.RootElement.fromDocument(document), this.getVersion().getOFFICE());
    }

    private void setType(Document document, ODPackage.RootElement rootElement, Namespace namespace) {
        Element element = document.getRootElement();
        assert (element.getName().equals(rootElement.getElementName()));
        if (rootElement != ODPackage.RootElement.CONTENT && rootElement != ODPackage.RootElement.SINGLE_CONTENT) {
            throw new IllegalArgumentException("the document is not content : " + (Object)((Object)rootElement));
        }
        if (this.getVersion().equals((Object)XMLVersion.OOo)) {
            element.setAttribute("class", this.getShortName(), namespace);
        } else if (this.getVersion().equals((Object)XMLVersion.OD) && rootElement == ODPackage.RootElement.SINGLE_CONTENT) {
            element.setAttribute("mimetype", this.getMimeType(), namespace);
        }
    }

    public Document createStyles(XMLFormatVersion xMLFormatVersion) {
        this.checkVersion(xMLFormatVersion);
        Namespace namespace = this.getVersion().getOFFICE();
        Document document = ODPackage.RootElement.STYLES.createDocument(xMLFormatVersion);
        document.getRootElement().addContent(Arrays.asList(new Element("styles", namespace), new Element("automatic-styles", namespace), new Element("master-styles", namespace)));
        return document;
    }

    public ODPackage createPackage(XMLFormatVersion xMLFormatVersion) {
        return ODPackage.createFromDocuments(this, this.createContent(xMLFormatVersion, false).getDocument(), this.createStyles(xMLFormatVersion), null, null);
    }

    static ContentTypeVersioned fromType(ContentType contentType, XMLVersion xMLVersion, boolean bl) {
        for (ContentTypeVersioned contentTypeVersioned : ContentTypeVersioned.values()) {
            if (!contentTypeVersioned.getType().equals((Object)contentType) || contentTypeVersioned.getVersion() != xMLVersion || contentTypeVersioned.isTemplate() != bl) continue;
            return contentTypeVersioned;
        }
        return null;
    }

    public static ContentTypeVersioned fromMime(String string) {
        for (ContentTypeVersioned contentTypeVersioned : ContentTypeVersioned.values()) {
            if (!contentTypeVersioned.getMimeType().equals(string)) continue;
            return contentTypeVersioned;
        }
        return null;
    }

    public static ContentTypeVersioned fromMime(byte[] byArray) {
        return ContentTypeVersioned.fromMime(new String(byArray, ODPackage.MIMETYPE_ENC));
    }

    static ContentTypeVersioned fromContent(ODXMLDocument oDXMLDocument) {
        ContentTypeVersioned contentTypeVersioned;
        XMLVersion xMLVersion = oDXMLDocument.getVersion();
        if (xMLVersion.equals((Object)XMLVersion.OOo)) {
            Element element = oDXMLDocument.getDocument().getRootElement();
            String string = element.getAttributeValue("class", element.getNamespace("office"));
            contentTypeVersioned = ContentTypeVersioned.fromClass(string);
        } else if (xMLVersion.equals((Object)XMLVersion.OD)) {
            Element element = (Element)oDXMLDocument.getChild("body").getChildren().get(0);
            contentTypeVersioned = ContentTypeVersioned.fromBody(element.getName());
        } else {
            throw new IllegalStateException("Unknown content version : " + (Object)((Object)xMLVersion));
        }
        assert (!contentTypeVersioned.isTemplate()) : "template status cannot be inferred from content";
        return contentTypeVersioned;
    }

    static ContentTypeVersioned fromClass(String string) {
        return ContentTypeVersioned.fromShortName(XMLVersion.OOo, string);
    }

    static ContentTypeVersioned fromBody(String string) {
        return ContentTypeVersioned.fromShortName(XMLVersion.OD, string);
    }

    private static ContentTypeVersioned fromShortName(XMLVersion xMLVersion, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        for (ContentTypeVersioned contentTypeVersioned : ContentTypeVersioned.values()) {
            if (!contentTypeVersioned.shortName.equals(string) || contentTypeVersioned.getVersion() != xMLVersion) continue;
            return contentTypeVersioned;
        }
        return null;
    }

    static {
        $VALUES = new ContentTypeVersioned[]{TEXT_V1, GRAPHICS_V1, PRESENTATION_V1, SPREADSHEET_V1, TEXT, TEXT_TEMPLATE, GRAPHICS, GRAPHICS_TEMPLATE, PRESENTATION, PRESENTATION_TEMPLATE, SPREADSHEET, SPREADSHEET_TEMPLATE};
    }
}

