/*
 * Decompiled with CFR 0.152.
 */
package org.jopenchart.barchart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import org.jopenchart.Axis;
import org.jopenchart.BottomAxis;
import org.jopenchart.DataModel1D;
import org.jopenchart.LeftAxis;
import org.jopenchart.barchart.BarChart;

public class VerticalBarChart
extends BarChart {
    public VerticalBarChart() {
        this.left = new LeftAxis();
        this.bottom = new BottomAxis();
    }

    public void setLeftAxis(Axis axis) {
        this.left = new LeftAxis(axis);
        this.left.setChart(this);
    }

    public void setBottomAxis(Axis axis) {
        this.bottom = new BottomAxis(axis);
        this.bottom.setChart(this);
    }

    public void setModel(DataModel1D model) {
        this.getDataModel().removeAll();
        this.addModel(model);
    }

    @Override
    public void renderPlot(Graphics2D g) {
        int nbBar = this.getBarNumber();
        int graphPosX = this.getChartRectangle().x;
        int graphPosY = this.getChartRectangle().y;
        int graphHeight = this.getChartRectangle().height;
        Number higherRange = this.getHigherRange();
        Number lowerRange = this.getLowerRange();
        if (higherRange == null) {
            higherRange = this.getDataModel().getMaxValue();
        }
        if (lowerRange == null) {
            lowerRange = this.getDataModel().getMinValue();
        }
        DataModel1D model1 = this.getModel(0);
        double maxYValue = Math.max(0.0, model1.getMaxValue().doubleValue());
        double minYValue = Math.min(0.0, model1.getMinValue().doubleValue());
        double rangeYValue = maxYValue - minYValue;
        double ratioy = (double)graphHeight / rangeYValue;
        long x = graphPosX + this.getSpaceBetweenBars();
        int i = 0;
        while (i < nbBar) {
            long y = graphPosY + graphHeight;
            Number valueAt = model1.getValueAt(i);
            if (valueAt != null) {
                double h = valueAt.doubleValue() * ratioy;
                g.setColor(this.getColor(0));
                y = (long)((double)y - (Math.ceil(h) - 1.0));
                g.fillRect((int)x, (int)y, this.getBarWidth(), (int)h);
            }
            x += (long)(this.getSpaceBetweenBars() + this.getBarWidth());
            ++i;
        }
        g.setColor(Color.pink);
    }

    @Override
    public void renderAxis(Graphics2D g) {
        g.setColor(Color.GRAY);
        g.setStroke(new BasicStroke());
        this.left.render(g);
        this.bottom.render(g);
    }

    public void setDataModel(DataModel1D model) {
        this.setModel(model);
    }

    @Override
    public double getXFromValue(Number value) {
        return (long)(this.getChartRectangle().x - this.getBarWidth() / 2) + (long)(this.getSpaceBetweenBars() + this.getBarWidth()) * value.longValue();
    }

    public LeftAxis getLeftAxis() {
        return (LeftAxis)this.left;
    }
}

