/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.Graph;

public class BronKerboschCliqueFinder<V, E> {
    private final Graph<V, E> graph;
    private Collection<Set<V>> cliques;

    public BronKerboschCliqueFinder(Graph<V, E> graph) {
        this.graph = graph;
    }

    public Collection<Set<V>> getAllMaximalCliques() {
        this.cliques = new ArrayList<Set<V>>();
        ArrayList potential_clique = new ArrayList();
        ArrayList candidates = new ArrayList();
        ArrayList already_found = new ArrayList();
        candidates.addAll(this.graph.vertexSet());
        this.findCliques(potential_clique, candidates, already_found);
        return this.cliques;
    }

    public Collection<Set<V>> getBiggestMaximalCliques() {
        this.getAllMaximalCliques();
        int maximum = 0;
        ArrayList<Set<V>> biggest_cliques = new ArrayList<Set<V>>();
        for (Set<V> clique : this.cliques) {
            if (maximum >= clique.size()) continue;
            maximum = clique.size();
        }
        for (Set<V> clique : this.cliques) {
            if (maximum != clique.size()) continue;
            biggest_cliques.add(clique);
        }
        return biggest_cliques;
    }

    private void findCliques(List<V> potential_clique, List<V> candidates, List<V> already_found) {
        ArrayList<V> candidates_array = new ArrayList<V>(candidates);
        if (!this.end(candidates, already_found)) {
            for (Object candidate : candidates_array) {
                ArrayList<V> new_candidates = new ArrayList<V>();
                ArrayList<V> new_already_found = new ArrayList<V>();
                potential_clique.add(candidate);
                candidates.remove(candidate);
                for (V new_candidate : candidates) {
                    if (!this.graph.containsEdge(candidate, new_candidate)) continue;
                    new_candidates.add(new_candidate);
                }
                for (V new_found : already_found) {
                    if (!this.graph.containsEdge(candidate, new_found)) continue;
                    new_already_found.add(new_found);
                }
                if (new_candidates.isEmpty() && new_already_found.isEmpty()) {
                    this.cliques.add(new HashSet<V>(potential_clique));
                } else {
                    this.findCliques(potential_clique, new_candidates, new_already_found);
                }
                already_found.add(candidate);
                potential_clique.remove(candidate);
            }
        }
    }

    private boolean end(List<V> candidates, List<V> already_found) {
        boolean end2 = false;
        for (V found : already_found) {
            int edgecounter = 0;
            for (V candidate : candidates) {
                if (!this.graph.containsEdge(found, candidate)) continue;
                ++edgecounter;
            }
            if (edgecounter != candidates.size()) continue;
            end2 = true;
        }
        return end2;
    }
}

