/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class PaintUtils {
    private static Border defaultBorder = BorderFactory.createBevelBorder(0);

    public static Border getDefaultBorder() {
        return defaultBorder;
    }

    public static Rectangle getTextBounds(Graphics g, JLabel label) {
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D r2d = fm.getStringBounds(label.getText(), g);
        Rectangle rect = r2d.getBounds();
        int xOffset = 0;
        switch (label.getHorizontalAlignment()) {
            case 4: 
            case 11: {
                xOffset = label.getBounds().width - rect.width;
                break;
            }
            case 0: {
                xOffset = (label.getBounds().width - rect.width) / 2;
                break;
            }
            default: {
                xOffset = 0;
            }
        }
        int yOffset = 0;
        switch (label.getVerticalAlignment()) {
            case 1: {
                yOffset = 0;
                break;
            }
            case 0: {
                yOffset = (label.getBounds().height - rect.height) / 2;
                break;
            }
            case 3: {
                yOffset = label.getBounds().height - rect.height;
            }
        }
        return new Rectangle(xOffset, yOffset, rect.width, rect.height);
    }

    public static void paintGradient(Graphics g, JComponent comp, Color color1, Color color2) {
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, color1, 0.0f, comp.getHeight(), color2, true);
        Graphics2D g2 = (Graphics2D)g;
        Paint oldPaint = g2.getPaint();
        g2.setPaint(paint);
        g2.fillRect(0, 0, comp.getWidth(), comp.getHeight());
        g2.setPaint(oldPaint);
    }

    public static void setBackgroundColor(Container cont, Color color) {
        cont.setBackground(color);
        Component[] children = cont.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Container) {
                PaintUtils.setBackgroundColor((Container)children[i], color);
            } else {
                children[i].setBackground(color);
            }
            ++i;
        }
    }

    public static void setForegroundColor(Container cont, Color color) {
        cont.setForeground(color);
        Component[] children = cont.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Container) {
                PaintUtils.setForegroundColor((Container)children[i], color);
            } else {
                children[i].setForeground(color);
            }
            ++i;
        }
    }

    public static void setFont(Container cont, Font font) {
        cont.setFont(font);
        Component[] children = cont.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Container) {
                PaintUtils.setFont((Container)children[i], font);
            } else {
                children[i].setFont(font);
            }
            ++i;
        }
    }
}

