/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import javax.swing.BoxLayout;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.MouseMessagingHandler;
import org.jdesktop.swingx.event.MessageSource;
import org.jdesktop.swingx.event.ProgressSource;

public class JXRootPane
extends JRootPane {
    private JXStatusBar statusBar;
    private JToolBar toolBar;
    private JPanel contentPanel = new JPanel();
    private MouseMessagingHandler handler;

    public JXRootPane() {
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.getContentPane().add((Component)this.contentPanel, "Center");
    }

    public void addComponent(Component comp) {
        this.contentPanel.add(comp);
        this.registerStatusBar(comp);
    }

    public void removeComponent(Component comp) {
        this.contentPanel.remove(comp);
        this.unregisterStatusBar(this.statusBar, comp);
    }

    public Component[] getContentComponents() {
        return this.contentPanel.getComponents();
    }

    private void registerStatusBar(Component comp) {
        Object source;
        if (this.statusBar == null || comp == null) {
            return;
        }
        if (comp instanceof MessageSource) {
            source = (MessageSource)((Object)comp);
            source.addMessageListener(this.statusBar);
        }
        if (comp instanceof ProgressSource) {
            source = (ProgressSource)((Object)comp);
            source.addProgressListener(this.statusBar);
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            int i = 0;
            while (i < comps.length) {
                this.registerStatusBar(comps[i]);
                ++i;
            }
        }
    }

    private void unregisterStatusBar(JXStatusBar statusBar, Component comp) {
        Object source;
        if (statusBar == null || comp == null) {
            return;
        }
        if (comp instanceof MessageSource) {
            source = (MessageSource)((Object)comp);
            source.removeMessageListener(statusBar);
        }
        if (comp instanceof ProgressSource) {
            source = (ProgressSource)((Object)comp);
            source.removeProgressListener(statusBar);
        }
        if (comp instanceof Container) {
            Component[] comps = ((Container)comp).getComponents();
            int i = 0;
            while (i < comps.length) {
                this.unregisterStatusBar(statusBar, comps[i]);
                ++i;
            }
        }
    }

    public void setStatusBar(JXStatusBar statusBar) {
        JXStatusBar oldStatusBar = this.statusBar;
        this.statusBar = statusBar;
        if (statusBar != null) {
            if (this.handler == null) {
                this.handler = new MouseMessagingHandler((Object)this, statusBar);
                if (this.toolBar != null) {
                    this.handler.registerListeners(this.toolBar.getComponents());
                }
                if (this.menuBar != null) {
                    this.handler.registerListeners(this.menuBar.getSubElements());
                }
            } else {
                this.handler.setMessageListener(statusBar);
            }
        }
        Component[] comps = this.contentPanel.getComponents();
        int i = 0;
        while (i < comps.length) {
            this.unregisterStatusBar(oldStatusBar, comps[i]);
            this.registerStatusBar(comps[i]);
            ++i;
        }
        if (oldStatusBar != null) {
            this.getContentPane().remove(oldStatusBar);
        }
        if (statusBar != null) {
            this.getContentPane().add("South", statusBar);
        }
    }

    public JXStatusBar getStatusBar() {
        return this.statusBar;
    }

    public void setToolBar(JToolBar toolBar) {
        JToolBar oldToolBar = this.toolBar;
        this.toolBar = toolBar;
        if (this.handler != null && oldToolBar != null) {
            this.handler.unregisterListeners(oldToolBar.getComponents());
        }
        if (this.handler != null && toolBar != null) {
            this.handler.registerListeners(toolBar.getComponents());
        }
        this.getContentPane().add("North", toolBar);
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    @Override
    public void setJMenuBar(JMenuBar menuBar) {
        JMenuBar oldMenuBar = this.menuBar;
        super.setJMenuBar(menuBar);
        if (this.handler != null && oldMenuBar != null) {
            this.handler.unregisterListeners(oldMenuBar.getSubElements());
        }
        if (this.handler != null && menuBar != null) {
            this.handler.registerListeners(menuBar.getSubElements());
        }
    }
}

