/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import koala.dynamicjava.util.AmbiguousFieldException;

public class ReflectionUtilities {
    public static Constructor lookupConstructor(Class cl, Class[] ac) throws NoSuchMethodException {
        List ms = ReflectionUtilities.getConstructors(cl, ac.length);
        LinkedList<Constructor> mm = new LinkedList<Constructor>();
        for (Constructor m : ms) {
            if (!ReflectionUtilities.hasCompatibleSignatures(m.getParameterTypes(), ac)) continue;
            mm.add(m);
        }
        if (mm.isEmpty()) {
            throw new NoSuchMethodException(String.valueOf(cl.getName()) + " constructor");
        }
        Iterator it = mm.iterator();
        Constructor result = (Constructor)it.next();
        while (it.hasNext()) {
            result = ReflectionUtilities.selectTheMostSpecificConstructor(result, (Constructor)it.next());
        }
        return result;
    }

    public static List getConstructors(Class cl, int params) {
        LinkedList result = new LinkedList();
        Constructor<?>[] ms = cl.getDeclaredConstructors();
        int i = 0;
        while (i < ms.length) {
            if (ms[i].getParameterTypes().length == params) {
                result.add(ms[i]);
            }
            ++i;
        }
        return result;
    }

    public static Method lookupMethod(Class cl, String name, List ac) throws NoSuchMethodException {
        return ReflectionUtilities.lookupMethod(cl, name, (Class[])ac.toArray());
    }

    public static Method lookupMethod(Class cl, String name, Class[] ac) throws NoSuchMethodException {
        List ms = ReflectionUtilities.getMethods(cl, name, ac.length);
        LinkedList<Method> mm = new LinkedList<Method>();
        for (Method m : ms) {
            if (!ReflectionUtilities.hasCompatibleSignatures(m.getParameterTypes(), ac)) continue;
            mm.add(m);
        }
        if (mm.isEmpty()) {
            throw new NoSuchMethodException(name);
        }
        Iterator it = mm.iterator();
        Method result = (Method)it.next();
        while (it.hasNext()) {
            result = ReflectionUtilities.selectTheMostSpecificMethod(result, (Method)it.next());
        }
        return result;
    }

    public static List getMethods(Class cl, String name, int params) {
        LinkedList<Method> result = new LinkedList<Method>();
        if (cl.isInterface()) {
            Method[] ms = cl.getDeclaredMethods();
            int i = 0;
            while (i < ms.length) {
                if (ms[i].getName().equals(name) && ms[i].getParameterTypes().length == params) {
                    result.add(ms[i]);
                }
                ++i;
            }
            Class<?>[] cs = cl.getInterfaces();
            int i2 = 0;
            while (i2 < cs.length) {
                result.addAll(ReflectionUtilities.getMethods(cs[i2], name, params));
                ++i2;
            }
            if (cs.length == 0) {
                result.addAll(ReflectionUtilities.getMethods(Object.class, name, params));
            }
        } else {
            Class c = cl;
            while (c != null) {
                Method[] ms = c.getDeclaredMethods();
                int i = 0;
                while (i < ms.length) {
                    if (ms[i].getName().equals(name) && ms[i].getParameterTypes().length == params) {
                        result.add(ms[i]);
                    }
                    ++i;
                }
                c = c.getSuperclass();
            }
        }
        return result;
    }

    public static Method lookupOuterMethod(Class cl, String name, Class[] ac) throws NoSuchMethodException {
        boolean sc = Modifier.isStatic(cl.getModifiers());
        Class<?> c = cl != null ? cl.getDeclaringClass() : null;
        while (c != null) {
            sc |= Modifier.isStatic(c.getModifiers());
            try {
                Method m = ReflectionUtilities.lookupMethod(c, name, ac);
                if (!sc || Modifier.isStatic(m.getModifiers())) {
                    return m;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            c = c.getDeclaringClass();
        }
        throw new NoSuchMethodException(name);
    }

    /*
     * Unable to fully structure code
     */
    public static Field getField(Class cl, String name) throws NoSuchFieldException, AmbiguousFieldException {
        c = cl;
        while (c != null) {
            try {
                return c.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                ints = c.getInterfaces();
                f = null;
                i = 0;
                ** while (i < ints.length)
            }
lbl-1000:
            // 1 sources

            {
                tmp = null;
                try {
                    tmp = ReflectionUtilities.getField(ints[i], name);
                }
                catch (NoSuchFieldException var8_8) {
                    // empty catch block
                }
                if (tmp != null) {
                    if (f != null && !f.equals(tmp)) {
                        throw new AmbiguousFieldException(name);
                    }
                    f = tmp;
                }
                ++i;
                continue;
            }
lbl22:
            // 1 sources

            if (f != null) {
                return f;
            }
            c = c.getSuperclass();
        }
        throw new NoSuchFieldException(name);
    }

    public static Field getOuterField(Class cl, String name) throws NoSuchFieldException, AmbiguousFieldException {
        boolean sc = Modifier.isStatic(cl.getModifiers());
        Class<?> c = cl != null ? cl.getDeclaringClass() : null;
        while (c != null) {
            sc |= Modifier.isStatic(c.getModifiers());
            try {
                Field f = ReflectionUtilities.getField(c, name);
                if (!sc || Modifier.isStatic(f.getModifiers())) {
                    return f;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            c = c.getDeclaringClass();
        }
        throw new NoSuchFieldException(name);
    }

    protected static Method selectTheMostSpecificMethod(Method m1, Method m2) {
        Class<?>[] a1 = m1.getParameterTypes();
        Class<?>[] a2 = m2.getParameterTypes();
        int i = 0;
        while (i < a1.length) {
            if (a1[i] != a2[i]) {
                return ReflectionUtilities.isCompatible(a1[i], a2[i]) ? m2 : m1;
            }
            ++i;
        }
        return m1;
    }

    protected static Constructor selectTheMostSpecificConstructor(Constructor c1, Constructor c2) {
        Class<?>[] a1 = c1.getParameterTypes();
        Class<?>[] a2 = c2.getParameterTypes();
        int i = 0;
        while (i < a1.length) {
            if (a1[i] != a2[i]) {
                if (ReflectionUtilities.isCompatible(a1[i], a2[i])) {
                    return c2;
                }
                return c1;
            }
            ++i;
        }
        return c1;
    }

    public static boolean hasCompatibleSignatures(Class[] a1, Class[] a2) {
        int i = 0;
        while (i < a1.length) {
            if (!ReflectionUtilities.isCompatible(a1[i], a2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isCompatible(Class c1, Class c2) {
        if (c1.isPrimitive()) {
            if (c1 != c2) {
                if (c1 == Integer.TYPE) {
                    return c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Character.TYPE;
                }
                if (c1 == Long.TYPE) {
                    return c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Integer.TYPE;
                }
                if (c1 == Short.TYPE) {
                    return c2 == Byte.TYPE;
                }
                if (c1 == Float.TYPE) {
                    return c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Integer.TYPE || c2 == Long.TYPE;
                }
                if (c1 == Double.TYPE) {
                    return c2 == Byte.TYPE || c2 == Short.TYPE || c2 == Integer.TYPE || c2 == Long.TYPE || c2 == Float.TYPE;
                }
                return false;
            }
            return true;
        }
        return c2 == null ? true : c1.isAssignableFrom(c2);
    }

    protected ReflectionUtilities() {
    }
}

