/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import koala.dynamicjava.tree.ArrayInitializer;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.Expression;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.visitor.Visitor;

public class FieldDeclaration
extends Node {
    public static final String ACCESS_FLAGS = "accessFlags";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String INITIALIZER = "initializer";
    private int accessFlags;
    private Type type;
    private String name;
    private Expression initializer;

    public FieldDeclaration(int flags, Type type, String name, Expression init) {
        this(flags, type, name, init, null, 0, 0, 0, 0);
    }

    public FieldDeclaration(int flags, Type type, String name, Expression init, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        this.accessFlags = flags;
        this.type = type;
        this.name = name;
        this.initializer = init;
        if (type instanceof ArrayType && this.initializer instanceof ArrayInitializer) {
            ((ArrayInitializer)this.initializer).setElementType(((ArrayType)type).getElementType());
        }
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int f) {
        this.accessFlags = f;
        this.firePropertyChange(ACCESS_FLAGS, this.accessFlags, this.accessFlags);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.type = t;
        this.firePropertyChange(TYPE, this.type, this.type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        this.name = s;
        this.firePropertyChange(NAME, this.name, this.name);
    }

    public Expression getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Expression e) {
        this.initializer = e;
        this.firePropertyChange(INITIALIZER, this.initializer, this.initializer);
    }

    @Override
    public Object acceptVisitor(Visitor visitor) {
        return visitor.visit(this);
    }
}

