/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter.modifier;

import koala.dynamicjava.interpreter.context.Context;
import koala.dynamicjava.interpreter.error.CatchedExceptionError;
import koala.dynamicjava.interpreter.modifier.LeftHandSideModifier;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.visitor.Visitor;

public class VariableModifier
extends LeftHandSideModifier {
    protected QualifiedName name;
    protected Class type;
    protected String representation;

    public VariableModifier(QualifiedName name, Class type) {
        this.name = name;
        this.type = type;
        this.representation = name.getRepresentation();
    }

    @Override
    public Object prepare(Visitor v, Context ctx) {
        return ctx.get(this.representation);
    }

    @Override
    public void modify(Context ctx, Object value) {
        if (!this.type.isPrimitive() && value != null && !this.type.isAssignableFrom(value.getClass())) {
            ClassCastException e = new ClassCastException(this.representation);
            throw new CatchedExceptionError(e, (Node)this.name);
        }
        ctx.set(this.representation, value);
    }
}

