/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter.context;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.interpreter.context.SimpleContext;

public class VariableContext
implements SimpleContext {
    protected Link scopes;
    protected Scope scope;
    protected Scope cscope;

    public VariableContext() {
        this.enterScope();
    }

    public VariableContext(Set entries) {
        this();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            ((AbstractVariable)it.next()).set(this, null);
        }
    }

    @Override
    public void enterScope() {
        this.scopes = LinkFactory.createLink(this.scopes);
        this.scope = this.scopes.scope;
        this.cscope = this.scopes.cscope;
    }

    @Override
    public void enterScope(Set entries) {
        this.enterScope();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            ((AbstractVariable)it.next()).set(this, null);
        }
    }

    @Override
    public void defineVariables(Set vars) {
        for (AbstractVariable v : vars) {
            if (v.get(this) != Scope.NO_SUCH_KEY) continue;
            v.set(this, null);
        }
    }

    @Override
    public Set leaveScope() {
        HashSet<AbstractVariable> result = new HashSet<AbstractVariable>(11);
        Iterator it = this.scope.keySet().iterator();
        while (it.hasNext()) {
            result.add(new Variable((String)it.next()));
        }
        it = this.cscope.keySet().iterator();
        while (it.hasNext()) {
            result.add(new Constant((String)it.next()));
        }
        this.scopes = this.scopes.next;
        this.scope = this.scopes.scope;
        this.cscope = this.scopes.cscope;
        return result;
    }

    @Override
    public Set getCurrentScopeVariables() {
        HashSet<AbstractVariable> result = new HashSet<AbstractVariable>(11);
        Iterator it = this.scope.keySet().iterator();
        while (it.hasNext()) {
            result.add(new Variable((String)it.next()));
        }
        it = this.cscope.keySet().iterator();
        while (it.hasNext()) {
            result.add(new Constant((String)it.next()));
        }
        return result;
    }

    @Override
    public Set getCurrentScopeVariableNames() {
        HashSet result = new HashSet(11);
        Iterator it = this.scope.keySet().iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        it = this.cscope.keySet().iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    @Override
    public boolean isDefinedVariable(String name) {
        Link l = this.scopes;
        while (l != null) {
            if (l.scope.get(name) != Scope.NO_SUCH_KEY) {
                return true;
            }
            if (l.cscope.get(name) != Scope.NO_SUCH_KEY) {
                return true;
            }
            l = l.next;
        }
        return false;
    }

    @Override
    public boolean isFinal(String name) {
        Link l = this.scopes;
        while (l != null) {
            if (l.cscope.get(name) != Scope.NO_SUCH_KEY) {
                return true;
            }
            l = l.next;
        }
        return false;
    }

    @Override
    public void define(String name, Object value) {
        if (this.scope.put(name, value) != Scope.NO_SUCH_KEY) {
            throw new IllegalStateException(name);
        }
    }

    @Override
    public void defineConstant(String name, Object value) {
        if (this.cscope.put(name, value) != Scope.NO_SUCH_KEY || this.scope.get(name) != Scope.NO_SUCH_KEY) {
            throw new IllegalStateException(name);
        }
    }

    @Override
    public Object get(String name) {
        Link l = this.scopes;
        while (l != null) {
            Object result = l.scope.get(name);
            if (result != Scope.NO_SUCH_KEY || (result = l.cscope.get(name)) != Scope.NO_SUCH_KEY) {
                return result;
            }
            l = l.next;
        }
        throw new IllegalStateException(name);
    }

    @Override
    public void set(String name, Object value) {
        Link l = this.scopes;
        while (l != null) {
            Object val = l.scope.get(name);
            if (val != Scope.NO_SUCH_KEY) {
                l.scope.put(name, value);
                return;
            }
            l = l.next;
        }
        throw new IllegalStateException(name);
    }

    @Override
    public void setConstant(String name, Object value) {
        this.cscope.put(name, value);
    }

    @Override
    public void setVariable(String name, Object value) {
        this.scope.put(name, value);
    }

    @Override
    public Map getConstants() {
        HashMap<String, Object> result = new HashMap<String, Object>(11);
        Link l = this.scopes;
        while (l != null) {
            for (String s : l.cscope.keySet()) {
                result.put(s, l.cscope.get(s));
            }
            l = l.next;
        }
        return result;
    }

    protected static abstract class AbstractVariable {
        public String name;

        protected AbstractVariable() {
        }

        public abstract void set(VariableContext var1, Object var2);

        public abstract Object get(VariableContext var1);

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    protected class Constant
    extends AbstractVariable {
        public Constant(String s) {
            this.name = s;
        }

        @Override
        public void set(VariableContext ctx, Object value) {
            ctx.cscope.put(this.name, value);
        }

        @Override
        public Object get(VariableContext ctx) {
            return ctx.cscope.get(this.name);
        }
    }

    protected static class Link {
        public Scope scope = new Scope();
        public Scope cscope = new Scope();
        public Link next;

        public Link(Link next) {
            this.next = next;
        }
    }

    protected static class LinkFactory {
        protected static final int SIZE = 10;
        protected static final WeakReference[] links = new WeakReference[10];

        protected LinkFactory() {
        }

        public static Link createLink(Link next) {
            return new Link(next);
        }

        public static void recycle(Link l) {
        }
    }

    protected static class Scope {
        protected static final float LOAD_FACTOR = 0.75f;
        protected static final int INITIAL_CAPACITY = 11;
        protected static final Object NO_SUCH_KEY = new Object();
        protected Entry[] table = new Entry[11];
        protected int count;
        protected int threshold = 8;

        public Object get(String key) {
            int hash = key.hashCode() & Integer.MAX_VALUE;
            int index = hash % this.table.length;
            Entry e = this.table[index];
            while (e != null) {
                if (e.hash == hash && e.key.equals(key)) {
                    return e.value;
                }
                e = e.next;
            }
            return NO_SUCH_KEY;
        }

        public Object put(String key, Object value) {
            int hash = key.hashCode() & Integer.MAX_VALUE;
            int index = hash % this.table.length;
            Entry e = this.table[index];
            while (e != null) {
                if (e.hash == hash && e.key.equals(key)) {
                    Object old = e.value;
                    e.value = value;
                    return old;
                }
                e = e.next;
            }
            if (this.count++ >= this.threshold) {
                this.rehash();
                index = hash % this.table.length;
            }
            this.table[index] = e = EntryFactory.createEntry(hash, key, value, this.table[index]);
            return NO_SUCH_KEY;
        }

        public Set keySet() {
            HashSet<String> result = new HashSet<String>(11);
            int i = this.table.length - 1;
            while (i >= 0) {
                Entry e = this.table[i];
                while (e != null) {
                    result.add(e.key);
                    e = e.next;
                }
                --i;
            }
            return result;
        }

        public void clear() {
            this.count = 0;
            int i = this.table.length - 1;
            while (i >= 0) {
                this.table[i] = null;
                --i;
            }
        }

        protected void rehash() {
            Entry[] oldTable = this.table;
            this.table = new Entry[oldTable.length * 2 + 1];
            this.threshold = (int)((float)this.table.length * 0.75f);
            int i = oldTable.length - 1;
            while (i >= 0) {
                Entry old = oldTable[i];
                while (old != null) {
                    Entry e = old;
                    old = old.next;
                    int index = e.hash % this.table.length;
                    e.next = this.table[index];
                    this.table[index] = e;
                }
                --i;
            }
        }

        protected static class Entry {
            public int hash;
            public String key;
            public Object value;
            public Entry next;

            public Entry(int hash, String key, Object value, Entry next) {
                this.hash = hash;
                this.key = key;
                this.value = value;
                this.next = next;
            }
        }

        protected static class EntryFactory {
            protected EntryFactory() {
            }

            public static Entry createEntry(int hash, String key, Object value, Entry next) {
                return new Entry(hash, key, value, next);
            }
        }
    }

    protected static class Variable
    extends AbstractVariable {
        public Variable(String s) {
            this.name = s;
        }

        @Override
        public void set(VariableContext ctx, Object value) {
            ctx.scope.put(this.name, value);
        }

        @Override
        public Object get(VariableContext ctx) {
            return ctx.scope.get(this.name);
        }
    }
}

