/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classinfo;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.classinfo.ClassFinder;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.ConstructorInfo;
import koala.dynamicjava.classinfo.FieldInfo;
import koala.dynamicjava.classinfo.MethodInfo;
import koala.dynamicjava.classinfo.TreeConstructorInfo;
import koala.dynamicjava.classinfo.TreeFieldInfo;
import koala.dynamicjava.classinfo.TreeMethodInfo;
import koala.dynamicjava.tree.ClassDeclaration;
import koala.dynamicjava.tree.ConstructorDeclaration;
import koala.dynamicjava.tree.ConstructorInvocation;
import koala.dynamicjava.tree.FieldDeclaration;
import koala.dynamicjava.tree.FormalParameter;
import koala.dynamicjava.tree.Identifier;
import koala.dynamicjava.tree.InterfaceDeclaration;
import koala.dynamicjava.tree.MethodDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.QualifiedName;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.SimpleAssignExpression;
import koala.dynamicjava.tree.TypeDeclaration;
import koala.dynamicjava.tree.visitor.VisitorObject;

public class TreeClassInfo
implements ClassInfo {
    private static final String DECLARING_CLASS = "declaringClass";
    public static final String ANONYMOUS_DECLARING_CLASS = "anonymousDeclaringClass";
    private static final String TREE_VISITED = "treeVisited";
    private final TypeDeclaration classTree;
    private final ClassFinder classFinder;
    private int dimension;
    private final String name;
    private ClassInfo superclass;
    private boolean interfaceInfo;
    private ClassInfo[] interfaces;
    private final Map fields = new HashMap();
    private final Map methods = new HashMap();
    private final List constructors = new LinkedList();
    private final List classes = new LinkedList();
    private boolean compilable = true;
    private int methodCount;

    public TreeClassInfo(TypeDeclaration cd, ClassFinder cf) {
        this.classFinder = cf;
        this.classTree = cd;
        this.name = this.fullName();
        this.interfaceInfo = cd instanceof InterfaceDeclaration;
        new MembersVisitor();
        this.classTree.setProperty(TREE_VISITED, null);
    }

    public TreeClassInfo(TreeClassInfo ci) {
        this.classFinder = ci.classFinder;
        this.classTree = ci.classTree;
        this.dimension = ci.dimension + 1;
        this.name = "[" + (ci.isArray() ? ci.getName() : "L" + ci.getName() + ";");
        new MembersVisitor();
    }

    @Override
    public Class getJavaClass() {
        throw new IllegalStateException();
    }

    public TypeDeclaration getTypeDeclaration() {
        return this.classTree;
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    @Override
    public boolean isCompilable() {
        return this.compilable;
    }

    @Override
    public void setCompilable(boolean b) {
        this.compilable = b;
    }

    @Override
    public ClassInfo getDeclaringClass() {
        return this.dimension == 0 ? (ClassInfo)this.classTree.getProperty(DECLARING_CLASS) : null;
    }

    @Override
    public ClassInfo getAnonymousDeclaringClass() {
        return this.dimension == 0 ? (ClassInfo)this.classTree.getProperty(ANONYMOUS_DECLARING_CLASS) : null;
    }

    @Override
    public int getModifiers() {
        return this.dimension == 0 ? this.classTree.getAccessFlags() : 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ClassInfo getSuperclass() {
        if (this.superclass == null) {
            if (this.interfaceInfo) {
                this.superclass = this.lookupClass("java.lang.Object");
            } else {
                ClassDeclaration cd = (ClassDeclaration)this.classTree;
                this.superclass = this.lookupClass(cd.getSuperclass(), this.getDeclaringClass());
            }
        }
        return this.superclass;
    }

    @Override
    public ClassInfo[] getInterfaces() {
        if (this.interfaces == null) {
            if (this.dimension > 0) {
                this.interfaces = new ClassInfo[]{this.lookupClass("java.lang.Cloneable"), this.lookupClass("java.io.Serializable")};
            } else {
                List l = this.classTree.getInterfaces();
                if (l != null) {
                    this.interfaces = new ClassInfo[l.size()];
                    Iterator it = l.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        String s = (String)it.next();
                        this.interfaces[i++] = this.lookupClass(s, this.getDeclaringClass());
                    }
                } else {
                    this.interfaces = new ClassInfo[0];
                }
            }
        }
        return (ClassInfo[])this.interfaces.clone();
    }

    public FieldInfo getField(FieldDeclaration node) {
        return (TreeFieldInfo)this.fields.get(node.getName());
    }

    @Override
    public FieldInfo[] getFields() {
        if (this.dimension == 0) {
            Set keys = this.fields.keySet();
            Iterator it = keys.iterator();
            FieldInfo[] result = new FieldInfo[keys.size()];
            int i = 0;
            while (it.hasNext()) {
                result[i++] = (FieldInfo)this.fields.get(it.next());
            }
            return result;
        }
        return new FieldInfo[0];
    }

    @Override
    public ConstructorInfo[] getConstructors() {
        if (this.dimension == 0) {
            Iterator it = this.constructors.iterator();
            ConstructorInfo[] result = new ConstructorInfo[this.constructors.size()];
            int i = 0;
            while (it.hasNext()) {
                result[i++] = (ConstructorInfo)it.next();
            }
            return result;
        }
        return new ConstructorInfo[0];
    }

    public MethodInfo getMethod(MethodDeclaration node) {
        Set keys = this.methods.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            List l = (List)this.methods.get(it.next());
            for (TreeMethodInfo mi : l) {
                if (mi.getMethodDeclaration() != node) continue;
                return mi;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public MethodInfo[] getMethods() {
        if (this.dimension == 0) {
            MethodInfo[] result = new MethodInfo[this.methodCount];
            Iterator it = this.methods.values().iterator();
            int i = 0;
            while (it.hasNext()) {
                Iterator lit = ((List)it.next()).iterator();
                while (lit.hasNext()) {
                    result[i++] = (MethodInfo)lit.next();
                }
            }
            return result;
        }
        return new MethodInfo[0];
    }

    @Override
    public ClassInfo[] getDeclaredClasses() {
        if (this.dimension == 0) {
            Iterator it = this.classes.iterator();
            ClassInfo[] result = new ClassInfo[this.classes.size()];
            int i = 0;
            while (it.hasNext()) {
                result[i++] = (ClassInfo)it.next();
            }
            return result;
        }
        return new ClassInfo[0];
    }

    @Override
    public ClassInfo getArrayType() {
        return new TreeClassInfo(this);
    }

    @Override
    public boolean isInterface() {
        return this.classTree instanceof InterfaceDeclaration;
    }

    @Override
    public boolean isArray() {
        return this.dimension > 0;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public ClassInfo getComponentType() {
        if (!this.isArray()) {
            throw new IllegalStateException();
        }
        TreeClassInfo bt = new TreeClassInfo(this.classTree, this.classFinder);
        int i = 0;
        while (i < this.dimension - 1) {
            bt = new TreeClassInfo(bt);
            ++i;
        }
        return bt;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ClassInfo)) {
            return false;
        }
        return this.getName().equals(((ClassInfo)obj).getName());
    }

    private String fullName() {
        String s;
        ClassInfo ci = (ClassInfo)this.classTree.getProperty(DECLARING_CLASS);
        if (ci != null) {
            s = String.valueOf(ci.getName()) + "$";
        } else {
            s = this.classFinder.getCurrentPackage();
            if (!s.equals("")) {
                s = String.valueOf(s) + ".";
            }
        }
        return String.valueOf(s) + this.classTree.getName();
    }

    private ClassInfo lookupClass(String s) {
        try {
            return this.classFinder.lookupClass(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private ClassInfo lookupClass(String s, ClassInfo c) {
        try {
            if (c != null) {
                return this.classFinder.lookupClass(s, c);
            }
            return this.classFinder.lookupClass(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private int getNestingLevel() {
        int result = -1;
        ClassInfo ci = this;
        while (!Modifier.isStatic(ci.getModifiers()) && (ci = ci.getDeclaringClass()) != null) {
            ++result;
        }
        return result;
    }

    private class MembersVisitor
    extends VisitorObject {
        MembersVisitor() {
            if (!TreeClassInfo.this.isArray()) {
                Iterator it = TreeClassInfo.this.classTree.getMembers().iterator();
                while (it.hasNext()) {
                    ((Node)it.next()).acceptVisitor(this);
                }
                if (!TreeClassInfo.this.classTree.hasProperty(TreeClassInfo.TREE_VISITED)) {
                    ClassInfo dc = TreeClassInfo.this.getDeclaringClass();
                    if (dc != null && !Modifier.isStatic(TreeClassInfo.this.getModifiers())) {
                        FieldDeclaration fd = new FieldDeclaration(1, new ReferenceType(dc.getName()), "this$" + TreeClassInfo.this.getNestingLevel(), null);
                        fd.acceptVisitor(this);
                        TreeClassInfo.this.classTree.getMembers().add(fd);
                    }
                    if (TreeClassInfo.this.constructors.size() == 0 && !TreeClassInfo.this.isInterface() && !TreeClassInfo.this.isPrimitive()) {
                        ConstructorInvocation ci = new ConstructorInvocation(null, null, true);
                        ConstructorDeclaration cd = new ConstructorDeclaration(1, TreeClassInfo.this.classTree.getName(), new LinkedList(), new LinkedList(), ci, new LinkedList());
                        cd.acceptVisitor(this);
                        TreeClassInfo.this.classTree.getMembers().add(cd);
                    }
                }
            }
        }

        @Override
        public Object visit(ClassDeclaration node) {
            node.setProperty(TreeClassInfo.DECLARING_CLASS, TreeClassInfo.this);
            TreeClassInfo.this.classes.add(TreeClassInfo.this.classFinder.addClassInfo(String.valueOf(TreeClassInfo.this.getName()) + "$" + node.getName(), node));
            return null;
        }

        @Override
        public Object visit(InterfaceDeclaration node) {
            node.setProperty(TreeClassInfo.DECLARING_CLASS, TreeClassInfo.this);
            TreeClassInfo.this.classes.add(TreeClassInfo.this.classFinder.addClassInfo(String.valueOf(TreeClassInfo.this.getName()) + "$" + node.getName(), node));
            return null;
        }

        @Override
        public Object visit(FieldDeclaration node) {
            TreeClassInfo.this.fields.put(node.getName(), new TreeFieldInfo(node, TreeClassInfo.this.classFinder, TreeClassInfo.this));
            return null;
        }

        @Override
        public Object visit(ConstructorDeclaration node) {
            if (node.getConstructorInvocation() == null) {
                ConstructorInvocation ci = new ConstructorInvocation(null, null, true);
                node.setConstructorInvocation(ci);
            }
            ClassInfo dc = TreeClassInfo.this.getDeclaringClass();
            if (!TreeClassInfo.this.classTree.hasProperty(TreeClassInfo.TREE_VISITED) && dc != null && !Modifier.isStatic(TreeClassInfo.this.getModifiers())) {
                ReferenceType t = new ReferenceType(dc.getName());
                node.getParameters().add(0, new FormalParameter(false, t, "param$0"));
            }
            if (dc != null && !Modifier.isStatic(TreeClassInfo.this.getModifiers())) {
                LinkedList<Identifier> l1 = new LinkedList<Identifier>();
                l1.add(new Identifier("this$" + TreeClassInfo.this.getNestingLevel()));
                LinkedList<Identifier> l2 = new LinkedList<Identifier>();
                l2.add(new Identifier("param$0"));
                SimpleAssignExpression sae = new SimpleAssignExpression(new QualifiedName(l1), new QualifiedName(l2));
                node.getStatements().add(0, sae);
            }
            TreeClassInfo.this.constructors.add(new TreeConstructorInfo(node, TreeClassInfo.this.classFinder, TreeClassInfo.this));
            return null;
        }

        @Override
        public Object visit(MethodDeclaration node) {
            LinkedList<TreeMethodInfo> l = (LinkedList<TreeMethodInfo>)TreeClassInfo.this.methods.get(node.getName());
            if (l == null) {
                l = new LinkedList<TreeMethodInfo>();
            }
            l.add(new TreeMethodInfo(node, TreeClassInfo.this.classFinder, TreeClassInfo.this));
            TreeClassInfo.this.methods.put(node.getName(), l);
            TreeClassInfo treeClassInfo = TreeClassInfo.this;
            treeClassInfo.methodCount = treeClassInfo.methodCount + 1;
            return null;
        }
    }
}

