/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.io.DataOutputStream;
import java.io.IOException;
import koala.dynamicjava.classfile.ClassIdentifier;
import koala.dynamicjava.classfile.ConstantPool;
import koala.dynamicjava.classfile.JVMUtilities;

public class InnerClassesEntry {
    private short innerClassInfoIndex;
    private short outerClassInfoIndex;
    private short innerNameIndex;
    private short innerClassAccessFlags;
    private final ConstantPool constantPool;

    public InnerClassesEntry(ConstantPool cp) {
        this.constantPool = cp;
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.innerClassInfoIndex);
        out.writeShort(this.outerClassInfoIndex);
        out.writeShort(this.innerNameIndex);
        out.writeShort(this.innerClassAccessFlags);
    }

    public void setInnerClassInfo(String cname) {
        cname = JVMUtilities.getName(cname);
        this.innerClassInfoIndex = this.constantPool.put(new ClassIdentifier(cname));
    }

    public void setOuterClassInfo(String cname) {
        cname = JVMUtilities.getName(cname);
        this.outerClassInfoIndex = this.constantPool.put(new ClassIdentifier(cname));
    }

    public void setInnerName(String name) {
        this.innerNameIndex = this.constantPool.putUTF8(name);
    }

    public void setInnerClassAccessFlags(short af) {
        this.innerClassAccessFlags = af;
    }
}

