/*
 * Decompiled with CFR 0.152.
 */
package interpreterDJava;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.InterpreterException;
import koala.dynamicjava.interpreter.TreeInterpreter;
import koala.dynamicjava.parser.wrapper.JavaCCParserFactory;
import org.jedit.JEditTextArea;
import org.jedit.JavaTokenMarker;

public class JavaEditor
extends JPanel
implements Scrollable {
    private static final String CODE_CORRECT = "Code correct";
    protected JEditTextArea textFormule;
    protected JLabel status = new JLabel("Code correct");
    private final JavaTokenMarker javaTokenMarker;
    protected String varAssign;
    private final JLabel labelPopup = new JLabel();
    private boolean codeValid = true;

    public JavaEditor() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 2, 1);
        this.textFormule = new JEditTextArea();
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        this.add((Component)this.textFormule, c);
        this.javaTokenMarker = new JavaTokenMarker();
        this.textFormule.setTokenMarker(this.javaTokenMarker);
        this.textFormule.setFont(new JTextField().getFont());
        c.fill = 2;
        ++c.gridy;
        c.weighty = 0.0;
        this.add((Component)this.status, c);
        this.varAssign = "$$$$$$";
        this.javaTokenMarker.addKeyword(this.varAssign, (byte)4);
    }

    protected void setCodeValid(boolean codeValid) {
        this.codeValid = codeValid;
    }

    protected final boolean isCodeValid() {
        return this.codeValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVarAssign(String s) {
        String string = this.varAssign;
        synchronized (string) {
            this.javaTokenMarker.removeKeyword(this.varAssign);
            if (this.varAssign.trim().length() != 0) {
                this.varAssign = s;
                this.javaTokenMarker.addKeyword(this.varAssign, (byte)4);
            }
        }
    }

    public void addNewLitteral(String s) {
        this.javaTokenMarker.addKeyword(s, (byte)4);
    }

    public Object checkFormule(String formule, String varCallName) {
        File f;
        BufferedReader bR;
        block10: {
            bR = null;
            f = null;
            try {
                if (formule.trim().length() != 0) break block10;
                this.status.setText(CODE_CORRECT);
                return null;
            }
            catch (Exception e) {
                if (e instanceof InterpreterException) {
                    int in;
                    String m = "";
                    InterpreterException ex = (InterpreterException)e;
                    System.out.println(ex.getMessage());
                    if (ex.getSourceInformation() != null) {
                        m = String.valueOf(m) + " ligne:" + ex.getSourceInformation().getLine();
                    }
                    if ((in = (m = String.valueOf(m) + ex.getMessage()).indexOf(10)) > 0) {
                        m = m.substring(0, in);
                    }
                    this.setCodeValid(false);
                    this.status.setText(m);
                } else {
                    this.setCodeValid(false);
                    System.err.println("err-----");
                    e.printStackTrace();
                }
                this.setCodeValid(false);
                return null;
            }
        }
        File dParent = new File(System.getProperty("user.home"), ".java/ilm/Interpreter/");
        dParent.mkdir();
        f = new File(dParent, "CalculVariable" + varCallName + ".txt");
        TreeInterpreter interpreter = new TreeInterpreter(new JavaCCParserFactory());
        BufferedWriter bW = new BufferedWriter(new FileWriter(f));
        bW.write(formule);
        bW.flush();
        bW.close();
        bR = new BufferedReader(new FileReader(f));
        Object interpreterResult = interpreter.interpret(bR, f.getAbsolutePath());
        bR.close();
        try {
            this.status.setText("Code correct, valeur de retour = " + interpreter.getVariable(varCallName).toString());
            this.setCodeValid(true);
            return interpreter.getVariable(varCallName);
        }
        catch (IllegalStateException iSE) {
            if (interpreterResult != null) {
                this.status.setText("Code correct, valeur de retour = " + interpreterResult.toString());
                this.setCodeValid(true);
                bR.close();
                return interpreterResult;
            }
            this.status.setText("Aucune valeur de retour");
            this.setCodeValid(false);
            return null;
        }
    }

    protected void defineVariable(Interpreter interpret, BufferedWriter b, String varName, Object value) {
        if (value == null) {
            try {
                b.write("float " + varName + " = 1.0F;\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (value instanceof Integer) {
            try {
                b.write("int " + varName + " = " + value + ";\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (value instanceof Float) {
            try {
                b.write("float " + varName + " = " + value + "F;\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (value instanceof Double) {
            try {
                b.write("double " + varName + " = " + value + ";\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            interpret.defineVariable(varName, value);
        }
    }

    public int getSelectionStart() {
        return this.textFormule.getSelectionStart();
    }

    public String getText() {
        return this.textFormule.getText();
    }

    public void setText(String string) {
        this.textFormule.setText(string);
        this.textFormule.setCaretPosition(0);
    }

    public void setEditable(boolean b) {
        this.textFormule.setEditable(b);
        this.textFormule.setBackground(Color.RED);
        this.textFormule.setCaretVisible(b);
        this.textFormule.setCaretBlinkEnabled(b);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height / 10;
            }
            case 0: {
                return visibleRect.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 1: {
                return visibleRect.height;
            }
            case 0: {
                return visibleRect.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }
}

