/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.touch;

public abstract class Animator {
    long duration = 10000L;
    private int repeatCount = 1;
    private long startTime;
    boolean running = false;

    public boolean pulse(long totalElapsed) {
        if (!this.isRunning()) {
            return true;
        }
        long dur = this.duration;
        double rep = this.repeatCount;
        if (totalElapsed < (dur = (long)((double)dur * rep))) {
            this.process(totalElapsed);
            return false;
        }
        this.process(dur);
        this.stop();
        return true;
    }

    private void process(long timeElapsed) {
        if (!this.running) {
            return;
        }
        if (timeElapsed >= this.duration) {
            this.process(1.0f, timeElapsed);
        } else {
            float fraction;
            if (this.duration == 0L) {
                fraction = 1.0f;
            } else {
                double iterationCount = (double)timeElapsed / (double)this.duration;
                fraction = (float)(iterationCount %= 1.0);
            }
            this.process(fraction, timeElapsed);
        }
    }

    public abstract void process(float var1, long var2);

    public void setStartTime(long currentTimeMillis) {
        this.startTime = currentTimeMillis;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void stop() {
        this.running = false;
    }

    public void start() {
        this.running = true;
    }

    public boolean isRunning() {
        return this.running;
    }
}

