/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.awt.AWTKeyStroke;
import java.awt.Insets;
import java.util.Collections;
import java.util.Set;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.DefaultEditorKit;

public class ITextArea
extends JTextArea {
    private boolean tabIsTraversal;
    private Set<AWTKeyStroke> forwardKey;
    private Set<AWTKeyStroke> backwardKey;

    public ITextArea() {
        this((String)null);
    }

    public ITextArea(String text) {
        this(text, 0, 0);
    }

    public ITextArea(int rows, int cols) {
        this(null, rows, cols);
    }

    public ITextArea(String text, int rows, int cols) {
        super(text, rows, cols);
        JTextField tf = new JTextField();
        this.setBorder(tf.getBorder());
        this.setFont(tf.getFont());
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.tabIsTraversal = false;
        this.setTabIsFocusTraversal(true);
    }

    @Override
    public Insets getInsets() {
        Insets sup = super.getInsets();
        if (!UIManager.getLookAndFeel().getID().equals("Aqua")) {
            return sup;
        }
        Insets margin = this.getMargin();
        return new Insets(sup.top + margin.top, sup.left + margin.left, sup.bottom + margin.bottom, sup.right + margin.right);
    }

    public final boolean isTabIsFocusTraversal() {
        return this.tabIsTraversal;
    }

    public final void setTabIsFocusTraversal(boolean b) {
        if (this.isTabIsFocusTraversal() != b) {
            String typeTab = "typeTab";
            if (b) {
                this.forwardKey = this.getOwnTraversalKeys(0);
                this.backwardKey = this.getOwnTraversalKeys(1);
                this.setFocusTraversalKeys(0, Collections.singleton(KeyStroke.getKeyStroke(9, 0)));
                this.setFocusTraversalKeys(1, Collections.singleton(KeyStroke.getKeyStroke(9, 64)));
                this.getInputMap().put(KeyStroke.getKeyStroke(9, 640), "typeTab");
                this.getActionMap().put("typeTab", new DefaultEditorKit.InsertTabAction());
            } else {
                this.setFocusTraversalKeys(0, this.forwardKey);
                this.setFocusTraversalKeys(1, this.backwardKey);
                this.getActionMap().remove("typeTab");
            }
            this.tabIsTraversal = b;
        }
    }

    private final Set<AWTKeyStroke> getOwnTraversalKeys(int id) {
        return this.areFocusTraversalKeysSet(id) ? this.getFocusTraversalKeys(id) : null;
    }
}

