/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users.rights;

import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.rights.TableAllRights;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.utils.CompareUtils;

public class UserRights {
    private final int userID;

    public UserRights(int userID) {
        this.userID = userID;
    }

    public final boolean haveRight(String code) {
        return this.haveRight(code, null);
    }

    public final boolean haveRight(String code, String object) {
        return this.haveRight(code, object, CompareUtils.OBJECT_EQ);
    }

    public boolean haveRight(String code, String object, CompareUtils.Equalizer<? super String> objectMatcher) {
        return UserRightsManager.getInstance().haveRight(this.userID, code, object, objectMatcher);
    }

    public final boolean canDelete(SQLTable table) {
        return TableAllRights.hasRight(this, "DELETE_ROW", table);
    }

    public final boolean canModify(SQLTable table) {
        return TableAllRights.hasRight(this, "UPDATE_ROW", table);
    }

    public final boolean canAdd(SQLTable table) {
        return TableAllRights.hasRight(this, "INSERT_ROW", table);
    }

    public final boolean canView(SQLTable table) {
        return TableAllRights.hasRight(this, "SELECT_ROW", table);
    }
}

