/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.request;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLFilter;
import org.openconcerto.sql.model.SQLFilterListener;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.BaseFillSQLRequest;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.CopyUtils;
import org.openconcerto.utils.Tuple2;

public abstract class FilteredFillSQLRequest
extends BaseFillSQLRequest {
    private Tuple2<Set<SQLRow>, Path> filterInfo;
    private boolean filterEnabled;
    private final SQLFilterListener filterListener = new SQLFilterListener(){};

    public FilteredFillSQLRequest(SQLTable primaryTable, Where w) {
        super(primaryTable, w);
        this.filterInfo = Tuple2.create(null, null);
        this.setFilterEnabled(true);
    }

    public FilteredFillSQLRequest(FilteredFillSQLRequest req) {
        super(req);
        this.filterInfo = req.filterInfo;
        this.setFilterEnabled(req.filterEnabled);
    }

    protected final SQLFilter getFilter() {
        return Configuration.getInstance().getFilter();
    }

    public final void setFilterEnabled(boolean b) {
        this.filterEnabled = b;
        if (this.filterEnabled) {
            this.getFilter().addListener(this.filterListener);
        } else {
            this.getFilter().rmListener(this.filterListener);
        }
        this.updateFilterWhere();
    }

    private void updateFilterWhere() {
        if (this.filterEnabled) {
            this.setFilterWhere(this.getFilter().getLeaf(), this.getFilter().getPath(this.getPrimaryTable()));
        } else {
            this.setFilterWhere(null, null);
        }
    }

    private synchronized void setFilterWhere(Set<SQLRow> w, Path p) {
        if (!CompareUtils.equals(this.filterInfo.get0(), w) || !CompareUtils.equals(this.filterInfo.get1(), p)) {
            this.filterInfo = w == null || p == null ? Tuple2.create(null, null) : Tuple2.create(CopyUtils.copy(w), new Path(p));
            this.fireWhereChange();
        }
    }

    public final SQLRowValues getValues(int id) {
        List<SQLRowValues> res = this.getValues(new Where((FieldRef)this.getPrimaryTable().getKey(), "=", id));
        if (res.size() > 1) {
            throw new IllegalStateException("there's more than one line which has ID " + id + " for " + this + " : " + res);
        }
        return CollectionUtils.getFirst(res);
    }

    public final List<SQLRowValues> getValues() {
        return this.getValues(null);
    }

    protected List<SQLRowValues> getValues(Where w) {
        return this.getFetcher(w).fetch();
    }

    @Override
    protected SQLSelect transformSelect(SQLSelect sel) {
        Tuple2<Set<SQLRow>, Path> filterInfo = this.getFilterInfo();
        if (filterInfo.get1() != null) {
            Set<SQLRow> filterRow = filterInfo.get0();
            HashSet<SQLTable> tables = new HashSet<SQLTable>();
            ArrayList<Integer> ids = new ArrayList<Integer>(filterRow.size());
            for (SQLRow r : filterRow) {
                tables.add(r.getTable());
                ids.add(r.getID());
            }
            SQLTable filterTable = (SQLTable)CollectionUtils.getSole(tables);
            if (filterTable == null) {
                throw new IllegalStateException("not 1 table: " + filterRow);
            }
            Path path = filterInfo.get1();
            String lastAlias = sel.assurePath(this.getPrimaryTable().getName(), path);
            if (filterTable != sel.getTable(lastAlias)) {
                throw new IllegalStateException("table mismatch: " + filterRow + " is not from " + lastAlias + ": " + sel.getTable(lastAlias));
            }
            sel.andWhere(new Where(new AliasedField(filterTable.getKey(), lastAlias), ids));
        }
        return super.transformSelect(sel);
    }

    public final Set<SQLRow> getFilterRows() {
        return this.getFilterInfo().get0();
    }

    private final synchronized Tuple2<Set<SQLRow>, Path> getFilterInfo() {
        return this.filterInfo;
    }

    public final Where getInstanceWhere() {
        return this.getFetcher(null).getReq().getWhere();
    }
}

