/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntaxH2;
import org.openconcerto.sql.model.SQLSyntaxMS;
import org.openconcerto.sql.model.SQLSyntaxMySQL;
import org.openconcerto.sql.model.SQLSyntaxPG;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLType;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.utils.CollectionMap;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.IClosure;
import org.openconcerto.utils.cc.ITransformer;

public abstract class SQLSyntax {
    private static final Map<SQLSystem, SQLSyntax> instances = new HashMap<SQLSystem, SQLSyntax>();
    private final SQLSystem sys;
    protected final CollectionMap<Class, String> typeNames;
    private static final Set<String> nonStandardTimeFunctions;
    public static final List<String> INFO_SCHEMA_NAMES_KEYS;

    static {
        SQLSyntax.register(new SQLSyntaxPG());
        SQLSyntax.register(new SQLSyntaxH2());
        SQLSyntax.register(new SQLSyntaxMySQL());
        SQLSyntax.register(new SQLSyntaxMS());
        nonStandardTimeFunctions = CollectionUtils.createSet("now()", "transaction_timestamp()", "current_timestamp()");
        INFO_SCHEMA_NAMES_KEYS = Arrays.asList("TABLE_SCHEMA", "TABLE_NAME", "COLUMN_NAME");
    }

    private static void register(SQLSyntax s) {
        instances.put(s.getSystem(), s);
    }

    public static final SQLSyntax get(DBStructureItem<?> sql) {
        return SQLSyntax.get(sql.getServer().getSQLSystem());
    }

    public static final SQLSyntax get(SQLSystem system) {
        SQLSyntax res = instances.get((Object)system);
        if (res == null) {
            throw new IllegalArgumentException("unsupported system: " + (Object)((Object)system));
        }
        return res;
    }

    protected SQLSyntax(SQLSystem sys) {
        this.sys = sys;
        this.typeNames = new CollectionMap(new HashSet(4));
    }

    public final Set<String> getTypeNames(Class clazz) {
        return (Set)this.typeNames.getNonNull(clazz);
    }

    public final SQLSystem getSystem() {
        return this.sys;
    }

    public abstract String getAuto();

    public String getIDType() {
        return " int";
    }

    public String getPrimaryIDDefinitionShort() {
        return this.getAuto();
    }

    public final String getPrimaryIDDefinition() {
        return String.valueOf(this.getPrimaryIDDefinitionShort()) + " PRIMARY KEY";
    }

    public String getArchiveType() {
        return " int";
    }

    public String getArchiveDefinition() {
        return String.valueOf(this.getArchiveType()) + " DEFAULT 0 NOT NULL";
    }

    public final String getOrderType() {
        return " DECIMAL(" + this.getOrderPrecision() + "," + this.getOrderScale() + ")";
    }

    public final int getOrderPrecision() {
        return 16;
    }

    public final int getOrderScale() {
        return 8;
    }

    public final Object getOrderDefault() {
        return null;
    }

    public final String getOrderDefinition() {
        return String.valueOf(this.getOrderType()) + " DEFAULT " + this.getOrderDefault() + " UNIQUE";
    }

    public String getFK(String constraintPrefix, List<String> fk, SQLName refTable, List<String> referencedFields, Link.Rule updateRule, Link.Rule deleteRule) {
        String onUpdate = updateRule == null ? "" : " ON UPDATE " + this.getRuleSQL(updateRule);
        String onDelete = deleteRule == null ? "" : " ON DELETE " + this.getRuleSQL(deleteRule);
        return String.valueOf(SQLSelect.quote("CONSTRAINT %i FOREIGN KEY ( " + SQLSyntax.quoteIdentifiers(fk) + " ) REFERENCES %i ", String.valueOf(constraintPrefix) + CollectionUtils.join(fk, "__") + "_fkey", refTable)) + "( " + SQLSyntax.quoteIdentifiers(referencedFields) + " )" + onUpdate + onDelete;
    }

    protected String getRuleSQL(Link.Rule r) {
        return r.asString();
    }

    public String getCreateIndex(String indexSuffix, SQLName tableName, List<String> fields) {
        return this.getCreateIndex(false, String.valueOf(tableName.getName()) + "_" + CollectionUtils.join(fields, "__") + indexSuffix, tableName, fields);
    }

    public final String getCreateIndex(boolean unique, String indexName, SQLName tableName, List<String> fields) {
        String res = "CREATE" + (unique ? " UNIQUE" : "") + " INDEX " + SQLBase.quoteIdentifier(indexName) + " ON " + tableName.quote();
        return String.valueOf(res) + " (" + SQLSyntax.quoteIdentifiers(fields) + ");";
    }

    public String getCreateTableSuffix() {
        return "";
    }

    protected final boolean getNullable(SQLField f) {
        return !Boolean.FALSE.equals(f.isNullable());
    }

    public final String getNullableClause(boolean nullable) {
        return nullable ? " " : " NOT NULL ";
    }

    protected final String getDefault(SQLField f, String sqlType) {
        SQLSyntax fs = f.getServer().getSQLSystem().getSyntax();
        String stdDefault = fs.transfDefaultSQL2Common(f);
        if (stdDefault == null || !this.supportsDefault(sqlType)) {
            return null;
        }
        Tuple2<Boolean, String> cast = fs.getCast();
        String castless = cast == null ? stdDefault : SQLSyntax.remove(stdDefault, fs.getTypeNames(f.getType().getJavaType()), cast.get0(), cast.get1());
        return this.transfDefault(f, castless);
    }

    private static String remove(String s, Collection<String> substrings, boolean leading, String sep) {
        String lowerS = s.toLowerCase();
        String typeCast = null;
        for (String syn : substrings) {
            typeCast = syn.toLowerCase();
            typeCast = leading ? String.valueOf(typeCast) + sep : String.valueOf(sep) + typeCast;
            if (leading ? lowerS.startsWith(typeCast) : lowerS.endsWith(typeCast)) break;
            typeCast = null;
        }
        if (typeCast == null) {
            return s;
        }
        if (leading) {
            return s.substring(typeCast.length());
        }
        return s.substring(0, s.length() - typeCast.length());
    }

    public final String getDefaultClause(String def) {
        if (def == null) {
            return " ";
        }
        return " DEFAULT " + def;
    }

    public final String getType(SQLField f) {
        String sqlType;
        SQLSyntax fs = f.getServer().getSQLSystem().getSyntax();
        SQLType t = f.getType();
        String typeName = t.getTypeName().toLowerCase();
        if (typeName.contains("clob")) {
            sqlType = "text";
        } else if (Date.class.isAssignableFrom(t.getJavaType())) {
            sqlType = fs.isAutoDate(f) && this.getAutoDateType(f) != null ? this.getAutoDateType(f) : (typeName.contains("datetime") || typeName.contains("timestamp") ? String.valueOf(this.getDateAndTimeType()) + (this.getSystem().isFractionalSecondsSupported() && t.getDecimalDigits() != null ? "(" + t.getDecimalDigits() + ")" : "") : typeName);
        } else if (t.getJavaType() == String.class) {
            if (typeName.contains("text") || typeName.contains("clob")) {
                sqlType = "text";
            } else {
                String type = typeName.contains("var") ? "varchar" : "char";
                int size = t.getSize();
                if (size < Integer.MAX_VALUE) {
                    sqlType = String.valueOf(type) + "(" + size + ")";
                } else {
                    Log.get().warning("Unbounded varchar for " + f.getSQLName());
                    if (this.getSystem() == SQLSystem.MYSQL) {
                        throw new IllegalStateException("MySQL doesn't support unbounded varchar and might truncate data if reducing size of " + f.getSQLName());
                    }
                    sqlType = type;
                }
            }
        } else {
            sqlType = t.getJavaType() == BigDecimal.class ? "DECIMAL(" + t.getSize() + "," + t.getDecimalDigits() + ")" : (t.getJavaType() == Boolean.class ? this.getBooleanType() : (Number.class.isAssignableFrom(t.getJavaType()) ? (Double.class.isAssignableFrom(t.getJavaType()) ? "double precision" : (Float.class.isAssignableFrom(t.getJavaType()) ? "real" : typeName.replace("unsigned", "").replace("int2", "smallint").replace("int4", "int").replace("int8", "bigint").trim())) : typeName));
        }
        return sqlType;
    }

    private boolean isAutoDate(SQLField f) {
        if (f.getDefaultValue() == null) {
            return false;
        }
        String def = ((String)f.getDefaultValue()).toLowerCase();
        return Date.class.isAssignableFrom(f.getType().getJavaType()) && (def.contains("now") || def.contains("current_"));
    }

    protected String getAutoDateType(SQLField f) {
        return null;
    }

    public String getDateAndTimeType() {
        return "timestamp";
    }

    public String getBooleanType() {
        return "boolean";
    }

    protected boolean supportsDefault(String sqlType) {
        return true;
    }

    protected String transfDefault(SQLField f, String castless) {
        return castless;
    }

    private String transfDefaultSQL2Common(SQLField f) {
        String defaultVal = this.transfDefaultJDBC2SQL(f);
        if (defaultVal != null && Date.class.isAssignableFrom(f.getType().getJavaType()) && nonStandardTimeFunctions.contains(defaultVal.trim().toLowerCase())) {
            return "CURRENT_TIMESTAMP";
        }
        if (defaultVal != null && Boolean.class.isAssignableFrom(f.getType().getJavaType())) {
            return defaultVal.toUpperCase();
        }
        return defaultVal;
    }

    public String transfDefaultJDBC2SQL(SQLField f) {
        return (String)f.getDefaultValue();
    }

    protected abstract Tuple2<Boolean, String> getCast();

    protected final String setDefault(SQLField field, String defaut) {
        if (defaut == null) {
            return SQLSelect.quote("ALTER %n DROP DEFAULT", field);
        }
        return SQLSelect.quote("ALTER COLUMN %n SET DEFAULT " + defaut, field);
    }

    public abstract List<String> getAlterField(SQLField var1, Set<SQLField.Properties> var2, String var3, String var4, Boolean var5);

    SQLBase createBase(SQLServer server, String name, String login, String pass, IClosure<SQLDataSource> dsInit) {
        return new SQLBase(server, name, login, pass, dsInit);
    }

    public boolean supportMultiAlterClause() {
        return true;
    }

    public abstract String getNullIsDataComparison(String var1, boolean var2, String var3);

    public abstract String getColumnsQuery(SQLBase var1, Set<String> var2, Set<String> var3);

    public abstract String getFunctionQuery(SQLBase var1, Set<String> var2);

    public abstract List<Map<String, Object>> getConstraints(SQLBase var1, Set<String> var2, Set<String> var3) throws SQLException;

    protected static final String quoteStrings(final SQLBase b, Collection<String> c) {
        return CollectionUtils.join(c, ", ", new ITransformer<String, String>(){

            @Override
            public String transformChecked(String s) {
                return b.quoteString(s);
            }
        });
    }

    public static final String quoteIdentifiers(Collection<String> c) {
        return CollectionUtils.join(c, ", ", new ITransformer<String, String>(){

            @Override
            public String transformChecked(String s) {
                return SQLBase.quoteIdentifier(s);
            }
        });
    }

    public static final String getSchemaUniqueName(String tableName, String name) {
        return name.startsWith(tableName) ? name : String.valueOf(tableName) + "_" + name;
    }

    public abstract String getTriggerQuery(SQLBase var1, Set<String> var2, Set<String> var3) throws SQLException;

    public String getUpdate(SQLTable t, List<String> tables, Map<String, String> setPart) throws UnsupportedOperationException {
        if (tables.size() > 0) {
            throw new UnsupportedOperationException();
        }
        return t.getSQLName() + "\nSET " + CollectionUtils.join(setPart.entrySet(), ",\n", new ITransformer<Map.Entry<String, String>, String>(){

            @Override
            public String transformChecked(Map.Entry<String, String> input) {
                return String.valueOf(input.getKey()) + " = " + input.getValue();
            }
        });
    }
}

