/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;

public class SQLInjector {
    private final SQLTable tableSrc;
    private final SQLTable tableDest;
    private final ArrayList<SQLField> from = new ArrayList();
    private final ArrayList<SQLField> to = new ArrayList();
    private Map<SQLField, Object> values = new HashMap<SQLField, Object>();
    private static Map<SQLTable, Map<SQLTable, SQLInjector>> injectors = new HashMap<SQLTable, Map<SQLTable, SQLInjector>>();
    private static final SQLSystem dbSystem = Configuration.getInstance().getBase().getServer().getSQLSystem();

    public SQLInjector(DBRoot r, String src, String dest) {
        this(r.findTable(src), r.findTable(dest));
    }

    public SQLInjector(SQLTable src, SQLTable dest) {
        this.tableDest = dest;
        this.tableSrc = src;
        Map<SQLTable, SQLInjector> srcs = injectors.get(src);
        if (srcs == null) {
            srcs = new HashMap<SQLTable, SQLInjector>();
            injectors.put(src, srcs);
        }
        srcs.put(dest, this);
    }

    public SQLRowValues createRowValuesFrom(int idSrc) {
        return this.createRowValuesFrom(this.getSource().getRow(idSrc));
    }

    public SQLRowValues createRowValuesFrom(SQLRowAccessor srcRow) {
        if (!srcRow.getTable().equals(this.getSource())) {
            throw new IllegalArgumentException("Row not from source table : " + srcRow);
        }
        SQLRowValues rowVals = new SQLRowValues(this.getDestination());
        for (SQLField field : this.values.keySet()) {
            rowVals.put(field.getName(), this.values.get(field));
        }
        int i = 0;
        while (i < this.getFrom().size()) {
            SQLField sqlFieldFrom = this.getFrom().get(i);
            SQLField sqlFieldTo = this.getTo().get(i);
            Object o = srcRow.getObject(sqlFieldFrom.getName());
            if (dbSystem == SQLSystem.H2 && sqlFieldFrom.getType().getJavaType() == Long.class && sqlFieldTo.getType().getJavaType() == Integer.class) {
                rowVals.put(sqlFieldTo.getName(), ((Long)o).intValue());
            } else {
                rowVals.put(sqlFieldTo.getName(), o);
            }
            ++i;
        }
        return rowVals;
    }

    protected final void mapDefaultValues(SQLField fieldDest, Object defaultValue) {
        if (!fieldDest.getTable().getName().equalsIgnoreCase(this.tableDest.getName())) {
            throw new IllegalArgumentException("SQLField " + fieldDest + " is not a field of table " + this.tableDest);
        }
        this.values.put(fieldDest, defaultValue);
    }

    protected final void map(SQLField from, SQLField to) throws IllegalArgumentException {
        if (!from.getTable().getName().equalsIgnoreCase(this.tableSrc.getName())) {
            throw new IllegalArgumentException("SQLField " + from + " is not a field of table " + this.tableSrc);
        }
        if (!to.getTable().getName().equalsIgnoreCase(this.tableDest.getName())) {
            throw new IllegalArgumentException("SQLField " + to + " is not a field of table " + this.tableDest);
        }
        int index = this.from.indexOf(from);
        if (index > 0) {
            this.to.set(index, to);
        } else {
            this.from.add(from);
            this.to.add(to);
        }
    }

    protected final void remove(SQLField from, SQLField to) throws IllegalArgumentException {
        if (!from.getTable().getName().equalsIgnoreCase(this.tableSrc.getName())) {
            throw new IllegalArgumentException("SQLField " + from + " is not a field of table " + this.tableSrc);
        }
        if (!to.getTable().getName().equalsIgnoreCase(this.tableDest.getName())) {
            throw new IllegalArgumentException("SQLField " + to + " is not a field of table " + this.tableDest);
        }
        int index = this.from.indexOf(from);
        if (this.to.get(index).getName().equalsIgnoreCase(to.getName())) {
            this.to.remove(to);
            this.from.remove(from);
        }
    }

    public void createDefaultMap() {
        for (SQLField field : this.tableSrc.getContentFields()) {
            if (!this.tableDest.contains(field.getName())) continue;
            this.map(field, this.tableDest.getField(field.getName()));
        }
    }

    public ArrayList<SQLField> getFrom() {
        return this.from;
    }

    public ArrayList<SQLField> getTo() {
        return this.to;
    }

    public static SQLInjector getInjector(SQLTable src, SQLTable dest) {
        Map<SQLTable, SQLInjector> m = injectors.get(src);
        if (m != null) {
            return m.get(dest);
        }
        return null;
    }

    public SQLTable getDestination() {
        return this.tableDest;
    }

    public SQLTable getSource() {
        return this.tableSrc;
    }
}

