/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.utils.cc.IClosure;

public class PGSQLBase
extends SQLBase {
    private static final Pattern backslashQuote = Pattern.compile("\\\\");

    PGSQLBase(SQLServer server, String name, String login, String pass, IClosure<SQLDataSource> dsInit) {
        super(server, name, login, pass, dsInit);
    }

    @Override
    public final String quoteString(String s) {
        String res = super.quoteString(s);
        Matcher matcher = backslashQuote.matcher(res);
        return matcher.find() ? "E" + matcher.replaceAll("\\\\\\\\") : res;
    }
}

