/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.utils.EnumOrderedSet;

public class DBStructureItemDB
extends DBStructureItem<DBStructureItemDB> {
    private final DBStructureItemJDBC jdbc;

    static DBStructureItemDB create(DBStructureItemJDBC jdbc) {
        if (DBStructureItemDB.isOfLevel(jdbc, DBSystemRoot.class)) {
            return new DBSystemRoot(jdbc);
        }
        if (DBStructureItemDB.isOfLevel(jdbc, DBRoot.class)) {
            return new DBRoot(jdbc);
        }
        if (jdbc.getServer().getSQLSystem().getLevels().contains(jdbc.getLevel())) {
            return new DBStructureItemDB(jdbc);
        }
        return null;
    }

    private static boolean isOfLevel(DBStructureItemJDBC jdbc, Class<? extends DBStructureItemDB> c) {
        return jdbc.getServer().getSQLSystem().getDBLevel(c).equals((Object)jdbc.getLevel());
    }

    protected DBStructureItemDB(DBStructureItemJDBC jdbc) {
        super(DBStructureItemDB.getDB(jdbc.getParent()), jdbc.getName());
        this.jdbc = jdbc;
    }

    @Override
    public final DBStructureItemJDBC getJDBC() {
        return this.jdbc;
    }

    @Override
    protected DBStructureItemDB getDB() {
        return this;
    }

    @Override
    public DBStructureItemDB getChild(String name) {
        DBStructureItemJDBC nonNullDBParent = this.getJDBC().getNonNullDBParent();
        if (nonNullDBParent == null) {
            return null;
        }
        return DBStructureItemDB.getDB(nonNullDBParent.getChild(name));
    }

    @Override
    public Set<String> getChildrenNames() {
        DBStructureItemJDBC nonNullDBParent = this.getJDBC().getNonNullDBParent();
        if (nonNullDBParent == null) {
            return Collections.emptySet();
        }
        return nonNullDBParent.getChildrenNames();
    }

    public final void addChildrenListener(PropertyChangeListener l) {
        DBStructureItemJDBC nonNullDBParent = this.getJDBC().getNonNullDBParent();
        if (nonNullDBParent != null) {
            nonNullDBParent.addChildrenListener(l);
        }
    }

    public final void rmChildrenListener(PropertyChangeListener l) {
        DBStructureItemJDBC nonNullDBParent = this.getJDBC().getNonNullDBParent();
        if (nonNullDBParent != null) {
            nonNullDBParent.rmChildrenListener(l);
        }
    }

    @Override
    protected final EnumOrderedSet<HierarchyLevel> getLevels() {
        return this.getServer().getSQLSystem().getLevels();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getJDBC();
    }
}

