/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItemDB;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBStructureItemNotFound;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.utils.EnumOrderedSet;

public abstract class DBStructureItem<D extends DBStructureItem<D>> {
    private final String name;
    private final D parent;

    protected DBStructureItem(D parent, String name) {
        this.name = name;
        this.parent = parent;
    }

    public final String getName() {
        return this.name;
    }

    protected void onDrop() {
    }

    private D thisAsD() {
        return (D)this;
    }

    public final D getParent() {
        return this.parent;
    }

    public abstract D getChild(String var1);

    public final D getCheckedChild(String name) {
        if (this.getChildrenNames().contains(name)) {
            return this.getChild(name);
        }
        throw new DBStructureItemNotFound(String.valueOf(name) + " is not a child of " + this);
    }

    public abstract Set<String> getChildrenNames();

    protected final Set<D> getChildren() {
        HashSet<D> res = new HashSet<D>();
        for (String n : this.getChildrenNames()) {
            res.add(this.getChild(n));
        }
        return res;
    }

    public final boolean contains(String childName) {
        return this.getChildrenNames().contains(childName);
    }

    public final D getDescendant(SQLName name) {
        D child = this.getCheckedChild(name.getFirst());
        if (name.getItemCount() == 1) {
            return child;
        }
        return ((DBStructureItem)child).getDescendant(name.getRest());
    }

    public final <T extends D> Set<T> getDescendants(Class<T> clazz) {
        int hops = this.getHopsTo(clazz);
        if (hops < 0) {
            throw new IllegalArgumentException(clazz + " is not under " + this);
        }
        if (hops == 0) {
            return Collections.singleton((DBStructureItem)clazz.cast(this));
        }
        HashSet<T> res = new HashSet<T>();
        for (DBStructureItem child : this.getChildren()) {
            res.addAll(child.getDescendants(clazz));
        }
        return res;
    }

    public final <T extends D> T getAncestor(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return (T)((DBStructureItem)clazz.cast(this));
        }
        if (this.getParent() == null) {
            return null;
        }
        return ((DBStructureItem)this.getParent()).getAncestor(clazz);
    }

    private final D getAncestor(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("negative level: " + level);
        }
        if (level == 0) {
            return this.thisAsD();
        }
        if (this.getParent() == null) {
            throw new IllegalArgumentException(this + " is the root, can't go up of " + level);
        }
        return super.getAncestor(level - 1);
    }

    public final List<D> getAncestors() {
        ArrayList<D> res = new ArrayList<D>();
        D anc = this.thisAsD();
        while (anc != null) {
            res.add(0, anc);
            anc = ((DBStructureItem)anc).getParent();
        }
        return res;
    }

    public final SQLServer getServer() {
        return this.getAnc(SQLServer.class);
    }

    public final DBRoot getDBRoot() {
        return this.getDB().getAncestor(DBRoot.class);
    }

    public final DBSystemRoot getDBSystemRoot() {
        return this.getDB().getAncestor(DBSystemRoot.class);
    }

    public final D getContextualDescendant(SQLName name, int level) {
        if (name.getItemCount() < level) {
            throw new IllegalArgumentException(name + " is too short to go down of " + level);
        }
        return ((DBStructureItem)this.getAncestor(name.getItemCount() - level)).getDescendant(name);
    }

    public final D getContextualDescendant(SQLName name, Class<? extends DBStructureItemJDBC> clazz) {
        int hops = this.getHopsTo(clazz);
        if (hops < 0) {
            throw new IllegalArgumentException(clazz + "is not under " + this);
        }
        return this.getContextualDescendant(name, hops);
    }

    public final <T extends DBStructureItemJDBC> T getDesc(SQLName name, Class<T> clazz) {
        return (T)DBStructureItem.getJDBC(this.getDB().getContextualDescendant(name, clazz));
    }

    public final <T extends DBStructureItemJDBC> T getDesc(String name, Class<T> clazz) {
        return this.getDesc(SQLName.parse(name), clazz);
    }

    public final <T extends DBStructureItemJDBC> T getDescLenient(SQLName name, Class<T> clazz) {
        try {
            return this.getDesc(name, clazz);
        }
        catch (DBStructureItemNotFound e) {
            return null;
        }
    }

    public final <T extends DBStructureItem> Set<T> getDescs(Class<T> clazz) {
        if (DBStructureItemDB.class.isAssignableFrom(clazz)) {
            return this.getDB().getDescendants(clazz.asSubclass(DBStructureItemDB.class));
        }
        return this.getJDBC().getDescendants(clazz.asSubclass(DBStructureItemJDBC.class));
    }

    public final <T extends DBStructureItem> T getAnc(Class<T> clazz) {
        DBStructureItem res = DBStructureItemDB.class.isAssignableFrom(clazz) ? this.getDB().getAncestor(clazz.asSubclass(DBStructureItemDB.class)) : this.getJDBC().getAncestor(clazz.asSubclass(DBStructureItemJDBC.class));
        return (T)((DBStructureItem)clazz.cast(res));
    }

    public final int getHopsTo(Class<? extends DBStructureItem> clazz) {
        return this.getLevels().getHops(this.getLevel(), this.getServer().getSQLSystem().getLevel(clazz));
    }

    protected final HierarchyLevel getLevel() {
        return HierarchyLevel.get(this.getJDBC().getClass());
    }

    protected abstract EnumOrderedSet<HierarchyLevel> getLevels();

    protected abstract DBStructureItemJDBC getJDBC();

    protected abstract DBStructureItemDB getDB();

    protected final boolean isAlterEgoOf(DBStructureItem o) {
        return o != null && (this == o || this.getJDBC() == o.getJDBC());
    }

    protected static final DBStructureItemJDBC getJDBC(DBStructureItem<?> item) {
        return item == null ? null : item.getJDBC();
    }

    protected static final DBStructureItemDB getDB(DBStructureItem<?> item) {
        return item == null ? null : item.getDB();
    }
}

