/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.DocumentationEditorFrame;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.request.RowItemDesc;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.PopupMouseListener;

public abstract class UISQLComponent
extends BaseSQLComponent {
    private static final String REQ_SUFFIX = System.getProperty("org.openconcerto.sql.requiredSuffix", " *");
    private FormLayouter autoLayouter;
    private final Map<String, JComponent> labels;
    private JPanel currentPanel;
    private JTabbedPane tabbedPane;
    private final int width;
    private final int def;

    public UISQLComponent(SQLElement element) {
        this(element, 2);
    }

    public UISQLComponent(SQLElement element, int width) {
        this(element, width, 0);
    }

    public UISQLComponent(SQLElement element, int width, int def) {
        super(element);
        this.width = width;
        this.def = def;
        this.tabbedPane = null;
        this.currentPanel = this;
        this.autoLayouter = null;
        this.labels = new HashMap<String, JComponent>();
    }

    @Override
    protected void addToUI(final SQLRowItemView obj, String where) {
        JComponent added;
        RowItemDesc rivDesc = this.getRIVDesc(obj.getSQLName());
        String desc = rivDesc.getLabel();
        if (this.getRequired().contains(obj)) {
            desc = String.valueOf(desc) + REQ_SUFFIX;
        }
        if (where == null) {
            where = this.getDefaultWhere(obj);
        }
        if (where == null) {
            added = this.getLayouter().add(desc, obj.getComp());
        } else if (where.equals("bordered")) {
            added = this.getLayouter().addBordered(desc, obj.getComp(), 0);
        } else if (where.equals("left")) {
            this.getLayouter().newLine();
            added = this.getLayouter().add(desc, obj.getComp(), this.getLayouter().getWidth() / 2);
        } else if (where.equals("right")) {
            added = this.getLayouter().add(desc, obj.getComp(), (this.getLayouter().getWidth() + 1) / 2);
        } else {
            int aWidth = Integer.parseInt(where);
            added = this.getLayouter().add(desc, obj.getComp(), aWidth);
        }
        this.labels.put(obj.getSQLName(), added);
        this.updateUI(obj.getSQLName(), rivDesc);
        final JPopupMenu menu = new JPopupMenu();
        menu.add(new AbstractAction("Modifier la documentation"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DocumentationEditorFrame frame = new DocumentationEditorFrame(UISQLComponent.this, obj.getSQLName());
                frame.setDefaultCloseOperation(2);
                frame.setVisible(true);
            }
        });
        added.addMouseListener(new PopupMouseListener(){

            @Override
            protected JPopupMenu createPopup(MouseEvent e) {
                return e.isControlDown() ? menu : null;
            }
        });
    }

    @Override
    protected void updateUI(String itemName, RowItemDesc desc) {
        super.updateUI(itemName, desc);
        UISQLComponent.updateUI(itemName, this.labels.get(itemName), desc);
    }

    private String getDefaultWhere(SQLRowItemView obj) {
        if (this.getElement().getPrivateForeignFields().contains(obj.getField().getName())) {
            return "bordered";
        }
        return null;
    }

    private void setLayouter(int w, int d) {
        this.autoLayouter = new FormLayouter(this.currentPanel, w, d);
        this.setAdditionalFieldsPanel(this.autoLayouter);
    }

    protected final FormLayouter getLayouter() {
        if (this.autoLayouter == null) {
            this.setLayouter(this.width, this.def);
        }
        return this.autoLayouter;
    }
}

