/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.IFieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.utils.Tuple2;

public abstract class FieldExpander {
    private final Map<IFieldPath, List<FieldPath>> cache = new HashMap<IFieldPath, List<FieldPath>>();
    private final Map<List<? extends IFieldPath>, List<Tuple2<Path, List<FieldPath>>>> cacheGroupBy = new HashMap<List<? extends IFieldPath>, List<Tuple2<Path, List<FieldPath>>>>();

    protected void clearCache() {
        this.cache.clear();
        this.cacheGroupBy.clear();
    }

    protected abstract List<SQLField> expandOnce(SQLField var1);

    protected final List<FieldPath> expandOnce(IFieldPath field) {
        List<SQLField> e = this.expandOnce(field.getField());
        if (e == null) {
            return null;
        }
        if (e.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<FieldPath> res = new ArrayList<FieldPath>(e.size());
        Path newPath = new Path(field.getPath());
        newPath.add(field.getField());
        for (SQLField f : e) {
            res.add(new FieldPath(newPath, f.getName()));
        }
        return res;
    }

    public final List<FieldPath> expand(IFieldPath field) {
        if (this.cache.containsKey(field)) {
            return this.cache.get(field);
        }
        ArrayList<FieldPath> fields = new ArrayList<FieldPath>();
        if (!field.getTable().getForeignKeys().contains(field.getField())) {
            fields.add(field.getFieldPath());
        } else {
            List<FieldPath> tmp = this.expandOnce(field);
            if (tmp == null) {
                SQLTable foreignTable = field.getTable().getBase().getGraph().getForeignTable(field.getField());
                throw new IllegalStateException(field + " cannot be expanded by " + this + "\nforeign table of " + field.getField().getSQLName() + ":" + foreignTable.getSQLName());
            }
            for (FieldPath f : tmp) {
                fields.addAll(this.expand(f));
            }
        }
        ArrayList<FieldPath> res = fields;
        this.cache.put(field, res);
        return res;
    }

    public final void expand(SQLRowValues vals) {
        Set<SQLField> fks = vals.getTable().getForeignKeys();
        for (String fName : vals.getFields()) {
            List<SQLField> expandedFields;
            SQLField ffield = vals.getTable().getField(fName);
            if (!fks.contains(ffield) || (expandedFields = this.expandOnce(ffield)).size() <= 0) continue;
            SQLRowValues foreignVals = new SQLRowValues(expandedFields.get(0).getTable());
            vals.put(fName, foreignVals);
            for (SQLField expandedField : expandedFields) {
                foreignVals.put(expandedField.getName(), null);
            }
            this.expand(foreignVals);
        }
    }

    public final List<Tuple2<Path, List<FieldPath>>> expandGroupBy(List<? extends IFieldPath> fieldsOrig) {
        if (this.cacheGroupBy.containsKey(fieldsOrig)) {
            return this.cacheGroupBy.get(fieldsOrig);
        }
        if (fieldsOrig.size() == 0) {
            return Collections.emptyList();
        }
        Path fieldsPath = fieldsOrig.get(0).getPath();
        String parentFF = Configuration.getInstance().getDirectory().getElement(fieldsPath.getLast()).getParentForeignField();
        ArrayList<Tuple2<Path, List<FieldPath>>> res = new ArrayList<Tuple2<Path, List<FieldPath>>>();
        ArrayList<FieldPath> currentL = new ArrayList<FieldPath>();
        res.add(Tuple2.create(fieldsPath, currentL));
        IFieldPath parent = null;
        for (IFieldPath iFieldPath : fieldsOrig) {
            if (iFieldPath.getField().getName().equals(parentFF)) {
                parent = iFieldPath;
                continue;
            }
            currentL.addAll(this.expand(iFieldPath));
        }
        if (parent != null) {
            res.addAll(this.expandGroupBy(this.expandOnce(parent)));
        }
        this.cacheGroupBy.put(fieldsOrig, res);
        return res;
    }
}

