/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;

public class TemplatePreferencePanel
extends DefaultPreferencePanel {
    private JTextField textTemplate;
    private JFileChooser fileChooser = null;
    public static String MULTIMOD = "MultiModele";
    JCheckBox boxMultiMod = new JCheckBox("Activer la gestion multimod\u00e8le");

    public TemplatePreferencePanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
        cPanel.weighty = 0.0;
        cPanel.anchor = 17;
        this.add((Component)new JLabel("Emplacement des mod\u00e8les"), cPanel);
        ++cPanel.gridx;
        cPanel.weightx = 1.0;
        this.textTemplate = new JTextField();
        this.add((Component)this.textTemplate, cPanel);
        JButton buttonTemplate = new JButton("...");
        ++cPanel.gridx;
        cPanel.weightx = 0.0;
        cPanel.fill = 0;
        this.add((Component)buttonTemplate, cPanel);
        ++cPanel.gridy;
        cPanel.gridx = 0;
        this.add((Component)this.boxMultiMod, cPanel);
        JPanel spacer = new JPanel();
        spacer.setOpaque(false);
        ++cPanel.gridy;
        cPanel.weighty = 1.0;
        this.add((Component)spacer, cPanel);
        buttonTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TemplatePreferencePanel.this.directoryChoose("template");
            }
        });
        this.textTemplate.setEditable(false);
        this.setValues();
    }

    @Override
    public String getTitleName() {
        return "Emplacement des mod\u00e8les";
    }

    private void setValues() {
        try {
            File f = new File(TemplateNXProps.getInstance().getStringProperty("LocationTemplate"));
            if (f.exists()) {
                this.textTemplate.setForeground(UIManager.getColor("TextField.foreground"));
            } else {
                this.textTemplate.setForeground(Color.RED);
            }
            this.textTemplate.setText(f.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.boxMultiMod.setSelected(TemplateNXProps.getInstance().getBooleanValue(MULTIMOD, false));
    }

    private void directoryChoose(final String type) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(1);
        }
        this.fileChooser.setCurrentDirectory(new File(this.textTemplate.getText()));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TemplatePreferencePanel.this.fileChooser.showDialog(TemplatePreferencePanel.this, "S\u00e9lectionner") == 0 && type.equalsIgnoreCase("template")) {
                    File selectedFile = TemplatePreferencePanel.this.fileChooser.getSelectedFile();
                    if (selectedFile.exists()) {
                        TemplatePreferencePanel.this.textTemplate.setForeground(UIManager.getColor("TextField.foreground"));
                    } else {
                        TemplatePreferencePanel.this.textTemplate.setForeground(Color.RED);
                    }
                    TemplatePreferencePanel.this.textTemplate.setText(selectedFile.getPath());
                }
            }
        });
    }
}

