/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.preferences;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.report.BalanceSheet;
import org.openconcerto.erp.core.finance.accounting.report.GrandLivreSheet;
import org.openconcerto.erp.core.finance.accounting.report.JournauxSheet;
import org.openconcerto.erp.core.humanresources.payroll.report.EtatChargesPayeSheet;
import org.openconcerto.erp.generationDoc.DefaultLocalTemplateProvider;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.erp.preferences.AbstractGenerationDocumentPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.ui.preferences.TemplateProps;
import org.openconcerto.utils.StreamUtils;

public class TemplateNXProps
extends TemplateProps {
    private static final String societeBaseName = ((ComptaPropsConfiguration)Configuration.getInstance()).getSocieteBaseName();

    @Override
    protected String getPropsFileName() {
        File f = Configuration.getInstance().getConfDir();
        File f2 = new File(f, "Configuration" + File.separator + "Template.properties");
        if (!f2.exists()) {
            InputStream fConf = ComptaBasePropsConfiguration.getStreamStatic("/Configuration/Template.properties");
            if (fConf == null) {
                JOptionPane.showMessageDialog(null, "L'emplacement des mod\u00e9les n'est pas d\u00e9fini.");
            } else {
                try {
                    StreamUtils.copy(fConf, f2);
                    fConf.close();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, "Impossible de copier le fichier de configuration de l'emplacement des mod\u00e9les\ndepuis le serveur, veuillez d\u00e9finir l'emplacement des mod\u00e9les manuellement.");
                    e.printStackTrace();
                }
            }
        }
        if (f2.exists()) {
            return f2.getAbsolutePath();
        }
        try {
            f2.getParentFile().mkdirs();
            f2.createNewFile();
        }
        catch (IOException e) {
            System.err.println(f2);
            e.printStackTrace();
        }
        return f2.getAbsolutePath();
    }

    @Override
    public String getPropertySuffix() {
        return societeBaseName;
    }

    @Override
    public String getDefaultStringValue() {
        Configuration conf = ComptaPropsConfiguration.getInstance();
        SQLRow rowSociete = ((ComptaPropsConfiguration)conf).getRowSociete();
        return String.valueOf(conf.getWD().getAbsolutePath()) + File.separator + rowSociete.getString("NOM") + "-" + rowSociete.getID();
    }

    public void initDocumentLocalStorage() {
        DocumentLocalStorageManager storage = DocumentLocalStorageManager.getInstance();
        String propertyDefaultDirectory = this.getProperty("DefaultOO");
        if (propertyDefaultDirectory == null) {
            System.out.println("Warning: no default directory stored for document output");
            propertyDefaultDirectory = this.getDefaultStringValue();
        }
        storage.setDocumentDefaultDirectory(new File(propertyDefaultDirectory));
        String propertyDefaultPDFDirectory = this.getProperty("DefaultPDF");
        if (propertyDefaultPDFDirectory == null) {
            System.out.println("Warning: no default directory stored for PFD output");
            propertyDefaultPDFDirectory = propertyDefaultDirectory;
        }
        storage.setPDFDefaultDirectory(new File(propertyDefaultPDFDirectory));
        this.register("Devis", "LocationDevis", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("DEVIS"));
        this.register("VenteFacture", "LocationFacture", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("SAISIE_VENTE_FACTURE"));
        this.register("CommandeClient", "LocationCmdCli", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("COMMANDE_CLIENT"));
        this.register("BonLivraison", "LocationBon", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("BON_DE_LIVRAISON"));
        this.register("Avoir", "LocationAvoir", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("AVOIR_CLIENT"));
        this.register("AvoirF", "LocationAvoirF", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("AVOIR_FOURNISSEUR"));
        this.register("Commande", "LocationCmd", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("COMMANDE"));
        this.register("EtatVentes", "Default", null);
        this.register("FicheClient", "Default", null);
        this.register("FicheRelance", "Default", null);
        this.register("ReleveCheque", "LocationReleveChequeCli", null);
        this.register("ListeFacture", "Default", null);
        this.register("ListeVentes", "Default", null);
        this.register(BalanceSheet.TEMPLATE_ID, BalanceSheet.TEMPLATE_PROPERTY_NAME, BalanceSheet.TEMPLATE_ID);
        this.register(GrandLivreSheet.TEMPLATE_ID, GrandLivreSheet.TEMPLATE_PROPERTY_NAME, GrandLivreSheet.TEMPLATE_ID);
        this.register(JournauxSheet.TEMPLATE_ID, JournauxSheet.TEMPLATE_PROPERTY_NAME, JournauxSheet.TEMPLATE_ID);
        this.register(EtatChargesPayeSheet.TEMPLATE_ID, EtatChargesPayeSheet.TEMPLATE_PROPERTY_NAME, "Etat des charges");
        this.register("Fiche de paye", "LocationFichePaye", "Fiche paye");
        this.register("Livre de paye", "LocationLivrePaye", "Livre paye");
        this.register("Courrier", "LocationCourrier", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("COMMANDE"));
        this.register("Pointage", "Default", null);
        this.register("Relance", "LocationRelance", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("RELANCE"));
        this.register("VenteComptoir", "LocationVenteComptoir", AbstractGenerationDocumentPreferencePanel.getLabelFromTable("SAISIE_VENTE_COMPTOIR"));
        this.register("ReleveChequeEmis", "LocationReleveCheque", null);
        storage.dump();
    }

    private void register(String templateId, String propertyBaseName, String defaultSubFolder) {
        if (templateId == null) {
            throw new IllegalArgumentException("null template id");
        }
        if (propertyBaseName == null) {
            throw new IllegalArgumentException("null propertyBaseName");
        }
        if (TemplateManager.getInstance().isKnwonTemplate(templateId)) {
            System.err.println("Warning: registering known template id : " + templateId + " with property base name: " + propertyBaseName);
        }
        DocumentLocalStorageManager storage = DocumentLocalStorageManager.getInstance();
        String propertyOO = this.getProperty(String.valueOf(propertyBaseName) + "OO");
        if (propertyOO != null) {
            storage.addDocumentDirectory(templateId, new File(propertyOO));
        } else if (defaultSubFolder != null && defaultSubFolder.trim().length() > 0) {
            storage.addDocumentDirectory(templateId, new File(storage.getDocumentOutputDirectory("default"), defaultSubFolder));
        }
        String propertyPDF = this.getProperty(String.valueOf(propertyBaseName) + "PDF");
        if (propertyPDF != null) {
            storage.addPDFDirectory(templateId, new File(propertyPDF));
        } else if (defaultSubFolder != null && defaultSubFolder.trim().length() > 0) {
            storage.addDocumentDirectory(templateId, new File(storage.getPDFOutputDirectory("default"), defaultSubFolder));
        }
    }

    public static synchronized TemplateProps getInstance() {
        if (instance == null) {
            instance = new TemplateNXProps();
            ((TemplateNXProps)instance).initDocumentLocalStorage();
            ((TemplateNXProps)instance).initDefaulTemplateProvider();
        }
        return instance;
    }

    private void initDefaulTemplateProvider() {
        String property = this.getProperty("LocationTemplate");
        DefaultLocalTemplateProvider provider = new DefaultLocalTemplateProvider();
        if (property != null) {
            provider.setBaseDirectory(new File(property));
        }
        TemplateManager.getInstance().setDefaultProvider(provider);
        TemplateManager.getInstance().dump();
    }
}

