/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jopendocument.link.Component;
import org.jopendocument.model.OpenDocument;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.PreviewFrame;
import org.openconcerto.erp.generationDoc.DefaultNXDocumentPrinter;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.generationDoc.element.TypeModeleSQLElement;
import org.openconcerto.erp.storage.StorageEngine;
import org.openconcerto.erp.storage.StorageEngines;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.ExceptionHandler;

public abstract class SheetXml {
    private static StorageDirs STORAGE_DIRS;
    protected SQLElement elt;
    protected String printer;
    protected SQLRow row;
    protected SQLRow rowLanguage;
    protected static final SQLBase base;
    protected static final ExecutorService runnableQueue;
    protected static Thread.UncaughtExceptionHandler DEFAULT_HANDLER;

    static {
        base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        runnableQueue = new ThreadPoolExecutor(0, 1, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        DEFAULT_HANDLER = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ExceptionHandler.handle("Erreur de generation", e);
            }
        };
    }

    public Future<SheetXml> showPrintAndExportAsynchronous(final boolean showDocument, final boolean printDocument, final boolean exportToPDF) {
        Callable<SheetXml> c = new Callable<SheetXml>(){

            @Override
            public SheetXml call() throws Exception {
                SheetXml.this.showPrintAndExport(showDocument, printDocument, exportToPDF);
                return SheetXml.this;
            }
        };
        return runnableQueue.submit(c);
    }

    public void showPrintAndExport(boolean showDocument, boolean printDocument, boolean exportToPDF) {
        block10: {
            File generatedFile = this.getGeneratedFile();
            final File pdfFile = this.getGeneratedPDFFile();
            if (generatedFile == null || !generatedFile.exists()) {
                ExceptionHandler.handle("Fichier g\u00e9n\u00e9r\u00e9 manquant: " + generatedFile);
                return;
            }
            try {
                if (!Boolean.getBoolean("org.openconcerto.oo.useODSViewer")) {
                    Component doc = ComptaPropsConfiguration.getOOConnexion().loadDocument(generatedFile, !showDocument);
                    if (printDocument) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("Name", this.printer);
                        doc.printDocument(map);
                    }
                    if (exportToPDF) {
                        doc.saveToPDF(pdfFile).get();
                    }
                    doc.close();
                    break block10;
                }
                OpenDocument doc = new OpenDocument(generatedFile);
                if (showDocument) {
                    this.showPreviewDocument();
                }
                if (printDocument) {
                    DefaultNXDocumentPrinter printer = new DefaultNXDocumentPrinter();
                    printer.print(doc);
                }
                if (!exportToPDF) break block10;
                try {
                    SheetUtils.convert2PDF(doc, pdfFile);
                }
                catch (Throwable e) {
                    ExceptionHandler.handle("Impossible de cr\u00e9er le PDF");
                }
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        List engines = StorageEngines.getInstance().getActiveEngines();
                        for (StorageEngine storageEngine : engines) {
                            if (!storageEngine.isConfigured() || !storageEngine.allowAutoStorage()) continue;
                            try {
                                storageEngine.connect();
                                BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(pdfFile));
                                String path = SheetXml.this.getStoragePath();
                                storageEngine.store((InputStream)inStream, path, pdfFile.getName(), true);
                                inStream.close();
                                storageEngine.disconnect();
                            }
                            catch (IOException e) {
                                ExceptionHandler.handle("Impossible de sauvegarder le PDF");
                            }
                        }
                    }
                });
                t.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionHandler.handle("Impossible de charger le document OpenOffice", e);
            }
        }
    }

    public abstract String getDefaultTemplateId();

    public final String getStoragePath() {
        String res;
        String string = res = STORAGE_DIRS == null ? null : STORAGE_DIRS.getStoragePath(this);
        if (res != null) {
            return res;
        }
        return this.getStoragePathP();
    }

    public final File getDocumentOutputDirectory() {
        File res;
        File file = res = STORAGE_DIRS == null ? null : STORAGE_DIRS.getDocumentOutputDirectory(this);
        if (res != null) {
            return res;
        }
        return this.getDocumentOutputDirectoryP();
    }

    protected abstract String getStoragePathP();

    protected abstract File getDocumentOutputDirectoryP();

    public abstract String getName();

    public String getTemplateId() {
        if (this.row != null && this.row.getTable().getFieldsName().contains("ID_MODELE")) {
            SQLRow rowModele = this.row.getForeignRow("ID_MODELE");
            if (rowModele.isUndefined()) {
                TypeModeleSQLElement typeModele = Configuration.getInstance().getDirectory().getElement(TypeModeleSQLElement.class);
                String modele = typeModele.getTemplateMapping().get(this.row.getTable().getName());
                if (modele == null) {
                    System.err.println("No default modele in table TYPE_MODELE for table " + this.row.getTable().getName());
                    Thread.dumpStack();
                    return this.getDefaultTemplateId();
                }
                return modele;
            }
            return rowModele.getString("NOM");
        }
        return this.getDefaultTemplateId();
    }

    public abstract Future<SheetXml> createDocumentAsynchronous();

    public abstract File getGeneratedFile();

    public File getGeneratedPDFFile() {
        return SheetUtils.getFileWithExtension(this.getGeneratedFile(), ".pdf");
    }

    public SQLRow getRowLanguage() {
        return this.rowLanguage;
    }

    public File getOrCreateDocumentFile() throws Exception {
        File f = this.getGeneratedFile();
        if (!f.exists()) {
            return this.createDocumentAsynchronous().get().getGeneratedFile();
        }
        return f;
    }

    public void showPreviewDocument() throws Exception {
        File f = null;
        f = this.getOrCreateDocumentFile();
        PreviewFrame.show(f);
    }

    static String getValidFileName(String fileName) {
        StringBuffer result = new StringBuffer(fileName.length());
        int i = 0;
        while (i < fileName.length()) {
            char ch = fileName.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_' || ch == ' ') {
                result.append(ch);
            } else {
                result.append('-');
            }
            ++i;
        }
        return result.toString();
    }

    public static interface StorageDirs {
        public File getDocumentOutputDirectory(SheetXml var1);

        public String getStoragePath(SheetXml var1);
    }
}

