/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jdom.Element;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.generationDoc.OOXMLCache;
import org.openconcerto.erp.generationDoc.OOXMLElement;
import org.openconcerto.map.model.Ville;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.Nombre;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;

public class OOXMLField
extends OOXMLElement {
    private String op = "";

    public OOXMLField(Element eltField, SQLRowAccessor row, SQLElement sqlElt, int id, SQLRow rowLanguage) {
        super(eltField, sqlElt, id, rowLanguage);
        String base = eltField.getAttributeValue("base");
        this.op = eltField.getAttributeValue("op");
        this.row = row;
        if ((this.row == null || !this.row.getTable().getSchema().getName().equalsIgnoreCase("Common")) && base != null && base.equalsIgnoreCase("COMMON")) {
            this.row = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        }
        if (this.row == null) {
            this.row = sqlElt.getTable().getRow(id);
        }
    }

    @Override
    public Object getValue() {
        if (this.row != null && !this.row.isUndefined()) {
            boolean bIsCondValid;
            List excludeValue;
            String field = this.elt.getAttributeValue("name");
            SQLField sqlField = this.row.getTable().getField(field);
            boolean isForeignField = this.row.getTable().getForeignKeys().contains(sqlField);
            if (isForeignField && this.elt.getChild("field") != null) {
                Boolean boolean1;
                String condField = this.elt.getAttributeValue("conditionField");
                if (!(condField == null || this.row.getTable().getField(condField).getType().getJavaType() != Boolean.class || (boolean1 = this.row.getBoolean(condField)) != null && boolean1.booleanValue())) {
                    return null;
                }
                SQLRowAccessor foreignRow = OOXMLCache.getForeignRow(this.row, sqlField);
                if (foreignRow != null && foreignRow.getID() > 1) {
                    List children = this.elt.getChildren("field");
                    if (children.size() > 1) {
                        if (this.isValid()) {
                            String result = "";
                            for (Element ssComposant : children) {
                                OOXMLField childElt = new OOXMLField(ssComposant, foreignRow, this.sqlElt, this.id, this.rowLanguage);
                                Object valueComposantO = childElt.getValue();
                                result = String.valueOf(result) + (valueComposantO == null ? "" : String.valueOf(valueComposantO.toString()) + " ");
                            }
                            String cellSize = this.elt.getAttributeValue("cellSize");
                            if (cellSize != null && cellSize.trim().length() != 0) {
                                result = this.splitStringCell(cellSize, result);
                            }
                            return result.trim();
                        }
                        return "";
                    }
                    if (this.isValid()) {
                        OOXMLField childElt = new OOXMLField(this.elt.getChild("field"), foreignRow, this.sqlElt, this.id, this.rowLanguage);
                        return childElt.getValue();
                    }
                    return "";
                }
                return null;
            }
            if (this.op != null && this.op.trim().length() > 0) {
                String field2 = this.elt.getAttributeValue("name2");
                String typeComp = this.elt.getAttributeValue("type");
                Number o = (Number)this.row.getObject(field);
                Number o2 = field2 != null && field2.trim().length() > 0 ? (Number)((Number)this.row.getObject(field2)) : (Number)Double.parseDouble(this.elt.getAttributeValue("number"));
                if (typeComp != null && typeComp.trim().length() > 0 && typeComp.equalsIgnoreCase("Devise")) {
                    long result = Math.round(OOXMLField.calcul(o, o2, this.op).doubleValue());
                    return Double.valueOf(GestionDevise.currencyToString(result, false));
                }
                return OOXMLField.calcul(o, o2, this.op);
            }
            List<String> listOfExcludedValues = null;
            if (this.elt.getAttributeValue("valuesExpected") != null) {
                listOfExcludedValues = SQLRow.toList(this.elt.getAttributeValue("valuesExpected"));
            }
            if ((excludeValue = this.elt.getChildren("exclude")) != null && excludeValue.size() > 0) {
                listOfExcludedValues = listOfExcludedValues == null ? new ArrayList<String>() : new ArrayList<String>(listOfExcludedValues);
                for (Element element : excludeValue) {
                    String attributeValue = element.getAttributeValue("value");
                    listOfExcludedValues.add(attributeValue);
                }
            }
            String condField = this.elt.getAttributeValue("conditionField");
            String condValue = this.elt.getAttributeValue("conditionExpValue");
            boolean bl = bIsCondValid = condValue == null || !this.row.getObject(condField).toString().equalsIgnoreCase(condValue);
            if (condValue == null) {
                Boolean boolean1;
                boolean bIsBooleanCondValid = false;
                if (condField == null) {
                    bIsBooleanCondValid = true;
                } else if (this.row.getTable().getField(condField).getType().getJavaType() == Boolean.class && (boolean1 = this.row.getBoolean(condField)) != null && boolean1.booleanValue()) {
                    bIsBooleanCondValid = true;
                }
                bIsCondValid = bIsCondValid && bIsBooleanCondValid;
            } else {
                System.err.println();
            }
            if (bIsCondValid) {
                String stringValue;
                String typeComp = this.elt.getAttributeValue("type");
                Object o = this.getSpecialValue(typeComp);
                if (o != null) {
                    if (this.elt.getAttributeValue("upperCase") != null) {
                        o = o.toString().toUpperCase();
                    }
                    stringValue = o.toString();
                } else {
                    Object o2 = this.row.getObject(field);
                    String string = stringValue = o2 == null ? "" : o2.toString();
                }
                if (listOfExcludedValues == null || !listOfExcludedValues.contains(stringValue) && stringValue.trim().length() > 0) {
                    String prefix = this.elt.getAttributeValue("prefix");
                    String suffix = this.elt.getAttributeValue("suffix");
                    String display = this.elt.getAttributeValue("display");
                    String cellSize = this.elt.getAttributeValue("cellSize");
                    if (prefix != null || suffix != null) {
                        String result = "";
                        if (prefix != null) {
                            if (prefix.contains("#n")) {
                                prefix = prefix.replaceAll("#n", "\n");
                            }
                            result = String.valueOf(result) + prefix;
                        }
                        if (display == null || !display.equalsIgnoreCase("false")) {
                            result = String.valueOf(result) + stringValue;
                        }
                        if (suffix != null) {
                            result = String.valueOf(result) + suffix;
                        }
                        if (cellSize != null && cellSize.trim().length() != 0) {
                            result = this.splitStringCell(cellSize, result);
                        }
                        return result;
                    }
                    if (display == null || !display.equalsIgnoreCase("false")) {
                        return o == null ? "" : o;
                    }
                    return "";
                }
            }
        }
        return null;
    }

    private String splitStringCell(String cellSize, String result) {
        try {
            int nbCar = Integer.parseInt(cellSize);
            result = StringUtils.splitString(result, nbCar);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected Object getSpecialValue(String typeComp) {
        String stringValue;
        String field = this.elt.getAttributeValue("name");
        Object result = this.row.getObject(field);
        List<String> listOfExpectedValues = null;
        if (this.elt.getAttributeValue("valuesExpected") != null) {
            listOfExpectedValues = SQLRow.toList(this.elt.getAttributeValue("valuesExpected"));
        }
        String string = stringValue = result == null ? "" : result.toString();
        if (typeComp != null && typeComp.trim().length() > 0) {
            if (typeComp.equalsIgnoreCase("NumeroEcheance")) {
                SQLSelect sel = new SQLSelect(this.row.getTable().getBase());
                sel.addSelect(this.row.getTable().getKey(), "COUNT");
                Where w = new Where((FieldRef)this.row.getTable().getField("DATE"), "<=", (Object)this.row.getDate("DATE").getTime());
                sel.setWhere(w);
                return this.row.getTable().getBase().getDataSource().executeScalar(sel.asString());
            }
            if (typeComp.equalsIgnoreCase("Devise")) {
                Number prix = (Number)result;
                if (listOfExpectedValues != null) {
                    for (String string2 : listOfExpectedValues) {
                        Long l = Long.parseLong(string2);
                        if (l.longValue() != prix.longValue()) continue;
                        return "";
                    }
                }
                return new Double(GestionDevise.currencyToString(prix.longValue(), false));
            }
            if (typeComp.equalsIgnoreCase("globalAcompte")) {
                Long prix = (Long)result;
                int pourcent = this.row.getInt("POURCENT_ACOMPTE");
                long l = Math.round((double)prix.longValue() / ((double)pourcent / 100.0));
                return new Double(GestionDevise.currencyToString(l, false));
            }
            if (typeComp.equalsIgnoreCase("CumulPrec")) {
                long cumulPrecedent = OOXMLField.getCumulPrecedent(this.row);
                return new Double(GestionDevise.currencyToString(cumulPrecedent, false));
            }
            if (typeComp.equalsIgnoreCase("DeviseLettre")) {
                Long prix = (Long)result;
                return OOXMLField.getLettreFromDevise(prix, Nombre.FR, Tuple2.create(" euros ", " cents"));
            }
            if (typeComp.equalsIgnoreCase("DeviseLettreEng")) {
                Long prix = (Long)result;
                SQLRowAccessor tarif = this.row.getForeign("ID_TARIF");
                if (tarif.isUndefined()) {
                    return OOXMLField.getLettreFromDevise(prix, Nombre.EN, Tuple2.create(" euros ", " cents"));
                }
                SQLRowAccessor rowDevise = tarif.getForeign("ID_DEVISE");
                if (rowDevise.isUndefined()) {
                    return OOXMLField.getLettreFromDevise(prix, Nombre.EN, Tuple2.create(" euros ", " cents"));
                }
                return OOXMLField.getLettreFromDevise(prix, Nombre.EN, Tuple2.create(" " + rowDevise.getString("LIBELLE") + " ", " " + rowDevise.getString("LIBELLE_CENT") + " "));
            }
            if (typeComp.equalsIgnoreCase("Ville")) {
                stringValue = result == null ? "" : result.toString();
                String ville = OOXMLField.getVille(stringValue);
                if (ville == null) {
                    return stringValue;
                }
                return ville;
            }
            if (typeComp.equalsIgnoreCase("VilleCP")) {
                stringValue = result == null ? "" : result.toString();
                return OOXMLField.getVilleCP(stringValue, this.row);
            }
            if (typeComp.equalsIgnoreCase("DateEcheance")) {
                int idModeReglement = this.row.getInt("ID_MODE_REGLEMENT");
                Date d = (Date)this.row.getObject("DATE");
                return this.getDateEcheance(idModeReglement, d);
            }
            if (typeComp.equalsIgnoreCase("Jour")) {
                int day = this.row.getInt(field);
                stringValue = "le " + String.valueOf(day);
                if (day == 31) {
                    return "fin de mois";
                }
                if (day == 0) {
                    return "Date de facture";
                }
                return stringValue;
            }
            if (typeComp.equalsIgnoreCase("Date")) {
                String datePattern = this.elt.getAttributeValue("DatePattern");
                if (datePattern == null || datePattern.trim().length() == 0) {
                    datePattern = "dd/MM/yyyy";
                }
                SimpleDateFormat format = new SimpleDateFormat(datePattern);
                if (result != null) {
                    Date d = (Date)result;
                    return format.format(d);
                }
                return "";
            }
            if (typeComp.equalsIgnoreCase("initiale")) {
                String string3 = stringValue = result == null ? "" : result.toString();
                if (stringValue.trim().length() > 0) {
                    stringValue = String.valueOf(stringValue.charAt(0));
                }
                return stringValue;
            }
        }
        return result == null ? "" : result;
    }

    public boolean isValid() {
        boolean bIsCondValid;
        String condField = this.elt.getAttributeValue("conditionField");
        String condValue = this.elt.getAttributeValue("conditionExpValue");
        boolean bIsBooleanCondValid = condField == null || this.row.getTable().getField(condField).getType().getJavaType() == Boolean.class && this.row.getBoolean(condField) != false;
        boolean bl = bIsCondValid = condValue == null || this.row.getObject(condField).toString().equalsIgnoreCase(condValue);
        return bIsBooleanCondValid || !bIsCondValid;
    }

    private static long getCumulPrecedent(SQLRowAccessor rowFact) {
        long cumul = 0L;
        SQLTable tableElt = Configuration.getInstance().getRoot().findTable("SAISIE_VENTE_FACTURE_ELEMENT");
        Collection<? extends SQLRowAccessor> factElts = rowFact.getReferentRows(tableElt);
        for (SQLRowAccessor sQLRowAccessor : factElts) {
            SQLRowAccessor foreign = sQLRowAccessor.getForeign("ID_MISSION");
            if (foreign.getID() <= 1) continue;
            Collection<? extends SQLRowAccessor> rowsElt = foreign.getReferentRows(tableElt);
            for (SQLRowAccessor sQLRowAccessor2 : rowsElt) {
                SQLRowAccessor rowFacture = sQLRowAccessor2.getForeign("ID_SAISIE_VENTE_FACTURE");
                if (!rowFacture.getDate("DATE").before(rowFact.getDate("DATE"))) continue;
                cumul += sQLRowAccessor2.getLong("T_PV_HT");
            }
        }
        return cumul;
    }

    private static String getLettreFromDevise(long value, int langue, Tuple2<String, String> deviseName) {
        StringBuffer result = new StringBuffer();
        Long decimal = value % 100L;
        Long entier = value / 100L;
        Nombre n1 = new Nombre(entier.intValue(), langue);
        Nombre n2 = new Nombre(decimal.intValue(), langue);
        result.append(String.valueOf(n1.getText()) + " " + deviseName.get0().trim());
        if (decimal.intValue() > 0) {
            result.append(String.valueOf(langue == Nombre.FR ? " et " : " and ") + n2.getText() + deviseName.get1());
        }
        if (result != null && result.length() > 0) {
            return result.toString().replaceFirst(String.valueOf(result.charAt(0)), String.valueOf(result.charAt(0)).toUpperCase());
        }
        return result.toString();
    }

    private static String getVille(String name) {
        Ville ville = Ville.getVilleFromVilleEtCode((String)name);
        if (ville == null) {
            return null;
        }
        return ville.getName();
    }

    private static String getVilleCP(String name, SQLRowAccessor row) {
        Ville ville = Ville.getVilleFromVilleEtCode((String)name);
        if (ville == null) {
            if (row.getTable().contains("CODE_POSTAL")) {
                Object o = row.getObject("CODE_POSTAL");
                return o == null ? null : o.toString();
            }
            return null;
        }
        return ville.getCodepostal();
    }

    private static Number calcul(Object o1, Object o2, String op) {
        double d2;
        double d1 = o1 == null ? 0.0 : Double.parseDouble(o1.toString());
        double d = d2 = o2 == null ? 0.0 : Double.parseDouble(o2.toString());
        if (op.equalsIgnoreCase("+")) {
            return d1 + d2;
        }
        if (op.equalsIgnoreCase("-")) {
            return d1 - d2;
        }
        if (op.equalsIgnoreCase("*")) {
            return d1 * d2;
        }
        if (op.equalsIgnoreCase("/") && d2 != 0.0) {
            return d1 / d2;
        }
        return 0;
    }
}

