/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jdom.Element;
import org.openconcerto.erp.core.finance.payment.element.ModeDeReglementSQLElement;
import org.openconcerto.erp.generationDoc.OOXMLField;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.GestionDevise;

public class OOXMLElement {
    protected Element elt;
    protected SQLElement sqlElt;
    protected int id;
    protected SQLRowAccessor row = null;
    protected SQLRow rowLanguage;
    public static DateFormat format = new SimpleDateFormat("dd/MM/yyyy");

    public OOXMLElement(Element elt, SQLElement sqlElt, int id, SQLRow rowLanguage) {
        this.elt = elt;
        this.sqlElt = sqlElt;
        this.id = id;
        this.rowLanguage = rowLanguage;
    }

    public OOXMLElement(Element elt, SQLElement sqlElt, int id, SQLRowAccessor row, SQLRow rowLanguage) {
        this.elt = elt;
        this.sqlElt = sqlElt;
        this.id = id;
        this.row = row;
        this.rowLanguage = rowLanguage;
    }

    public Object getValue() {
        Object res = "";
        String attributeValue = this.elt.getAttributeValue("type");
        if (attributeValue.equalsIgnoreCase("InitialesUtilisateur")) {
            return this.getInitialesUser();
        }
        if (attributeValue.equalsIgnoreCase("InitialesUtilisateurModif")) {
            return this.getInitialesUserModify();
        }
        if (attributeValue.equalsIgnoreCase("InitialesUtilisateurCreate")) {
            return this.getInitialesUserCreate();
        }
        if (attributeValue.equalsIgnoreCase("TotalHTTable")) {
            return this.getTotalHTTable(this.row);
        }
        if (attributeValue.equalsIgnoreCase("DateEcheance")) {
            int idModeReglement = this.row.getInt("ID_MODE_REGLEMENT");
            Date d = (Date)this.row.getObject("DATE");
            return this.getDateEcheance(idModeReglement, d);
        }
        List eltFields = this.elt.getChildren("field");
        if (eltFields != null) {
            if (eltFields.size() > 1) {
                String result = "";
                for (Element eltField : eltFields) {
                    OOXMLField field = new OOXMLField(eltField, this.row, this.sqlElt, this.id, this.rowLanguage);
                    Object value = field.getValue();
                    if (value == null) continue;
                    result = String.valueOf(result) + value.toString() + " ";
                }
                res = result;
            } else {
                OOXMLField field = new OOXMLField((Element)eltFields.get(0), this.row, this.sqlElt, this.id, this.rowLanguage);
                res = field.getValue();
            }
        }
        return res;
    }

    private String getInitialesUserModify() {
        SQLRowAccessor rowUser = this.row.getForeign("ID_USER_COMMON_MODIFY");
        String s = rowUser.getString("NOM");
        String s2 = rowUser.getString("PRENOM");
        StringBuffer result = new StringBuffer(4);
        if (s2 != null && s2.trim().length() > 0) {
            result.append(s2.charAt(0));
        }
        if (s != null && s.trim().length() > 0) {
            result.append(s.charAt(0));
        }
        return result.toString();
    }

    private String getInitialesUserCreate() {
        SQLRowAccessor rowUser = this.row.getForeign("ID_USER_COMMON_CREATE");
        String s = rowUser.getString("NOM");
        String s2 = rowUser.getString("PRENOM");
        StringBuffer result = new StringBuffer(4);
        if (s2 != null && s2.trim().length() > 0) {
            result.append(s2.charAt(0));
        }
        if (s != null && s.trim().length() > 0) {
            result.append(s.charAt(0));
        }
        return result.toString();
    }

    private String getInitialesUser() {
        String s = UserManager.getInstance().getCurrentUser().getLastName();
        String s2 = UserManager.getInstance().getCurrentUser().getName();
        StringBuffer result = new StringBuffer(4);
        if (s2 != null && s2.trim().length() > 0) {
            result.append(s2.charAt(0));
        }
        if (s != null && s.trim().length() > 0) {
            result.append(s.charAt(0));
        }
        return result.toString();
    }

    public Double getTotalHTTable(SQLRowAccessor rowFact) {
        SQLTable tableElt = Configuration.getInstance().getRoot().findTable("SAISIE_VENTE_FACTURE_ELEMENT");
        Collection<? extends SQLRowAccessor> set = rowFact.getReferentRows(tableElt);
        long total = 0L;
        for (SQLRowAccessor sQLRowAccessor : set) {
            total += sQLRowAccessor.getLong("T_PV_HT");
        }
        return new Double(GestionDevise.currencyToString(total, false));
    }

    protected String getDateEcheance(int idModeRegl, Date currentDate) {
        int nJ;
        SimpleDateFormat format2 = new SimpleDateFormat("dd/MM/yyyy");
        SQLElement eltModeRegl = Configuration.getInstance().getDirectory().getElement("MODE_REGLEMENT");
        SQLRow row = eltModeRegl.getTable().getRow(idModeRegl);
        int aJ = row.getInt("AJOURS");
        if (aJ + (nJ = row.getInt("LENJOUR")) == 0) {
            if (row.getBoolean("DATE_FACTURE").booleanValue()) {
                return Configuration.getInstance().getTranslator().getLabelFor(row.getTable().getField("DATE_FACTURE"));
            }
            return " ";
        }
        String s = format2.format(ModeDeReglementSQLElement.calculDate(aJ, nJ, currentDate));
        System.err.println(s);
        return s;
    }

    public boolean isTypeReplace() {
        return this.elt.getAttributeValue("type").equalsIgnoreCase("Replace");
    }

    public String getReplacePattern() {
        return this.elt.getAttributeValue("replacePattern");
    }

    public boolean isMultilineAuto() {
        String multiLineValue = this.elt.getAttributeValue("controleMultiline");
        return multiLineValue == null ? true : !multiLineValue.equalsIgnoreCase("false");
    }
}

