/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.io.File;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.generationDoc.OOgenerationXML;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.generationDoc.TemplateManager;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.utils.StringUtils;

public abstract class AbstractSheetXml
extends SheetXml {
    private File generatedOpenDocumentFile;

    public AbstractSheetXml(SQLRow row) {
        this.row = row;
    }

    @Override
    public final Future<SheetXml> createDocumentAsynchronous() {
        Callable<SheetXml> c = new Callable<SheetXml>(){

            @Override
            public SheetXml call() throws Exception {
                try {
                    String templateId;
                    final String modeleFinal = templateId = AbstractSheetXml.this.getTemplateId();
                    String langage = AbstractSheetXml.this.getRowLanguage() != null ? AbstractSheetXml.this.getRowLanguage().getString("CHEMIN") : null;
                    InputStream templateStream = TemplateManager.getInstance().getTemplate(templateId, langage, AbstractSheetXml.this.getType());
                    if (templateStream == null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(null, "Impossible de trouver le modele " + modeleFinal + ". \n Le mod\u00e9le par d\u00e9faut sera utilis\u00e9!");
                            }
                        });
                        templateId = AbstractSheetXml.this.getDefaultTemplateId();
                    }
                    AbstractSheetXml.this.generatedOpenDocumentFile = OOgenerationXML.createDocument(templateId, AbstractSheetXml.this.getDocumentOutputDirectory(), AbstractSheetXml.getValidFileName(AbstractSheetXml.this.getName()), AbstractSheetXml.this.row, AbstractSheetXml.this.getRowLanguage());
                }
                catch (Exception e) {
                    DEFAULT_HANDLER.uncaughtException(null, e);
                    throw e;
                }
                catch (Throwable e) {
                    DEFAULT_HANDLER.uncaughtException(null, e);
                }
                return AbstractSheetXml.this;
            }
        };
        return runnableQueue.submit(c);
    }

    public String getType() {
        return null;
    }

    @Override
    public String getStoragePathP() {
        return StringUtils.firstUp(this.elt.getPluralName());
    }

    @Override
    public File getGeneratedFile() {
        if (this.generatedOpenDocumentFile == null) {
            this.generatedOpenDocumentFile = new File(this.getDocumentOutputDirectory(), String.valueOf(AbstractSheetXml.getValidFileName(this.getName())) + ".ods");
        }
        return this.generatedOpenDocumentFile;
    }
}

